package gov.va.caret.model.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import com.liferay.util.portlet.PortletProps;

import gov.va.caret.controller.dashboard.config.CbopcDashboardConfig;
import gov.va.caret.util.Toolbox;
import gov.va.caret.workflow.WorkName;

public enum WorkType {
	ONLINE_APP(getDouble(PortletProps.get("onlineApp.due.days"), 1.0 ), true, true),
	CSC_APP(getDouble(PortletProps.get("cscApp.due.days"), 1.0 ), true, true),
	HEC_APP(getDouble(PortletProps.get("cscApp.due.days"), 1.0 ), true, true),
	FACILITY_APP(getDouble(PortletProps.get("facilityApp.due.days"), 1.0 )),
	SOC( getDouble(PortletProps.get("soc.due.days"), 25.0 )),
	SOC_FOLLOWUP( getDouble(PortletProps.get("soc.followup.due.days"), -1.0 )),
	CESP(getDouble(PortletProps.get("cesp.due.days"), -1.0 )),
	CESP_CSC(getDouble(PortletProps.get("cesp.csc.due.days"), -1.0 )),
	REFERRAL(getDouble(PortletProps.get("referral.due.days"), 5.0 ), true, true),
	HEC_REFERRAL(getDouble(PortletProps.get("referral.due.days"), 5.0 ), true, true),
	HRC_REFERRAL(getDouble(PortletProps.get("referral.due.days"), 5.0 ), false, true),
	CSL_REFERRAL(getDouble(PortletProps.get("referral.due.days"), 5.0 ), true, true),
	CALL_REFERRAL(getDouble(PortletProps.get("callReferral.due.days"), 5.0 ), true, false),
	HOME_VISIT(getDouble(PortletProps.get("homeVisit.due.days"), 10.0 ), true, false),	
	APP_DELAY(getDouble(PortletProps.get("visn.waiver.days"), 121.0 ), true, false, getDouble( PortletProps.get("visn.approval.days"), 20) ),
	DELAY_REVIEWED(getDouble(PortletProps.get("visn.approval.highlight.days"), 5.0 ), true, false),
	CSC_WAIVER(getDouble(PortletProps.get("csc.waiver.days"), 90.0 )),
	APPEAL(getDouble(PortletProps.get("csc.appeal.days"), -1 ), true, true),
	FAILED_TIU_NOTE(-1, true, false),
	TIU_NOTE_REWRITE(-1, true, false),
	VENDOR_CREATE_HOLD( 1, WorkName.HELD_PAYMENT, true),//15 BUSINESS_DAYS...per stakeholder input 03/29/18
	VENDOR_UPDATE_HOLD( 1, WorkName.HELD_PAYMENT, true),
	VENDOR_CREATE(1, WorkName.VENDOR_CREATE, true),
	VENDOR_UPDATE(1, WorkName.VENDOR_UPDATE, true),
	APPROVED_DISPOSITION(1, WorkName.APPROVED_DISPOSITION, true),
	REVOKED_DISPOSITION(1, WorkName.REVOKED_DISPOSITION, true),
	REINSTATED_DISPOSITION(1, WorkName.REINSTATED_DISPOSITION, true),
	TIER_UPDATE(1, WorkName.TIER_UPDATE, true), 
	ADDRESS_CHANGE(1, WorkName.INFO_CHANGE, true),
	VCG_TRANSFER(-1), 
	C_INFO_CHANGE(1, WorkName.INFO_CHANGE, false),
	V_INFO_CHANGE(1, WorkName.INFO_CHANGE, false),
	VCG_INFO_CHANGE(1, WorkName.INFO_CHANGE, false),
	PII_CHANGE(1, WorkName.INFO_CHANGE, false),
	NAME_CHANGE(1, WorkName.INFO_CHANGE, false),
	INSURANCE_CHANGE(1, WorkName.INSURANCE_CHANGE, false),
	FACILITY_CHANGE(-1),
	GENERAL_CG_ASSIGNMENT(-1),
	DEATH_NOTIFICATION(-1), 
	DUPLICATE_PAYMENT(true, 1, WorkName.DUPLICATE_PAYMENT, false),
	RECOUPMENT(true, 1, WorkName.RECOUPMENT, false), 
	HELD_PAYMENT(true, 1, WorkName.HELD_PAYMENT, false), 
	MANUAL_PAYMENT(true, 1, WorkName.MANUAL_PAYMENT, false), 
	LOST_CHECK(true, 1, WorkName.LOST_CHECK, false), 
	RETURNED_PAYMENT(true, 1, WorkName.RETURNED_PAYMENT, false), // AKA "Manual" Rejected Payment
	REJECTED_PAYMENT(true, 1, WorkName.REJECTED_PAYMENT, false); // AKA "Automatic" Rejected Payment
	
	double days;
	double expires = -1;
	int dayRule = TYPE_CALENDAR_DAYS;
	long queId = 0;
	boolean filterRegistered = false;
	boolean isDocType = false;
	public WorkName workName;
	boolean manualWork = false;
	
	public static final long DUPLICATE_APPLICATION_CODE = -1;
	public static final long INVALID_APPLICATION_CODE = -2;
	public static final int TYPE_CALENDAR_DAYS = 0;
	public static final int TYPE_BUSINESS_DAYS = 1;

	
	WorkType( double days, int type, boolean filterRegistered, boolean isDocType ){
		this( days, filterRegistered, isDocType );
		this.dayRule = type;
	}
	WorkType( double days, boolean filterRegistered, boolean isDocType ){
		this.isDocType = isDocType;
		this.days = days;
		this.filterRegistered = filterRegistered;
	}
	
	WorkType( double days, boolean isDocType ){
		this.isDocType = isDocType;
		this.days = days;
	}
	
	WorkType( double days, boolean filterRegistered, boolean isDocType, double expiration  ){
		this.isDocType = isDocType;
		this.days = days;
		this.filterRegistered = filterRegistered;
		this.expires = expiration;
	}
	
	WorkType( boolean manualWork, WorkName workName, boolean filterRegistered ){
		this.workName = workName;
		this.filterRegistered = filterRegistered;
		this.manualWork = manualWork;
	}
	
	WorkType( boolean manualWork,int type, WorkName workName, boolean filterRegistered ){
		this.workName = workName;
		this.filterRegistered = filterRegistered;
		this.manualWork = manualWork;
	}
	
	WorkType( WorkName workName, boolean filterRegistered ){
		this.workName = workName;
		this.filterRegistered = filterRegistered;
	}
	
	WorkType( int type, WorkName occWorkName, boolean filterRegistered ){
		this.dayRule = type;
		this.workName = occWorkName;
		this.days = getDouble(PortletProps.get(occWorkName + ".due.days"), CbopcDashboardConfig.OCC_DUE_DAYS );
		this.filterRegistered = filterRegistered;
	}
	
	WorkType( double days ){
		this.days = days;
	}

	private static double getDouble(String string, double d) {
		if ( string == null || string.isEmpty() ){
			return d;
		}
		try{
			return Double.valueOf(string);
		} catch ( NumberFormatException nfe ){}
		return d;
	}
	
	public Date getExpirationDate(Date currDate) {
		if ( dayRule == TYPE_BUSINESS_DAYS ) {
			return getBusinessExpiresDate(currDate);
		}
		if ( expires == -1 ){
			return null;
		}
		return Toolbox.adjustDate(expires, currDate, true);
	}

	public Date getDueDate(Date createDate) {
		if ( dayRule == TYPE_BUSINESS_DAYS ) {
			return getBusinessDueDate(createDate);
		}
		if ( days == -1 ){
			return null;
			//return createDate;
		}
		return Toolbox.adjustDate(days, createDate, true);
	}
	
	public Date getBusinessDueDate(Date startDate)
	{
		if ( days == -1 ){
			return null;
		}else{
			return Toolbox.adjustBusinessDate(days, startDate, true);			
		}
	}
	
	public Date getBusinessExpiresDate(Date startDate){
		if ( expires == -1 ){
			return null;
		}else{
			return Toolbox.adjustBusinessDate(expires, startDate, true);			
		}
	}
	
	public boolean isDocType(){
		return isDocType;
	}
	
	public boolean canManualWork(){
		return manualWork;
	}
	
	public static List<WorkType> getFilterRegistered(){
		List<WorkType> list = new ArrayList<WorkType>();
		for ( WorkType workType: WorkType.values() ){
			if ( workType.filterRegistered ){
				list.add(workType);
			}
		}
		Collections.sort(list);
		return list;
	}
	
}