package gov.va.caret.model.support;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.portlet.PortletRequest;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.dashboard.config.CbopcDashboardConfig;
import gov.va.caret.controller.dashboard.config.DashboardConfig;
import gov.va.caret.controller.dashboard.config.FacilityDashboardConfig;
import gov.va.caret.model.AudLg;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Docum;
import gov.va.caret.model.FmsIc;
import gov.va.caret.model.LumCg;
import gov.va.caret.model.Note;
import gov.va.caret.model.PayLg;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.Vendr;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.WorImWrapper;
import gov.va.caret.model.WorSe;
import gov.va.caret.model.impl.BgLaeImpl;
import gov.va.caret.model.impl.BoxGpImpl;
import gov.va.caret.model.impl.VendrImpl;
import gov.va.caret.model.impl.WorImImpl;
import gov.va.caret.model.impl.WorSeImpl;
import gov.va.caret.model.support.Person.Role;
import gov.va.caret.model.support.occ.AddressChange;
import gov.va.caret.model.support.occ.CalculationInfo;
import gov.va.caret.model.support.occ.FinalPayment;
import gov.va.caret.model.support.occ.InitialPayment;
import gov.va.caret.model.support.occ.Reinstatement;
import gov.va.caret.model.support.occ.StipendConfig;
import gov.va.caret.model.support.occ.TierChange;
import gov.va.caret.model.support.occ.UnchangedPayment;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.FacilLocalServiceUtil;
import gov.va.caret.service.FmsIcLocalServiceUtil;
import gov.va.caret.service.LumCgLocalServiceUtil;
import gov.va.caret.service.PayLgLocalServiceUtil;
import gov.va.caret.service.StiPtLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.service.VendrLocalServiceUtil;
import gov.va.caret.service.WorSeLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;
import gov.va.caret.workflow.OwnerQueue;
import gov.va.caret.workflow.QueAction;

public class WorkItemSupport extends WorImWrapper {

	public static final WorkItemSupport DEFAULT_WORKITEM = new WorkItemSupport( new WorImImpl() );
	
	private static Log _log = LogFactoryUtil.getLog( WorkItemSupport.class );
	String personName = null;
	String caregiverName = null;
	private Map<String,BgLae> customAttributes = new HashMap<String,BgLae>();
	private Boolean docLoaded = null;
	private WorkType workType = null;
	private Map<String,Note> notes = new HashMap<String,Note>();
	private Person caregiver = null;
	private Vendor vendor = null;
	private Veteran veteran = null;
	private VcgSupport vcgSupport = null;
	private CalculationInfo calcInfo = null;
	private StiPt stiPt = null;
	private StiPt recurringPrevious = null;
	private boolean multiLine = false;
	private List<LumCg> multiStiPt = null;
	private boolean viewMember = true;

	
	private static final long serialVersionUID = 1L;
	private static final int NOTE_FIELD_LENGTH = 75;
	private static final int BG_LEA_FIELD_LENGTH = 75;
	public static final int WORK_ITEM_SUPPORT_NOTE_LENGTH = 75;
	public static final BigDecimal BIG_35 = new BigDecimal(35000);
	
	public static final String[] CSC_WORK_STATUSES = new String[] { WorkStatus.COMPLETE.name(), "IN_APPEAL", WorkStatus.IN_PROCESS.name(), WorkStatus.NEW.name(), "TRANSFER_PENDING" };
	
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	public WorkItemSupport(gov.va.caret.model.WorIm WorIm) {
		super(WorIm);
	}
	
	public WorkItemSupport getThis(){
		return this;
	}
	
	public Veteran getVeteran(){
		if ( veteran == null ){
			veteran = getVcgSupport().getVeteran();
		}
		return veteran;
	}

	public String getPersonName() {
		if ( personName == null ){
			this.personName = getFullName( getPersnId() );
		}
		return personName;
	}

	public String getCaregiverName() {
		if ( caregiverName == null ){
			this.caregiverName = getFullName( getCaregiverId() );
		}
		return caregiverName;
	}
	
	public VcgSupport getVcgSupport(){
		if ( vcgSupport == null ){
			vcgSupport = VcgSupport.getVcgSupport( getVcgId() );
		}
		return vcgSupport;
	}
	
	public Person getCaregiver(){
		if ( caregiver == null ){
			caregiver = getVcgSupport().getPersonRole( getCaregiverId() );
		}
		return caregiver;
	}
	
	public Vendor getVendor(){
		if ( vendor == null && getCaregiver().getRole() == Role.PRIMARY ){
			Vendr vendr = null;
			try {
				vendr = VendrLocalServiceUtil.findByPersnId( getCaregiverId() );
				vendor = new Vendor ( vendr );
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			}
			if ( vendr == null ){
				vendor = new Vendor ( new VendrImpl(), caregiver );
			}
		}
		return vendor;
	}
	
	public List<Docum> getDocuments(){
		try{
			if ( isDocType() ){
				return DocumLocalServiceUtil.getByPrimaryKey( getClassPk() );
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return Collections.emptyList();
	}
	
	public WorkType getWorkType(){
		try {
			if ( workType == null ){
//				String type = getType();
//				if ( type.endsWith("_DISPOSITION") ){
//					type= type.substring(0, type.length()-12 );
//				}
				workType = WorkType.valueOf( getType() );
			}
		} catch ( Exception e ){
			_log.error("Couldnt load workTye:" + getType() );
		}
		return workType;
	}
	
	public List<QueAction> getReviewActions(){
		List<QueAction> queActions = Collections.emptyList();
		if ( getQueueId() > 100 ){
			if ( isCscCorrection() ){
				queActions = OwnerQueue.CORRECTION_Q.getActions();
			} else try {
				if ( getQueueId() == OwnerQueue.VERIFIED_COMPLETED_Q.getQueueId() ) {
					switch( getWorkType() ){
					case APPROVED_DISPOSITION:
						WorSe workItemState = WorSeLocalServiceUtil.getLast(getWorImId());
						if ( workItemState != null && workItemState.getStep().indexOf(QueAction.GT_35K_SEND_TO_SUPERVISOR_Q.name()) < 0 ) {
							return Collections.emptyList();
						}
					case REINSTATED_DISPOSITION:
					case REVOKED_DISPOSITION:
					case V_INFO_CHANGE:
					case VCG_INFO_CHANGE:
					case C_INFO_CHANGE:
					case ADDRESS_CHANGE:
						return Collections.singletonList(QueAction.CHAMP_VERIFY);
					}
				} else {
					queActions = OwnerQueue.getOwnerQue( getQueueId() ).getActions();
					QueAction review = QueAction.valueOf(getStatus());
					int ndx = queActions.indexOf(review);
					if ( ndx >= 0 ){
						return swapQueActionWith(queActions, ndx, null);
					}
					ndx = queActions.indexOf(QueAction.VERIFIED);
					if ( ndx >= 0 && calcInfo.getFinalAmount().compareTo( BIG_35 ) >= 0 ) {
						return swapQueActionWith(queActions, ndx, QueAction.GT_35K_SEND_TO_SUPERVISOR_Q);
					}
					if ( OwnerQueue.getOwnerQue( getQueueId() ) == OwnerQueue.SUPERVISOR_Q && calcInfo.getFinalAmount().compareTo( BIG_35 ) >= 0 ) {
						WorSe workItemState = WorSeLocalServiceUtil.getFirst(getWorImId());
						if ( workItemState != null && workItemState.getStep().indexOf(QueAction.GT_35K_SEND_TO_SUPERVISOR_Q.name()) >= 0 ) {
							return swapQueActionWith(queActions, ndx, QueAction.GT_35K_SUPERVISOR_VERIFIED);
						}
					}
				}
			} catch( Exception e){}
		}
		return queActions;
	}
	
	private List<QueAction> swapQueActionWith( List<QueAction> queActions, int ndx, QueAction replaced ){
		List<QueAction> queActionsCopy = new ArrayList<>();
		for ( int i = 0; i < queActions.size(); i++ ){
			if ( i == ndx ) continue;
			queActionsCopy.add(queActions.get(i));
		}
		if ( replaced != null ) {
			queActionsCopy.add( replaced );
		}
		return queActionsCopy;
	}
	
	public boolean isCscCorrection(){ 
		return OwnerQueue.CORRECTION_Q.name().equals(getStatus()); 
	}
	
	public boolean canCscCorrect(Object permissionChecker, Object scopeId ){
		return OwnerQueue.CORRECTION_Q.name().equals(getStatus()) && CAction.canDoCaret(permissionChecker, scopeId, CaretCan.CSC_FUNCTION ); 
	}
	
	public boolean canVendorUpdate( Object permissionChecker, Object scopeId ){ 
		return canVendorCreate(permissionChecker, scopeId) || CAction.canDoCaret(permissionChecker, scopeId, CaretCan.UPDATE_VENDORS); 
	}
	
	public boolean canVendorCreate ( Object permissionChecker, Object scopeId ){ 
		return OwnerQueue.VENDOR_Q.queueId == getQueueId() && CAction.canDoCaret(permissionChecker, scopeId, CaretCan.CREATE_VENDORS); 
	}
	
	public boolean isDocType(){
		return getWorkType().isDocType;
	}
	
	public boolean isDocLoaded(){
		if ( docLoaded == null ){
			try {
				docLoaded = isDocType() && DocumLocalServiceUtil.getByPrimaryKeyCount( getClassPk() ) > 0;
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		return docLoaded;
	}
	
	public boolean isTransferable(){
		switch (getWorkType()){
			case ONLINE_APP:
			case CSC_APP:
			case REFERRAL:
			case HEC_REFERRAL:
			case HRC_REFERRAL:
			case CSL_REFERRAL:
			case CALL_REFERRAL:
				return true;
			default:
				return false;
		}
	}
	
	public boolean isAssignable(){
		switch (getWorkType()){
			case ONLINE_APP:
			case CSC_APP:
			case REFERRAL:
			case HEC_REFERRAL:
			case HRC_REFERRAL:
			case CSL_REFERRAL:
			case CALL_REFERRAL:
				return true;
			default:
				return false;
		}
	}
	
	public String getDueDateStr ( ){
		if ( getDueDate() != null ){
			return Toolbox.formatDateCprs( getDueDate() );
		}
		return StringPool.BLANK;
	}
	
	public String getCreateDateStr ( ){
		if ( getCreationDate() != null ){
			return Toolbox.formatDateCprs( getCreationDate() );
		}
		return StringPool.BLANK;
	}
	
	public long getCreateId ( ){
		try {
			List <AudLg> list = CaretLocalServiceUtil.getChange( getCreationDate(), new long[] {getWorImId()}, new String[] {"WorIm"} );
			if ( !list.isEmpty() ) {
				return list.get(0).getCoverUserId() ;
			}
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		}
		return 0;
	}

	public String getFullName ( long persnId ){
		if ( persnId > 0 ){
			return CaretUtil.getPersnFullName ( persnId );
		}
		return StringPool.BLANK;
	}
	
	public String getFacilityName (){
		if ( getGroupId() == 0 ){
			return StringPool.BLANK;
		} else {
			try {
				return OrganizationLocalServiceUtil.getOrganization( getGroupId() ).getName();
			} catch (PortalException e) {
			} catch (SystemException e) {
			}
		}
		return StringPool.BLANK;
	}
	

	public String getFacilNumber(){
		if ( getGroupId() == 0 ){
			return StringPool.BLANK;
		} else {
			try {
				if ( ! getWorkType().canManualWork() ) {
					return FacilLocalServiceUtil.getByOrgId(getGroupId()).getFacilityNumber();
				}
			} catch (PortalException e) {
			}
		}
		return StringPool.BLANK;
	}
	
	public String getNumFacilName(){
		if ( getGroupId() == 0 ){
			return StringPool.BLANK;
		} else {
			try {
				if ( ! getWorkType().canManualWork() ) {
					return FacilLocalServiceUtil.getByOrgId(getGroupId()).getFacilityNumber() +
						StringPool.DASH + OrganizationLocalServiceUtil.getOrganization( getGroupId() ).getName();
				}
			} catch (PortalException e) {
			} catch (SystemException e) {
			}
		}
		return StringPool.BLANK;
	}
	
	public String getUserQueue(){
		if ( getUserId() > 0 ){
			return CaretUtil.getUserFullName ( getUserId() );
		}
		return StringPool.BLANK;
	}
	
	private String queueName = null;
	public String getQueueName(){
		if ( queueName != null ){
			return queueName;
		}
		if ( getQueueId() > 100 && getQueueId() != OwnerQueue.VERIFIED_COMPLETED_Q.queueId ){
			try {
				OwnerQueue ownerQue = OwnerQueue.getOwnerQue( getQueueId() );
				if ( ownerQue != null ){
					return queueName = ownerQue.name();
				}
			} catch ( Exception e ){
				e.printStackTrace();
			}
		}
		return queueName = StringPool.BLANK;
	}
	
	public boolean canReview( PortletRequest request, Object permissionChecker, Object scopeId ){
		if ( CAction.canDoCaret(permissionChecker, scopeId, CaretCan.CBOPC_FUNCTION ) ){
			if ( !OwnerQueue.CORRECTION_Q.name().equals( getStatus() ) && !Toolbox.isEmpty( getQueueName() ) ){
				String queueName = getQueueName();
				if ( queueName.endsWith("2") ) {
					queueName = queueName.substring(0, queueName.length()-1);
				}
				return CAction.canDoCaret(permissionChecker, scopeId, CaretCan.valueOf( CbopcDashboardConfig.NDX + queueName ) );
			} else {
				return canAssign( request );
			}
		}
		return false;
	}
	
	public boolean canReviewDelay( PortletRequest request, Object permissionChecker, Object scopeId ){
		return !isComplete() && canAcceptDelay(permissionChecker, scopeId);
	}

	public boolean canAcceptDelay( Object permissionChecker, Object scopeId ){
		return getWorkType() == WorkType.APP_DELAY 
				&& CAction.canDoCaret(permissionChecker, scopeId, CaretCan.VISN_CSC_WAIVER_Q ) 
				&& isCreatedBy( permissionChecker );
	}
	
	
	public boolean isCreatedBy(Object permissionChecker) { 
		return  ((com.liferay.portal.security.permission.PermissionChecker)permissionChecker).getUserId() == getUserId();
	}
	
	public boolean isMemberOf(Object permissionChecker) {
		return  ((com.liferay.portal.security.permission.PermissionChecker)permissionChecker).isGroupMember(getGroupId());
	}
	
	public boolean canAssign( PortletRequest request ){
		return !((DashboardConfig)request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG)).getAssignees(this).isEmpty();
	}
	
	public boolean canTransfer( Object permissionChecker, Object scopeId ){
		return isTransferable() && CAction.canDoCaret(permissionChecker, scopeId, CaretCan.UPDATE_ACTIVE_VCG_FACILITY ) ;
	}
	
	public boolean isComplete(){
		return getCompletionDate() != null;
	}
	

	public boolean isCompletable ( VcgSupport vcgSupport ) throws SystemException, PortalException {
		if ( WorkType.CSC_APP.name().equals( getType() ) || WorkType.ONLINE_APP.name().equals( getType() ) ){
			
			_log.debug("WorkStatus : (" + getClassPk() + ") " + getStatus()  );
			if ( getVcgId() == 0 || WorkStatus.COMPLETE.name().equals( getStatus() ) ){
				return false;
			}
			VcgApplication vcgApp = new VcgApplication( VcgAnLocalServiceUtil.getVcgAn( getClassPk() ) );
			int i = 0;
			_log.debug("------------------------AppStatus--" + vcgApp.getStatus() + "-----------------------------------" );
			_log.debug( "vcgApplication - Primary - vcg-closed:" + vcgSupport.getPrimaryDispReason()  );
			_log.debug("vcgApplication - Primary - invalid:" + vcgApp.isInvalidPrimary() );
			_log.debug("vcgApplication - Primary - isInProcess:" + vcgSupport.isInProcess( vcgSupport.getPrimaryDispReason() ) );
			if ( vcgApp.getPrimaryId() == 0 || vcgApp.isInvalidPrimary() || 
					( vcgSupport.getPrimaryDispositionDate() != null && vcgApp.getVcgAnId() == vcgSupport.getPrimaryVcgAnId() ) ||
					vcgSupport.getPrimaryVcgAnId() != getClassPk() ){
				i ++;
			}
			_log.debug("vcgApplication - Secondary - vcg-closed:" + vcgSupport.getSecondaryDispReason()  );
			_log.debug("vcgApplication - Secondary - invalid:" + vcgApp.isInvalidSecondary() );
			_log.debug("vcgApplication - Secondary - isInProcess:" + vcgSupport.isInProcess( vcgSupport.getSecondaryDispReason() ) );
			if ( vcgApp.getSecondaryId() == 0 || vcgApp.isInvalidSecondary() || 
					( vcgSupport.getSecondaryDispositionDate() != null && vcgApp.getVcgAnId() == vcgSupport.getSecondaryVcgAnId() )  ||
					vcgSupport.getSecondaryVcgAnId() != getClassPk() ){
				i ++;
			}
			_log.debug("vcgApplication - Secondary2 - vcg-closed:" + vcgSupport.getSecondaryTwoDispReason()  );
			_log.debug("vcgApplication - Secondary2 - invalid:" + vcgApp.isInvalidSecondaryTwo() );
			_log.debug("vcgApplication - Secondary2 - isInProcess:" + vcgSupport.isInProcess( vcgSupport.getSecondaryTwoDispReason() ) );
			if ( vcgApp.getSecondaryTwoId() == 0 || vcgApp.isInvalidSecondaryTwo() || 
					( vcgSupport.getSecondaryTwoDispositionDate() != null && vcgApp.getVcgAnId() == vcgSupport.getSecondaryTwoVcgAnId() )  ||
					vcgSupport.getSecondaryTwoVcgAnId() != getClassPk() ){
				i ++;
			}
			return i == 3;
		}
		return false;
	}
	
	@Override
	public void persist()
		throws com.liferay.portal.kernel.exception.SystemException {
		if ( getPersnId() == 0 ){
			throw new com.liferay.portal.kernel.exception.SystemException("Person ID cannot be 0");
		}
		super.persist();
		saveCustomAttributes();
	}
	
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> modelAttributes = super.getModelAttributes();  
		if ( !customAttributes.isEmpty() ) {
			for ( String key : customAttributes.keySet() ){
				String text = customAttributes.get(key).getLargeText();
				modelAttributes.put(key, text.substring(0, Math.min(text.length(), BG_LEA_FIELD_LENGTH )) );
			}
		}
		for ( String attribute: notes.keySet() ){
			Note note = notes.get(attribute);
			if ( note == null ) continue;
			String text = note.getValue();
			modelAttributes.put( attribute, text.substring(0, Math.min(text.length(), NOTE_FIELD_LENGTH )) );
		}
		if ( getCompletionDate() != null ) {
			modelAttributes.put( "completionDate", Toolbox.getDateFormatCprs().format( getCompletionDate() ) );
		}
		return modelAttributes;
	}
	
	private BoxGp initCustomAttribute( String attribute ) throws ApplicationWorkFlowException{
		BoxGp custom = new BoxGpImpl();
		custom.setBoxGroup( WorkItemSupport.class.getName() );
		custom.setBoxSubGroup( String.valueOf( getWorImId() ) );
		custom.setLabel( attribute );  //attribute
//		custom.setViewSequence( sequence );
		try {
			return BoxGpLocalServiceUtil.addBoxGp( custom );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException ( e );
		}
	}
	private BoxGp getCustomAttribute ( String attribute  ) throws ApplicationWorkFlowException {
		List<BoxGp> attributes = BoxGpLocalServiceUtil.getBoxGroups( WorkItemSupport.class.getName(), String.valueOf( getWorImId() )  );
		BoxGp custom = null;
		if ( attributes.isEmpty() ){
			custom = initCustomAttribute ( attribute );
		} else {
			for ( BoxGp bgAtt : attributes ){
				if ( attribute.equals( bgAtt.getLabel() ) ){
					custom = bgAtt;
				}
			}
		}
		if ( custom == null ){
			custom = initCustomAttribute ( attribute );
		}
		return custom;
	}
	
	public long getApplicationId(){
		if ( getClassId() == PortalUtil.getClassNameId( VcgAn.class ) ){
			return getClassPk();
		}
		return 0;
	}
	
	private void saveCustomAttributes() {
		if ( !customAttributes.isEmpty() ){
			for ( BgLae value : customAttributes.values() ){
				try {
					value.setOwnerId(getWorImId());
					CaretLocalServiceUtil.save(value);
				} catch (ApplicationWorkFlowException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
		}
		for ( String attribute: notes.keySet() ){
			Note note = notes.get(attribute);
			if ( note == null ) continue;
			if ( note.getNoteId() == 0 ) try {
				note.setVcgId( getVcgId() );
				notes.put(attribute, CaretLocalServiceUtil.addNote(note));
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		WorkType type = getWorkType();
		if (  type != null && type.manualWork ) {
			doManualActions();
		}
	}
	
	public void setNote ( String attribute, String comment, long userId, Date createDate, long groupId ){
		 notes.put( attribute, CaretUtil.createNote( createDate, getWorImId(), groupId, userId, comment ) );
	}
	
	public void useNote( String attribute, Note note ) {
		notes.put( attribute, note );
	}
	
	public Note getNote ( String attribute ){
		if ( notes.containsKey(attribute) ){
			return notes.get(attribute); 
		}
		return null;
	}
	
	private BgLae getLeaAttr ( String attribute  ) throws ApplicationWorkFlowException {
		BoxGp custom = getCustomAttribute ( attribute );
		BgLae value = BgLaeLocalServiceUtil.getBgLaeAssociation( getWorImId(), custom.getBoxGpId() );
		if ( value == null ){
			value = new BgLaeImpl();
			value.setBoxGpId( custom.getBoxGpId() );
		}
		return value;
	}
	
	public void setLeaAttr ( String attribute, String value ) throws ApplicationWorkFlowException{
		BgLae bgLea = getLeaAttr(attribute);
		bgLea.setLargeText(  value.substring(0, Math.min( value.length(), BG_LEA_FIELD_LENGTH ))  );
		customAttributes.put(attribute, bgLea);
	}
	
	public void setCalculationInfoCalendar ( Date date ){
		calendar.setTime(date);
	}
	
	private Calendar calendar = Calendar.getInstance();

	
	
//	final OrderByComparator orderByWorIm = new OrderByComparator() {
//		private static final long serialVersionUID = 1L;
//		public int compare(Object obj1, Object obj2) { return 0; }
//		public String getOrderBy() { return CaretStrPool.WORK_ID; }
//		public boolean isAscending() { return false; }
//	};
	
	public StiPt getPrevious() throws ApplicationWorkFlowException{
		if ( recurringPrevious == null ) {
			String[] strArray;
			Date olderThan = null;
			if ( this.isComplete() ) {
				strArray = new String[] {StipendConfig.OBSOLETE_PAYMENT};
				if (getCalcInfo() != null && StipendConfig.OBSOLETE_PAYMENT.equals( stiPt.getStipendStatus() ) ){
					olderThan = stiPt.getStipendApprovedDate();
				}
			} else {
				strArray = new String[] {StipendConfig.PAYMENT_FINANCE, StipendConfig.ON_HOLD};
			}
			List<StiPt> recurrant;
			if ( olderThan != null ) {
				recurrant = StiPtLocalServiceUtil.findByRecurringBefore ( getVcgId(), strArray, olderThan );
			} else {
				recurrant = StiPtLocalServiceUtil.findByVcg(getVcgId(), -1, -1, null);
			}
			if ( !recurrant.isEmpty() ) {
				if ( recurrant.size() > 1) {
					if ( recurrant.get(0).getStiPtId() == getGroupId() ) {
						recurringPrevious = recurrant.get(0);
					} else {
						recurringPrevious = recurrant.get(1);
					}
				} else {
					recurringPrevious = recurrant.get(0);
				}
			} else {
				recurringPrevious = StipendConfig.NULLCONFIG;
			}
		}
		return recurringPrevious;
	}
	
	public void setStiPtContext ( StiPt stiPt ) {
		this.stiPt = stiPt;
	}

	public StiPt getStiPtContext() throws ApplicationWorkFlowException {
		if ( stiPt == null ) {
			stiPt = StiPtLocalServiceUtil.findByWorIm( getWorImId() );
		}
		return stiPt;
	}
	
	public CalculationInfo getCalcInfo() {
		if ( stiPt == null ) try {
			stiPt = getStiPtContext();
		} catch (ApplicationWorkFlowException e1) {
			e1.printStackTrace();
		}
		return getCalcInfo( stiPt );
	}
	
	public boolean isMultiLine() {
		return multiLine;
	}

	public List<LumCg> getMultiStiPt() throws SystemException, PortalException {
		if ( multiStiPt == null ) {
			switch( getWorkType() ){
			
			case LOST_CHECK:
			case RETURNED_PAYMENT:
			case MANUAL_PAYMENT:
			case HELD_PAYMENT:
			case REJECTED_PAYMENT:
				multiStiPt = Collections.emptyList();
				if ( stiPt == null && getGroupId() > 0) {
					PayLg payLg = PayLgLocalServiceUtil.fetchPayLg( getGroupId() );
					if ( payLg != null ) {
						stiPt = new PaymentLog(payLg).getStipendConfig();
						multiStiPt = LumCgLocalServiceUtil.findByVendrCycle( stiPt.getVendrId(), payLg.getCycleId() );
					}
				}
			break;
			default:
			}
		}
		return multiStiPt;
	}

	public CalculationInfo getCalcInfo( StiPt stiPt ) {
		if ( calcInfo == null ){
			try {
				WorkType type = getWorkType();
				if ( type == WorkType.V_INFO_CHANGE ){
					if (CaretLocalServiceUtil.getChange( getCreationDate(), new long[]{ getPersnId() }, new String[] {"address", "zip", "city", "state", "country"}).size() > 0){
						type = WorkType.ADDRESS_CHANGE;
					}
				}
				switch( type ){
				case ADDRESS_CHANGE:
					if ( stiPt == null ) {
						stiPt = StiPtLocalServiceUtil.fetchStiPt( getGroupId() );
					}
					calcInfo = new AddressChange( this, stiPt, getPrevious(), calendar );
					break;
				case RECOUPMENT:
					if ( stiPt == null && getGroupId() == 0 ) {
						calcInfo = new UnchangedPayment( this, calendar );
						break;
					}
				case LOST_CHECK:
				case RETURNED_PAYMENT:
				case MANUAL_PAYMENT:
				case HELD_PAYMENT:
				case REJECTED_PAYMENT:
//				case DUPLICATE_PAYMENT:
					if ( stiPt == null && getGroupId() > 0) {
						PayLg payLg = PayLgLocalServiceUtil.fetchPayLg( getGroupId() );
						if ( payLg != null ) {
							stiPt = new PaymentLog(payLg).getStipendConfig();
							calendar.setTime( new PaymentLog(payLg).getEndDate() );
						} else {
							WorSe first = getFirstState();
							if ( first != null  ) {
								if ( CaretStrPool.HOLD_PLACED_ON_ACCOUNT.equals( first.getStep() ) ) {
									List<StiPt> configs = StiPtLocalServiceUtil.findByRecurring( getGroupId(), new String[]{ StipendConfig.ON_HOLD } );
									if ( configs != null ) {
										stiPt = configs.get(0);
									}
								} 
								if ( stiPt == null || StipendConfig.ON_HOLD.equals( first.getStep() ) ) {
									stiPt = StiPtLocalServiceUtil.fetchStiPt( getGroupId() );
								}
							}
						}
						if ( stiPt == null ) {
							FmsIc fmsIc = FmsIcLocalServiceUtil.fetchFmsIc( getGroupId() );
							if ( fmsIc != null ) {
								StiPt temp = null;
								for ( StiPt stiPt2: new FmsIcSupport(fmsIc).getPaymentConfigs() ) {
									temp = stiPt2;
									if ( StipendConfig.RECURRING.equals( stiPt2.getStipendType() ) ){
										this.stiPt = stiPt = stiPt2;
									}
								}
								if ( stiPt == null ) {
									stiPt = this.stiPt = temp;
								}
							}
						}
					}
				case APPROVED_DISPOSITION:
					calcInfo = new InitialPayment( this, stiPt, calendar );
					break;
				case REINSTATED_DISPOSITION:
					calcInfo = new Reinstatement( this, stiPt, calendar );// does this one need... getPrevious()  ??
					break;
				case REVOKED_DISPOSITION:
					calcInfo = new FinalPayment( this, stiPt, calendar );
					break;
				case TIER_UPDATE:
					calcInfo = new TierChange( this, stiPt, getPrevious(), calendar );
					break;
				default:
					calcInfo = new UnchangedPayment( this, calendar );	
					break;
				}
			} catch ( Exception e ){
				_log.error("Couldnt load WorkType / calculation Info");
			}
		}
		return calcInfo;
	}

	public boolean calcInfoVerified( ServiceContext sc ) throws ApplicationWorkFlowException, SystemException {
		CalculationInfo calcInfo = getCalcInfo();
		if ( calcInfo != null && calcInfo.isCalculationWork() ){
//			StiPt stipendPaymentConfig = StiPtLocalServiceUtil.findByWorIm( getWorImId() );
			if ( stiPt == null ) {
				return false;
			}
			WorSe workItemStep = new WorSeImpl();
			workItemStep.setWorImId( getWorImId() );
			workItemStep.setCreationDate( sc.getCreateDate() );
			workItemStep.setUserId( sc.getUserId() );
			workItemStep.setStepNumber( (int) Vendor.initMonth( Calendar.getInstance() ).getOwnerId() );
			workItemStep.setOldStep( stiPt.getStipendStatus() );
			workItemStep.setStep( CaretStrPool.ACCEPTED );
			CaretLocalServiceUtil.save( workItemStep );
//			stiPt.setWorSeId( workItemStep.getStepNumber() );
			stiPt.setStipendStatus( StipendConfig.PAYMENT_FINANCE );
			_log.warn("UPDATING Stipend status to PAYMENT_FINANCE");
			stiPt.setStipendApprovedDate( sc.getCreateDate() );
			if ( stiPt.getPayslipDate() == null && calcInfo.getFinalAmount() != null ) {
				stiPt.setOneTimePayment( calcInfo.getFinalAmount().toString() );
			}
			CaretLocalServiceUtil.save(stiPt);
			return true;
		}
		return false;
	}
	
	public void calcInfoRevoked(ServiceContext sc) throws ApplicationWorkFlowException {
		
		if ( getCaregiver().getRole() == Role.PRIMARY ){
			Vendr vendor = VendrLocalServiceUtil.findByPersnId( getCaregiverId() );
			if ( vendor != null ){
				for ( StiPt stipendPaymentConfig : StiPtLocalServiceUtil.findByVcg( getVcgId(), -1, -1, null) ){
					if ( StipendConfig.PAYMENT_FINANCE.equals(stipendPaymentConfig.getStipendStatus()) && stipendPaymentConfig.getVendrId() == vendor.getVendrId() ){
						stipendPaymentConfig.setStipendStatus( StipendConfig.OBSOLETE_PAYMENT );
						CaretLocalServiceUtil.save(stipendPaymentConfig);
					}
				}
			} else {
				_log.warn("REVOKE Completed on a Vendor not activated yet...");
			}
		}
	}
	
	public String getManualInfo( ) throws PortalException{
		WorSe worse = WorSeLocalServiceUtil.getLast( getWorImId() );
		if ( worse == null ) return StringPool.BLANK;
		StringBuilder sb = new StringBuilder();
		if ( getStiPtContext() != null ) {
			sb.append("<li>").append("Payment Status:").append(LanguageUtil.get( LocaleUtil.getDefault(), getStatus() )).append("</li>");
		}
		WorkType type = getWorkType();
		switch( type ){
		case HELD_PAYMENT:
		case RETURNED_PAYMENT:
		case LOST_CHECK:
			String typeTrans = LanguageUtil.get( LocaleUtil.getDefault(), type.name() );
			sb.append("<li>").append( typeTrans ).
				append(" Event Date:").append(Toolbox.formatDate(worse.getCreationDate()) );
			if ( 100 < worse.getStepNumber() ) {
				sb.append( typeTrans ).append(StringPool.COMMA_AND_SPACE).append(" Number:").append( worse.getStepNumber() );
			}
			sb.append("</li>");
			break;
		case REJECTED_PAYMENT:
			break;
		case RECOUPMENT:
			break;
//		case DUPLICATE_PAYMENT:
//			break;
		}
		if ( ! worse.getStep().startsWith("0") ) {
			sb.append("<li>").append(worse.getStep()).append("</li>");
		}
		return sb.toString();
	}
	
	private void doManualActions() {
		
		if ( getCompletionDate() != null ) {
			boolean isLc = false;
			switch( getWorkType() ){
			case LOST_CHECK: isLc = true;
			case REJECTED_PAYMENT:
			case HELD_PAYMENT:
				if ( multiStiPt == null ) try {
					FmsIc fmsIc = FmsIcLocalServiceUtil.fetchFmsIc( getGroupId() );
					if ( fmsIc != null ) {
						
						for ( StiPt stiPt2: new FmsIcSupport(fmsIc).getPaymentConfigs() ) {
							stiPt2.setStipendStatus(StipendConfig.PAYMENT_FINANCE);
							_log.warn("UPDATING Stipend status to PAYMENT_FINANCE");
							CaretLocalServiceUtil.save(stiPt);
						}
					} else if ( ! isLc ) {
						Date holdPlacedDate = getCreationDate();
						Calendar minCal = Calendar.getInstance();
						minCal.setTime( holdPlacedDate );
						minCal.set(Calendar.DAY_OF_MONTH, 1);
						
						if ( minCal.getTime().before( stiPt.getStipendStartDate() ) ) {
							holdPlacedDate = stiPt.getStipendStartDate();
						} else {
							holdPlacedDate = minCal.getTime();
						}
						//create oneTime payment, backdated lump sum to weekly for on-hold removal
						
					}
				} catch (ApplicationWorkFlowException e1) {
					e1.printStackTrace();
				} catch (SystemException e) {
					e.printStackTrace();
				} catch (PortalException e) {
					e.printStackTrace();
				}
				break;
			case RECOUPMENT:
//			case DUPLICATE_PAYMENT:
//				break;
			}
		}
		
	}
	
	
	
	public Vendor verifyVendor ( ServiceContext sc, String queueuIds ) throws PortalException{
		if ( getCaregiver().getRole() == Role.PRIMARY ){
			Vendr vendr = VendrLocalServiceUtil.findByPersnId( getCaregiverId() );
			Vendor vendor;
			if ( vendr == null ){
				vendor = new Vendor ( new VendrImpl(), getCaregiver() );
				vendor.setAddress( getCaregiver().getAddress() );
				vendor.setPersnId( getCaregiverId() );
				vendor.setCity( getCaregiver().getCity() );
				vendor.setState( getCaregiver().getState() );
				vendor.setZip( getCaregiver().getZip() );
				vendor.setLastName(getCaregiver().getLastName());
				vendor.setFirstName(getCaregiver().getFirstName());
				vendor.setTaxId( getCaregiver().getSsn() );
				vendor.setUserId( sc.getUserId() );
				WorkType workType = vendor.getWorkType();
				CaretLocalServiceUtil.save(vendor);
				if ( workType != null ){
					WorIm wis = CaretUtil.createWorkItem( sc, 0, vendor, workType, getPersnId(), getCaregiverId() ) ;
					if ( WorkType.VENDOR_CREATE == workType ) {
						wis.setCompletionBy( sc.getUserId() );
						wis.setCompletionDate( sc.getCreateDate() );
						wis.setQueueId( 1100 );
						wis.setStatus( QueAction.REVIEW_VENDOR_COMPLETE.name() );
					} else {
						wis.setQueueId(workType.workName.getQueueId());
						wis.setStatus( QueAction.REVIEW_INPUT_PENDING.name() );
					}
					wis.setClassId( PortalUtil.getClassNameId( VcgAn.class ) );
					wis.setClassPk(getApplicationId());
					wis.setUserId( sc.getUserId() );
					wis.setVcgId( getVcgId());
					CaretLocalServiceUtil.save( wis );
					WorSe workItemState = new WorSeImpl();
					workItemState.setWorImId( wis.getWorImId() );
					workItemState.setStepNumber( 0 );
					workItemState.setCreationDate( sc.getCreateDate() );
					workItemState.setStep( "Vendor Created..." );
					try {
						WorSeLocalServiceUtil.addWorSe( workItemState );
					} catch (SystemException e) {
						e.printStackTrace();
					}
				}
			} else {
				vendor = new Vendor ( vendr );
			}
			StiPt stipendPaymentConfig = StiPtLocalServiceUtil.findByWorIm( getWorImId() );
			if ( stipendPaymentConfig.getVendrId() == 0 ){
				stipendPaymentConfig.setVendrId( vendor.getVendrId() );
				CaretLocalServiceUtil.save(stipendPaymentConfig);
			}
		}
		return vendor;
	}

	public void checkChampVaType() {
		switch( getWorkType() ){
		case APPROVED_DISPOSITION:
//			WorSe workItemState = WorSeLocalServiceUtil.getLast(getWorImId());
//			if ( workItemState != null && workItemState.getStep().indexOf(QueAction.GT_35K_SEND_TO_SUPERVISOR_Q.name()) < 0 ) {
//				return;
//			}
		case REINSTATED_DISPOSITION:
		case REVOKED_DISPOSITION:
		case V_INFO_CHANGE:
		case VCG_INFO_CHANGE:
//		case C_INFO_CHANGE:
		case ADDRESS_CHANGE:
			WorSe firstState = WorSeLocalServiceUtil.getLast(getWorImId());
			if ( firstState != null ) {
				if ( !"CHAMPVA_STEP".equals(firstState.getStep() ) ) {
					firstState.setStep("CHAMPVA_STEP");
				} else {
					firstState.setStep("CHAMPVA_VERIFIED");
				}
				try {
					CaretLocalServiceUtil.save(firstState);
				} catch (ApplicationWorkFlowException e) {
					e.printStackTrace();
				}
			}
		}
		
	}

	public WorSe getFirstState () {
		return WorSeLocalServiceUtil.getFirst(getWorImId());
	}

	public void setViewable(PortletRequest request) {
		DashboardConfig dashConfig = ( DashboardConfig ) request.getPortletSession().getAttribute( CaretStrPool.DASHBOARD_CONFIG );
		if ( dashConfig instanceof FacilityDashboardConfig ){
			viewMember = ((FacilityDashboardConfig)dashConfig).getGroupId().contains( getGroupId() );
		} 
	}

	public boolean isViewMember() {
		return viewMember;
	}

	public void setViewMember(boolean viewMember) {
		this.viewMember = viewMember;
	}
	
	
	
}
