package gov.va.caret.model.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.impl.BgAsnImpl;
import gov.va.caret.service.BgAsnLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;

public class PrimaryInsuranceSupport {

	public final static String MEDI_ENROLLED_ATTRIBUTE = "mediEnrolled";
	public final static String TRICARE_ENROLLED_ATTRIBUTE = "tricareEnrolled";
	public final static String CHAMPVA_ENROLLED_ATTRIBUTE = "champEnrolled";
	public final static String OTHER_INSURANCE_ATTRIBUTE = "otherHealthInsuranceYesNo";
	
	private static Map<String,List<BoxGp>> insurances;
	private static void loadBoxGp() {
		try {
			insurances = new HashMap<String,List<BoxGp>>();
			insurances.put( MEDI_ENROLLED_ATTRIBUTE, CaretUtil.loadBoxGroup(Person.class.getName(), "enrolled-in-medicare") );
			insurances.put( OTHER_INSURANCE_ATTRIBUTE, CaretUtil.loadBoxGroup(Person.class.getName(), "other-health-Insurance") );
			insurances.put( TRICARE_ENROLLED_ATTRIBUTE, CaretUtil.loadBoxGroup(Person.class.getName(), "enrolled-in-tricare") );
			insurances.put( CHAMPVA_ENROLLED_ATTRIBUTE, CaretUtil.loadBoxGroup(Person.class.getName(), "enrolled-in-champva") );
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		}
	}
	
	
	long ownerId;
	String attribute;
	private BgAsn yes;
	private BgAsn no;
	boolean initd = false;
	Boolean yesNo = null;
	
	public PrimaryInsuranceSupport( long ownerId, String attribute ) {
		if ( insurances == null || insurances.isEmpty() ) {
			loadBoxGp();
		}
		this.ownerId = ownerId;
		this.attribute = attribute;
		loadEnrollment();
	}

	private boolean loadEnrollment() {
		
		int count = 0;
		try {
			if ( ownerId > 0 ){
				for ( BoxGp boxGp: insurances.get( attribute) ){
					if ( CaretStrPool.YES.equals( boxGp.getLabel() ) ){
						yes = BoxGpLocalServiceUtil.getBoxGroupAssociation( ownerId, boxGp.getBoxGpId() );
						if ( yes == null ){
							yes = new BgAsnImpl();
							yes.setBoxGpId( boxGp.getBoxGpId() );
							yes.setOwnerId( ownerId );
						} else if ( yes.isSelected() ) {
							yesNo = true;
						}
						count++;
					} else if ( CaretStrPool.NO.equals( boxGp.getLabel() ) ){
						no = BoxGpLocalServiceUtil.getBoxGroupAssociation( ownerId, boxGp.getBoxGpId() );
						if ( no == null ){
							no = new BgAsnImpl();
							no.setBoxGpId( boxGp.getBoxGpId() );
							no.setOwnerId( ownerId );
						} else if ( no.isSelected() ) {
							yesNo = false;
						}
						count++;
					}
				}
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return initd = count == 2;
	}
	
	public Object isFieldChecked() {
		return yesNo;
	}
	
	public void setFieldChecked( Object checked ) {
		yesNo = null;
		if ( Toolbox.isEmpty( Toolbox.nullSafe( checked) ) ) {
			yes.setSelected(false);
			no.setSelected(false);
		} else {
			yesNo = Boolean.valueOf( checked.toString() );
			yes.setSelected(yesNo);
			no.setSelected(!yesNo);
		}
	}
	
	public void save(long ownerId) throws SystemException {
		if ( this.ownerId == 0) {
			this.ownerId = ownerId;
			yes.setOwnerId(ownerId);
			no.setOwnerId(ownerId);
		}
		yes = BgAsnLocalServiceUtil.updateBgAsn(yes);
		no = BgAsnLocalServiceUtil.updateBgAsn(no);
	}
}
