package gov.va.caret.model.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringPool;

import gov.va.caret.model.Persn;
import gov.va.caret.util.Toolbox;

public class Primary extends Person {

	private static final long serialVersionUID = 1L;
	public static final String PRIMARY_VIEW = "/jsp/online/primary.jsp";

	public final static String MEDI_ENROLLED_ATTRIBUTE = "mediEnrolled";
	public final static String TRICARE_ENROLLED_ATTRIBUTE = "tricareEnrolled";
	public final static String CHAMPVA_ENROLLED_ATTRIBUTE = "champEnrolled";
	public final static String OTHER_INSURANCE_ATTRIBUTE = "otherHealthInsuranceYesNo";
	
	private Boolean medicareBoolean = null;
	private Boolean tricareBoolean = null;
	private Boolean champBoolean = null;
	private Boolean otherBoolean = null;
	
	private PrimaryInsuranceSupport medicare;
	private PrimaryInsuranceSupport champVa;
	private PrimaryInsuranceSupport tricare;
	private PrimaryInsuranceSupport other;
	
	public Primary(Persn person) {
		super(person);
		loadMediEnrollment();
		loadChampEnrollment();
		loadTricareEnrollment();
		loadOthEnrollment();
	}
	
	public Role getRole(){
		return Person.Role.PRIMARY;
	}
	
	private PrimaryInsuranceSupport loadMediEnrollment() {
		if ( getPersnId() > 0 ){
			if ( medicare == null ) {
				medicare = new PrimaryInsuranceSupport( getPersnId(), MEDI_ENROLLED_ATTRIBUTE );
			}
			medicareBoolean = (Boolean)medicare.isFieldChecked();
		}
		return medicare;
	}

	private PrimaryInsuranceSupport loadChampEnrollment() {
		if ( getPersnId() > 0 ){
			if ( champVa == null ) {
				champVa = new PrimaryInsuranceSupport( getPersnId(), CHAMPVA_ENROLLED_ATTRIBUTE );
			}
			champBoolean = (Boolean)champVa.isFieldChecked();
		}
		return champVa;
	}
	
	private PrimaryInsuranceSupport loadTricareEnrollment() {
		if ( getPersnId() > 0 ){
			if ( tricare == null ) {
				tricare = new PrimaryInsuranceSupport( getPersnId(), TRICARE_ENROLLED_ATTRIBUTE );
			}
			tricareBoolean = (Boolean)tricare.isFieldChecked();
		}
		return tricare;
	}
	
	private PrimaryInsuranceSupport loadOthEnrollment() {
		if ( getPersnId() > 0 ){
			if ( other == null ) {
				other = new PrimaryInsuranceSupport( getPersnId(), OTHER_INSURANCE_ATTRIBUTE );
			}
			otherBoolean = (Boolean)other.isFieldChecked();
		}
		return other;
	}
	
	public void setInsurance(String attribute, Object value) {
		if ( attribute == MEDI_ENROLLED_ATTRIBUTE ) {
			if ( medicare != null ) {
				medicare.setFieldChecked(value);
			} else {
				medicareBoolean = Toolbox.isEmpty(Toolbox.nullSafe(value))? null: Boolean.valueOf(value.toString());
			}
		} else if ( attribute == TRICARE_ENROLLED_ATTRIBUTE ) {
			if ( tricare != null ) {
				tricare.setFieldChecked(value); 
			} else {
				tricareBoolean = Toolbox.isEmpty(Toolbox.nullSafe(value))? null: Boolean.valueOf(value.toString());
			}
		} else if ( attribute == CHAMPVA_ENROLLED_ATTRIBUTE ) {
			if ( champVa != null ) {
				champVa.setFieldChecked(value); 
			} else {
				champBoolean = Toolbox.isEmpty(Toolbox.nullSafe(value))? null: Boolean.valueOf(value.toString());
			}
		} else if ( attribute == OTHER_INSURANCE_ATTRIBUTE ) {
			if ( other != null ) {
				other.setFieldChecked(value); 
			} else {
				otherBoolean = Toolbox.isEmpty(Toolbox.nullSafe(value))? null: Boolean.valueOf(value.toString());
			}
		}
	}
	
	public String getInsuranceInfo() {
		String prefix = "Enrolled in ";
		StringBuilder sb = new StringBuilder( prefix );
		Object insurance = getMediEnrolled();
		if ( insurance != null && Boolean.TRUE.equals(insurance) ) {
			sb.append("Medicare/Medicaid, ");
		}
		insurance = getTricareEnrolled();
		if ( insurance != null && Boolean.TRUE.equals(insurance) ) {
			sb.append("Tricare, ");
		}
		insurance = getChampEnrolled();
		if ( insurance != null && Boolean.TRUE.equals(insurance) ) {
			sb.append("CHAMPVA, ");
		}
		insurance = getVaHealthEnrolled();
		if ( insurance != null && Boolean.TRUE.equals(insurance) && !Toolbox.isEmpty( getOtherHealthInsurance() ) ){
			sb.append( getOtherHealthInsurance() ).append( StringPool.COMMA_AND_SPACE );
		}
		String toString;
		if ( sb.length() > prefix.length() ) {
			toString = sb.substring(0, sb.length()-2);
		} else {
			toString = "No Insurance Enrollments found";
		}
		
		return toString;
	}

	public Map<String, Object> getModelAttributes() {
		Map<String, Object> modelAttributes = super.getModelAttributes();  
		modelAttributes.put( OTHER_INSURANCE_ATTRIBUTE, loadOthEnrollment() != null? (other.isFieldChecked() == null? "not-selected": other.isFieldChecked() ): otherBoolean );
		modelAttributes.put( MEDI_ENROLLED_ATTRIBUTE,  loadMediEnrollment() != null? (medicare.isFieldChecked() == null? "not-selected" : medicare.isFieldChecked() ): medicareBoolean );
		modelAttributes.put( CHAMPVA_ENROLLED_ATTRIBUTE, loadChampEnrollment() != null? (champVa.isFieldChecked() == null? "not-selected" : champVa.isFieldChecked() ): champBoolean);
		modelAttributes.put( TRICARE_ENROLLED_ATTRIBUTE, loadTricareEnrollment() != null? (tricare.isFieldChecked() == null? "not-selected" : tricare.isFieldChecked() ): tricareBoolean);
		
		return modelAttributes;
	}

	public void setModelAttributes( Map<String, Object> modelAttributes ) {
		super.setModelAttributes(modelAttributes);

		if ( modelAttributes.containsKey( TRICARE_ENROLLED_ATTRIBUTE ) ) {
			tricare.setFieldChecked( modelAttributes.get( TRICARE_ENROLLED_ATTRIBUTE ) );
		}
		if ( modelAttributes.containsKey( CHAMPVA_ENROLLED_ATTRIBUTE ) ) {
			champVa.setFieldChecked( modelAttributes.get( CHAMPVA_ENROLLED_ATTRIBUTE ) );
		}
		if ( modelAttributes.containsKey( MEDI_ENROLLED_ATTRIBUTE ) ) {
			medicare.setFieldChecked( modelAttributes.get( MEDI_ENROLLED_ATTRIBUTE ) );
		}
		if ( modelAttributes.containsKey( OTHER_INSURANCE_ATTRIBUTE ) ) {
			other.setFieldChecked( modelAttributes.get( OTHER_INSURANCE_ATTRIBUTE ) );
		}
	}
	
	public void persist () throws SystemException{
		super.persist();
		if ( loadMediEnrollment() != null ){
			medicare.setFieldChecked( medicareBoolean );
			medicare.save(getPersnId());
		}
		if ( loadChampEnrollment() != null ){
			champVa.setFieldChecked( champBoolean );
			champVa.save(getPersnId());
		}
		if ( loadTricareEnrollment() != null ){
			tricare.setFieldChecked( tricareBoolean );
			tricare.save(getPersnId());
		}
		if ( loadOthEnrollment() != null ){
			other.setFieldChecked( otherBoolean );
			other.save(getPersnId());
		}
	}

	public void setOtherInsChecked (Boolean enrolled) {
		if ( loadOthEnrollment() != null ){
			other.setFieldChecked(enrolled);
		}
		otherBoolean = enrolled;
	}
	
	public Object isOtherInsChecked (){
		return getOtherInsChecked();
	}
	public Object getOtherInsChecked (){
		if ( loadOthEnrollment() != null ){
			return other.isFieldChecked();
		}
		return otherBoolean;
	}
	
	public void setMediEnrolled(Boolean enrolled) {
		if ( loadMediEnrollment() != null ){
			medicare.setFieldChecked(enrolled);
		}
		medicareBoolean = enrolled;
	}
	
	public Object isMediEnrolled(){
		return getMediEnrolled();
	}
	
	public Object getMediEnrolled(){
		if ( loadMediEnrollment() != null ){
			return medicare.isFieldChecked();
		}
		return medicareBoolean;
	}
	
	public void setChampEnrolled(Boolean enrolled) {
		if ( loadChampEnrollment() != null ){
			champVa.setFieldChecked(enrolled);
		}
		champBoolean = enrolled;
	}
	
	public Object isChampEnrolled(){
		return getChampEnrolled();
	}

	public Object getChampEnrolled(){
		if ( loadChampEnrollment() != null ){
			return champVa.isFieldChecked();
		}
		return champBoolean;
	}
	
	public void setTricareEnrolled(Boolean enrolled) {
		if ( loadTricareEnrollment() != null ){
			tricare.setFieldChecked(enrolled);
		}
		tricareBoolean = enrolled;
	}
	
	public Object isTricareEnrolled(){
		return getTricareEnrolled();
	}
	
	public Object getTricareEnrolled(){
		if ( loadTricareEnrollment() != null ){
			return tricare.isFieldChecked();
		}
		return tricareBoolean;
	}

	
	public List<String> getTierList( String[] tiers, String selected){
		return getTierList(tiers, selected, true);
	}
	public List<String> getTierList( String[] tiers, String exclude, boolean includeAppeals ){
		List<String> list = new ArrayList<String>();
		for ( String tier : tiers){
			if ( !tier.equals( exclude ) ){
				list.add(tier);
			}
		}
		if ( includeAppeals ){
			list.add("appeal-tier");
		}
		Collections.sort(list);
		return list;
	}
	
	public String getRelationship(){ return super.getRelationship(); }
	public boolean isFamily(){ return super.isFamily();}
	public boolean isNotFamily(){ return super.isNotFamily(); }
	
	public Boolean getMedicareBoolean() {
		return (Boolean)medicareBoolean;
	}

	public Boolean getOtherHeathBoolean() {
		return (Boolean)otherBoolean;
	}

	public Boolean getTricareBoolean() {
		return (Boolean)tricareBoolean;
	}

	public Boolean getChampBoolean() {
		return (Boolean)champBoolean;
	}
	
	public String getOnlineView(){ return PRIMARY_VIEW; }
}
