package gov.va.caret.model.support;

import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.ServiceContextThreadLocal;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Crypto;
import gov.va.caret.model.Persn;
import gov.va.caret.model.PersnWrapper;
import gov.va.caret.model.impl.CryptoImpl;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.service.CryptoLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;


//Notice - encryption currently commented out

public class Person extends PersnWrapper implements AddressPerson {
	
	private static final long serialVersionUID = -8375561258486068131L;
	public static final Person DEFAULT_PERSON = new Person( new PersnImpl() );

	//TODO improve caching with other mechanism (persistence?)
	static Map<String,Boolean> addressCache = new HashMap<String,Boolean>();
	
	public enum Role{
		VETERAN(1,"veteran"), PRIMARY(2,"primary"), SECONDARY(3,"secondary"), SECONDARYTWO(4,"secondaryTwo"), GENERAL(4,"general");
		int id;
		String label;
		Role(int id, String label){
			this.id = id;
			this.label = label;
		}
		public int getId(){return id;}
		public String getLabel(){return label;}
		public static Role getRole( int id ){
			for ( Role role: Role.values() ){
				if ( role.getId() == id ){
					return role;
				}
			}
			return null;
		}
	}
	
	public enum Status{
		UNSET(StringPool.BLANK), NEW(CaretStrPool.NEW),
		IN_PROCESS(CaretStrPool.IN_PROCESS);
		
		String val;
		Status( String statusVal ){
			this.val = statusVal;
		}
		public String getVal(){ return val; }
	}
	
	public enum Changes{
		PII_CHANGE, NAME_CHANGE, INSURANCE_CHANGE, ADDRESS_CHANGE, FACILITY_CHANGE
	}

	public static final String SSN_FORMAT = "###-##-####";
	public static final String PHONE_FORMAT = "(###) ###-####";
	public static final String EMAIL_FORMAT = "[USERNAME]@[DOMAIN]";
	public static final String UNKNOWN_FIRST = "UNKNOWN_FIRST";
	public static final String UNKNOWN_LAST = "UNKNOWN_LAST";
	

	private Crypto _crypto = null;
	private String _nss = StringPool.BLANK;
	private String facilityName = null;
//	protected Map<String,BgAsn> enrollments = new HashMap<String,BgAsn>();
//	private Map<String,Boolean> enrollmentsSupport = new HashMap<String,Boolean>();
	private Role role = null;
	private Boolean validUspsAddress = null;
	Set<Persn> personSet = null;
	
	public Person(Persn person) {
		super(person);
		loadCrypto();
		if ( isValidAddress() ){
			validUspsAddress = isValidAddress();
		}
	}
	
	public Person(Persn person, boolean fast) {
		super(person);
		if ( fast ) return;
		loadCrypto();
		if ( isValidAddress() ){
			validUspsAddress = isValidAddress();
		}
	}
	
	private Crypto loadCrypto() {
		try {
			if ( getPersnId() > 0 ){
				if ( _crypto == null ){
					_crypto = CryptoLocalServiceUtil.getCrypto( getPersnId(), CaretStrPool.CRYPTO_NSS );
				}
				if ( _crypto == null ){
					_crypto = new CryptoImpl();
					_crypto.setType( CaretStrPool.CRYPTO_NSS );
					_crypto.setOwnerId( getPersnId() );
				} else {
					_nss = _crypto.getCryptoValue();
				}
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return _crypto;
	}
	
	public void setSsn ( String metadata ){
		if ( SSN_FORMAT.equals(metadata) ){
			metadata = StringPool.BLANK;
		}
		if ( loadCrypto() != null ){
//			encrypt:
//			c.setValue( com.liferay.portal.kernel.util.Base64.fromURLSafe( metadata ) );
			_crypto.setCryptoValue(metadata);
		}
		_nss = metadata;
	}
	
	public String getSsn(){
		if ( loadCrypto() != null ){
//			decript:
//			return com.liferay.portal.kernel.util.Base64.toURLSafe( c.getValue() );
			return _crypto.getCryptoValue();
		}
		return _nss;
	}
	
	public String getFullName (){
		return new StringBuilder(getLastName()).append(StringPool.COMMA_AND_SPACE).append(getFirstName()).append(StringPool.SPACE).append(getMiddleName()).append(StringPool.SPACE).append(getSuffix()).toString(); 
	}
	
//	private BgAsn initEnrollment( String subName, Boolean enrolled ) throws ApplicationWorkFlowException {
//		BgAsn enrollment = null;
//		List<BoxGp> enrollmentList = Toolbox.loadBoxGroup(Person.class.getName(), subName);
//		for ( BoxGp boxGp: enrollmentList ){
//			if ( CaretStrPool.YES.equals( boxGp.getLabel() ) ){
//				enrollment = BoxGpLocalServiceUtil.getBoxGroupAssociation( getPersnId(), boxGp.getBoxGpId() );
//				if ( enrollment == null && enrolled != null ){
//					enrollment = new BgAsnImpl();
//					enrollment.setBoxGpId( boxGp.getBoxGpId() );
//					enrollment.setOwnerId( getPersnId() );
//				}
//				if (enrolled != null ){
//					enrollment.setSelected(enrolled);
//				}
//				enrollments.put(subName, enrollment);
//				break;
//			}
//		}
//		return enrollment;
//	}
//	
//	private BgAsn getEnrollment( String subName ) throws ApplicationWorkFlowException {
//		BgAsn enrollment = null;
//		List<BoxGp> enrollmentList = Toolbox.loadBoxGroup(Person.class.getName(), subName);
//		for ( BoxGp boxGp: enrollmentList ){
//			if ( CaretStrPool.YES.equals( boxGp.getLabel() ) ){
//				return BoxGpLocalServiceUtil.getBoxGroupAssociation( getPersnId(), boxGp.getBoxGpId() );
//			}
//		}
//		return enrollment;
//	}
	
//	protected void setEnrollment ( String name, boolean value ){
//		BgAsn enrollment = enrollments.get(name);
//		if ( enrollment == null ){
//			try {
//				enrollment = initEnrollment( name, value );
//				enrollments.put(name, enrollment);
//			} catch (ApplicationWorkFlowException e) {
//				ApplicationWorkFlowException.handleException(e);
//			}
//		} else {
//			enrollment.setSelected( value );
//		}
//	}
//	
//	protected Boolean getEnrolled ( String name ){
//		BgAsn enrollment = enrollments.get( name );
//		if ( enrollment == null ) {
//			try {
//				enrollment = getEnrollment(name);
//			} catch (ApplicationWorkFlowException e) {
//				ApplicationWorkFlowException.handleException(e);
//			}
//		}
//		if ( enrollment == null ){
//			return null;
//		}
//		return enrollment.isSelected();
//	}
//	
//	protected Boolean getEnrollmentCache ( String name ){
//		return enrollmentsSupport.containsKey(name)? enrollmentsSupport.get(name) : false;
//	}
	
//	protected Boolean setEnrollmentCache(String key, Boolean val ){
//		return enrollmentsSupport.put(key, val);
//	}
	
	public long getRootPersnId() throws ApplicationWorkFlowException{
		return getPersnUserId() ==  0 ? PersnLocalServiceUtil.getByUser( getUserId() ).getPersnId() : getPersnId();
	}
	
	public long getRootUserId() {
		return getPersnUserId() ==  0 ? getUserId() : getPersnUserId();
	}
	
	public boolean isVerifiedIdentity(){
		return getPersnUserId() > 0 || !Toolbox.isEmpty( getExternalId() );
	}

	public boolean isGeneralRole(){
		return getRole() == Person.Role.GENERAL;
	}

	public boolean isPrimaryRole (){
		return getRole() == Person.Role.PRIMARY;
	}
	
	public boolean isVeteranRole (){
		return getRole() == Person.Role.VETERAN;
	}
	
	public boolean isSecondaryRole (){
		return getRole() == Person.Role.SECONDARY;
	}
	
	public boolean isSecondaryTwoRole (){
		return getRole() == Person.Role.SECONDARYTWO;
	}
	
	protected void setRole ( Role role ){
		this.role = role;
	}
	
	public Person.Role getRole (){
		return role;
	}
	
	public boolean getVaHealthEnrolled (){
		_log.warn(getFullName() + " getVaHealthEnrolled returns false");
		return false;
	}
	
//	public boolean getMediEnrolled() {
//		_log.warn(getFullName() + " getMediEnrolled returns false");
//		return false;
//	}
//	
//	public boolean getOtherInsChecked (){
//		_log.warn(getFullName() + " getOtherInsChecked returns false");
//		return false;
//	}
	
	public void setPhone( String phone ){
		if ( PHONE_FORMAT.equals( phone ) ){
			phone = StringPool.BLANK;
		}
		super.setPhone(phone);
	}
	
	public void setPhone2( String phone ){
		if ( PHONE_FORMAT.equals( phone ) ){
			phone = StringPool.BLANK;
		}
		super.setPhone2(phone);
	}
	
	public void setEmail ( String email ){
		if ( EMAIL_FORMAT.equals( email ) ){
			email = StringPool.BLANK;
		}
		super.setEmail(email);
	}
	
	public void setEmail2 ( String email ){
		if ( EMAIL_FORMAT.equals( email ) ){
			email = StringPool.BLANK;
		}
		super.setEmail2(email);
	}
	
	public String getFacilityName (){
		if ( facilityName == null ){
			if ( getGroupId() == 0 ){
				facilityName = StringPool.BLANK;
			} else {
				try {
					Organization org = OrganizationLocalServiceUtil.getOrganization( getGroupId() );
					facilityName = org.getName();
				} catch (PortalException e) {
					ApplicationWorkFlowException.handleException(e);
				} catch (SystemException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
		}
		
		return facilityName; 
	}

	public String getIcn() {
		return Toolbox.nullSafe( getICN() );
	}
	
	public String getBirthDateStr() {
		return Toolbox.nullSafe( Toolbox.formatDateCprs( getBirthDate() ) );
	}
	
	public void setBirthDateStr( String dateStr ) {
		try {
			Date date = (Date)Toolbox.getDateFormatCprs().parseObject(dateStr);
			setBirthDate(date);
		} catch (ParseException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	public void setGender( String gender ){
		if ( !Toolbox.isEmpty(gender) ){
			if ( gender.length() == 1 ){
				if ( "M".equals(gender.toUpperCase()) ){
					super.setGender(CaretStrPool.GENDER_TYPE_MALE);
				} else if ( "F".equals(gender.toUpperCase()) ){
					super.setGender(CaretStrPool.GENDER_TYPE_FEMALE);
				}
			} else {
				super.setGender(gender);
			}
		} else {
			super.setGender(null);
		}
	}
	
	public String getZip(){
		if ( Toolbox.isEmpty( super.getZip() )  || "0".equals( super.getZip() ) ){
			return StringPool.BLANK;
		}
		return Toolbox.formatZip( super.getZip() );
	}

	public Map<String, Object> getModelAttributes() {
		Map<String, Object> modelAttributes = super.getModelAttributes();  
		if ( getBirthDate() != null ) {
			modelAttributes.put(CaretStrPool.BIRTHDATE, Toolbox.getDateFormatCprs().format( getBirthDate() ) );
		}
		modelAttributes.put( CaretStrPool.SSN, loadCrypto() != null? _crypto.getCryptoValue() : _nss );
		return modelAttributes;
	}
	
	public void setModelAttributes( Map<String, Object> map ) {
		if ( map.containsKey( CaretStrPool.SSN ) ){
			setSsn( Toolbox.formatSsn( map.get(CaretStrPool.SSN).toString() ) );
		}
		Object birthDate = map.get( CaretStrPool.BIRTHDATE );
		if ( birthDate != null && birthDate instanceof String && !( (String) birthDate ).isEmpty() ){
			map.put( CaretStrPool.BIRTHDATE, Toolbox.parseDate( (String) birthDate ) );
		}
		super.setModelAttributes(map);
	}
	
	public boolean isForeigner() {
		return !"USA".equals(getCountry()) && !CaretStrPool.UNITED_STATES.equals(getCountry()) && !( StringPool.FALSE.equals( getCountry() ) || StringPool.BLANK.equals( getCountry() ) );
	}

	public boolean isCompleteDomesticAddress() {
		return !Toolbox.isEmpty( getAddress() ) && !Toolbox.isEmpty( getState() ) && 
				!Toolbox.isEmpty( getCity() ) && !Toolbox.isEmpty( getZip() );
	}

	public boolean isActiveVcg(){
		return CaretStrPool.ACTIVE_VCG.equals(getStatus());
	}
	
	public boolean isRegisteredIdentity (){
		return getPersnUserId() > 0 || ! Toolbox.isEmpty( getExternalId() ); 
	}

	public boolean isValidUspsAddress(){
		if ( validUspsAddress == null && !isValidAddress() && !isForeigner() ){
			if ( !Toolbox.isEmpty(getAddress()) && !Toolbox.isEmpty(getCity()) && !Toolbox.isEmpty(getState()) && !Toolbox.isEmpty(getZip()) && !"0".equals(getZip() )  ){
				String key = getAddress()+getCity()+getState()+getZip();
				if ( addressCache.containsKey( key)){
					validUspsAddress = addressCache.get( key );
				} else {
					_log.info("making USPS call with " + getAddress() + " " +  getCity() + " " +  getState() + " " + getZip() );
					validUspsAddress = CaretUtil.isValidateUspsAddress( getAddress(), getCity(), getState(), getZip(), getAddress2() );
					addressCache.put( key, validUspsAddress );
				}
				setValidAddress( validUspsAddress );
			}
		}
		if ( validUspsAddress == null ){
			validUspsAddress = false;
		}
		return validUspsAddress;
	}
	
	public Set<Persn> getPersnSet( ) {
		if ( personSet == null ){
			personSet = new LinkedHashSet<Persn>();
			try {
				if ( getUserId() == 0 ){
					personSet.add((Persn)this);
				} else {
					personSet.add( PersnLocalServiceUtil.getByUser( getRootUserId() ) );  //persnUserId
				}
				personSet.addAll( PersnLocalServiceUtil.getByOwner( getRootUserId() ) );
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		return personSet;
	}
	
	public void setAddress( String address ){
		String oldAddress = getAddress();
		super.setAddress(address);
		if ( address!= null && !address.equals( oldAddress ) ){
			validUspsAddress = null;
		}
	}
	
	public void setCity( String city ){
		String oldCity = getCity();
		super.setCity(city);
		if ( city!= null && !city.equals( oldCity ) ){
			validUspsAddress = null;
		}
	}
	
	public void setState( String state ){
		String oldState = getState();
		super.setState(state);
		if ( state!= null && !state.equals( oldState ) ){
			validUspsAddress = null;
		}
	}
	
	public void setZip( String zip ){
		String oldZip = getZip();
		super.setZip(zip);
		if ( zip!= null && !zip.equals( oldZip ) ){
			validUspsAddress = null;
		}
	}
	
	String relationShip = StringPool.BLANK;
	boolean family = false;
	boolean notFamily = false;
	public String getRelationship(){ return relationShip; }
	public void setRelationship( String relationship ){
		this.relationShip = relationship;
	}
	public void setFamily( boolean val ){
		this.family = val;
	}
	public boolean isFamily(){
//		return Toolbox.isEmpty( this.relationShip )? false: Toolbox.isFamily( this.relationShip );
		return family;
	}
	public void setNotFamily( boolean val ){
		this.notFamily = val;
	}
	public boolean isNotFamily(){
//		return Toolbox.isEmpty( this.relationShip )? false: !Toolbox.isFamily( this.relationShip );
		return notFamily;
	}
	
	public boolean equals(Object o) {
		if ( o instanceof Persn ){
			Person pO = new Person ( (Persn)o );
			if ( !Toolbox.isEmpty( getFirstName() ) && getFirstName().equals(pO.getFirstName() ) &&
					!Toolbox.isEmpty( getLastName() ) && getLastName().equals(pO.getLastName() ) && 
					!Toolbox.isEmpty( getSsn() ) && getSsn().equals(pO.getSsn() ) &&
					!Toolbox.isEmpty( getBirthDateStr() ) && getBirthDateStr().equals(pO.getBirthDateStr() ) ){
				return true;
			}
		}
        return super.equals(o);
    }
	
	public int hashCode(){
		return 0;
	}
	
	public void persist () throws SystemException{
		super.persist();
		if ( loadCrypto() != null ){
			_crypto.setCryptoValue( _nss );
			if ( ! Toolbox.isEmpty( _crypto.getCryptoValue() ) ){
				CryptoLocalServiceUtil.updateCrypto(_crypto);
			}
		}
//		for ( String enrollment : enrollments.keySet() ){
//			BaseModel<BgAsn> baseModel = enrollments.get(enrollment); 
//			if ( baseModel != null ) try {
//				((BgAsn)baseModel).setOwnerId(getPersnId());
//				CaretLocalServiceUtil.save( baseModel );
//			} catch (ApplicationWorkFlowException e) {
//				ApplicationWorkFlowException.handleException("COULD NOT SAVE "+ enrollment +" ENROLLMENT");
//			}
//		}
	}
	
	protected static Log _log = LogFactoryUtil.getLog( Person.class );

	public String toSearchString() {
		StringBuilder sb = new StringBuilder();
		if ( !Toolbox.isEmpty( getFirstName() ) ){
			sb.append(getFirstName());
		}
		if ( !Toolbox.isEmpty( getLastName() ) ){
			sb.append(getLastName());
		}
		if ( !Toolbox.isEmpty( getSsn() ) ){
			sb.append(getSsn());
		}
		if ( !Toolbox.isEmpty( getBirthDateStr() ) ){
			sb.append(getBirthDateStr());
		}
		if ( !Toolbox.isEmpty( getPhone() ) ){
			sb.append(getPhone());
		}
		if ( !Toolbox.isEmpty( getAddress() ) ){
			sb.append(getAddress());
		}
		if ( !Toolbox.isEmpty( getZip() ) ){
			sb.append(getZip());
		}
		return sb.toString();
	}

	public Map<String, Object> getPdfAttributes( Map<String, Object> extra ) {
		Map<String, Object> modelAttributes = super.getModelAttributes();  
		modelAttributes.put( "male", CaretStrPool.GENDER_TYPE_MALE.equals(getGender()) );
		modelAttributes.put( "female", CaretStrPool.GENDER_TYPE_FEMALE.equals(getGender()) );
		modelAttributes.put( "familyYes", isFamily() );
		modelAttributes.put( "familyNo", isNotFamily() );
		if ( getPersnId() > 0 ){
			modelAttributes.put( "relationship", LanguageUtil.get( ServiceContextThreadLocal.getServiceContext().getLocale(), getRelationship() ) );
			modelAttributes.put( "signedDate", Toolbox.formatDatePdf( ServiceContextThreadLocal.getServiceContext().getCreateDate() ) );
			modelAttributes.put( CaretStrPool.SSN, getSsn() );
			if ( getBirthDate() != null ){
				modelAttributes.put( "birthDate", Toolbox.formatDatePdf(getBirthDate()) );
			}
		} else {
			modelAttributes.put( "relationship", StringPool.BLANK );
			modelAttributes.put( "signedDate", StringPool.BLANK );
			modelAttributes.put( CaretStrPool.SSN, StringPool.BLANK );
			modelAttributes.put( "birthDate", StringPool.BLANK );
		}
		modelAttributes.putAll(extra);
		return modelAttributes;
	}
	
	private static final String DEFAULT_ESIGID = "TESTINGjcarterMAN400";
	
	public String getEsiguserId() {
		String val = getExternalId();
		return Toolbox.isEmpty(val)? DEFAULT_ESIGID : val;
	}

	public String getEsigEmail() {
		return getEmail();
	}

	public String getEsigGmtoffset() {
		return "-5";
	}

	public String getOnlineView(){ return StringPool.BLANK; }

	public Map<String, Object> getPfAttributes( Map<String, Object> extra ) {
		Map<String, Object> modelAttributes = super.getModelAttributes();  
		modelAttributes.put( "male", CaretStrPool.GENDER_TYPE_MALE.equals(getGender()) );
		modelAttributes.put( "female", CaretStrPool.GENDER_TYPE_FEMALE.equals(getGender()) );
		modelAttributes.put( "familyYes", isFamily() );
		modelAttributes.put( "familyNo", isNotFamily() );
		if ( getPersnId() > 0 ){
			modelAttributes.put( "relationship", LanguageUtil.get( ServiceContextThreadLocal.getServiceContext().getLocale(), getRelationship() ) );
			modelAttributes.put( "signedDate", Toolbox.formatDatePdf( ServiceContextThreadLocal.getServiceContext().getCreateDate() ) );
			modelAttributes.put( CaretStrPool.SSN, getSsn() );
			if ( getBirthDate() != null ){
				modelAttributes.put( "birthDate", Toolbox.formatDatePdf(getBirthDate()) );
			}
		} else {
			modelAttributes.put( "relationship", StringPool.BLANK );
			modelAttributes.put( "signedDate", StringPool.BLANK );
			modelAttributes.put( CaretStrPool.SSN, StringPool.BLANK );
			modelAttributes.put( "birthDate", StringPool.BLANK );
		}
		modelAttributes.putAll(extra);
		return modelAttributes;
	}
	
	public JSONObject toJson(  ) {
		return toJson ( Collections.EMPTY_MAP );
	}
	
	public JSONObject toJson( Map<String, Object> extra ) {

		JSONObject json = JSONFactoryUtil.createJSONObject();
		Map<String,Object> map = super.getModelAttributes();
		map.putAll(extra);
		for ( String key : map.keySet() ){
			Object obj = map.get(key);
			if ( obj instanceof String ){
				json.put(key, (String) obj ); 
			} else if ( obj instanceof Date ){
				json.put(key, Toolbox.formatDate( (Date) obj ) ); 
			} else if ( obj instanceof Boolean ){
				json.put(key, (Boolean) obj ); 
			} else if ( obj instanceof Long ){
				json.put(key, (Long) obj ); 
			}
		}
		
		return json;
	}

	
	private long timeStampId = 0;
	public void setTimeStampId( long tempId ){
		this.timeStampId = tempId;
	}
	public long getTimeStampId(){
		return this.timeStampId;
	}
	
	public JSONObject getJsonObject ( ) {
		JSONObject vcg = JSONFactoryUtil.createJSONObject();
	
		vcg.put(CaretStrPool.PRIMARY_KEY, getPrimaryKey() == 0? timeStampId: getPrimaryKey() );
		vcg.put(CaretStrPool.SSN, getSsn());
		vcg.put(CaretStrPool.BIRTHDATE, getBirthDateStr());
		vcg.put(CaretStrPool.LASTNAME, getLastName());
		vcg.put(CaretStrPool.FIRSTNAME, getFirstName());
		vcg.put("middleName", Toolbox.nullSafe(getMiddleName()));
		vcg.put("suffix", Toolbox.nullSafe((getSuffix())));
		vcg.put("phone", Toolbox.nullSafe(getPhone()));
		// vcg.put("phone2", Toolbox.nullSafe(getPhone2() ));
		vcg.put("email", Toolbox.nullSafe(getEmail()));
		vcg.put(CaretStrPool.ADDRESS, Toolbox.nullSafe(getAddress()));
		vcg.put(CaretStrPool.ADDRESS2, Toolbox.nullSafe(getAddress2()));
		vcg.put(CaretStrPool.CITY, Toolbox.nullSafe(getCity()));
		vcg.put(CaretStrPool.ZIP, Toolbox.nullSafe(getZip()));
		vcg.put(CaretStrPool.GENDER, Toolbox.nullSafe(getGender()));
		vcg.put(CaretStrPool.STATE, Toolbox.nullSafe(getState()));
	
		vcg.put(CaretStrPool.FOREIGNER, isForeigner());
		vcg.put(CaretStrPool.VALID_USPS_ADDRESS, isValidUspsAddress());
		vcg.put(CaretStrPool.RELATIONSHIP, getRelationship() );
		return vcg;
	}
	
	public static final int DOB = 0;
	public static final int SSN = 1;
	public static final int PHONE = 2;
	public static final int GENDER = 3;

	public static String mviFormat(int format, String value) {
		if ( Toolbox.isEmpty(value) ){
			return StringPool.BLANK;
		}
		switch(format){
		case DOB: return Toolbox.CARET_DATE_FORMAT_UI.equals(value) ? StringPool.BLANK : Toolbox.formatDateOrient( Toolbox.parseDate(value) );
		case SSN: return SSN_FORMAT.equals(value)? StringPool.BLANK : value.replace(StringPool.DASH, StringPool.BLANK);
		case PHONE: return PHONE_FORMAT.equals(value)? StringPool.BLANK : "tel:+1" + 
				value.replace(StringPool.OPEN_PARENTHESIS, StringPool.DASH).replace(") ", StringPool.DASH);
		case GENDER: return value.substring(0,1).toUpperCase();
		default: return StringPool.BLANK;
		}
	}
}
