package gov.va.caret.model.support;

import java.math.BigDecimal;

import com.liferay.portal.kernel.util.StringPool;

import gov.va.caret.model.NoteWrapper;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;

public class NoteSupport extends NoteWrapper  {

	private static final long serialVersionUID = 1L;
	
	public static int CALL = 1;
	public static int WORK = 2;
	public static int VCG = 3;
	
	
	public enum NoteGroup {
		ONLINE_APP ( 2l ),
		APP_DELAY ( 5l ),
		DELAY_REVIEWED ( 7l ),
		ASSIGN_GENERAL ( 10l ),
		CSC_APP( 15l ),
		CAREGIVER_INFO( 20l ),
		ASSOCIATE_NOTE ( 25l ),
		CREATE_VCG ( 30l ),
		CLOSE_NOTE ( 35l ),
		CUSTOM_NOTE ( 40l ),
		WORK_ASSIGN_NOTE ( 43l ),
		APPEAL(48l),
		DISPOSITION ( 50l ),
		CORRECTION_REQUEST ( 55l ),
		CORRECTIVE_RESPONSE ( 56l ),
		PROFILE_UPDATE ( 60l ),
		VENDOR_UPDATE ( 65l ),
		REFERRAL ( 70l ),
		CALL_NOTE ( 75l ),
		TIER_UPDATE ( 80l ),
		TRANSFER ( 90l ), 
		DUPLICATE_PAYMENT(92l),
		RECOUPMENT(93),
		REJECTED_PAYMENT(94),
		HELD_PAYMENT(95),
		LOST_CHECK(96),
		MANUAL_PAYMENT(97),
		RETURNED_PAYMENT(98),
		OCC_REVIEW_1 ( 100l ),
		OCC_FM(105l),
		
		LETTER_NOTE ( 110l );
		
		long groupId;
		NoteGroup ( long id ){
			this.groupId = id;
		}
		public long groupId(){
			return groupId;
		}
		public static NoteGroup getNoteGroup( Object o ){
			if ( o instanceof BigDecimal ){
				BigDecimal l = (BigDecimal)o;
				for ( NoteGroup next : NoteGroup.values() ){
					if ( l.longValue() == next.groupId ){
						return next;
					}
				}
			}
			return null;
		}
	}
	
	public String getUserName(){
		if ( getUserId() > 0 ){
			return CaretUtil.getUserFullName ( getUserId() );
		}
		return StringPool.BLANK;
	}
	
	public String getCreateDateStr ( ){
		if ( getCreationDate() != null ){
			return Toolbox.formatDateCprs( getCreationDate() );
		}
		return StringPool.BLANK;
	}
	
	public NoteSupport( gov.va.caret.model.Note noteImpl ) {
		super(noteImpl);
	}

	public void setValue( String value ){ 
		super.setValue( value.substring( 0, Math.min( 400, value.length() ) ) );
	}
	
}
