package gov.va.caret.model.support;

import java.util.List;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.FmsIc;
import gov.va.caret.model.FmsIcWrapper;
import gov.va.caret.model.FmsOg;
import gov.va.caret.model.StiPt;
import gov.va.caret.service.FmsOgLocalServiceUtil;
import gov.va.caret.service.StiPtLocalServiceUtil;

public class FmsIcSupport extends FmsIcWrapper {

	private List<StiPt> paymentConfig;
	
	public FmsIcSupport(FmsIc fmsIc) {
		super(fmsIc);
	}
	
	public List<StiPt> getPaymentConfigs() throws PortalException, SystemException{
		if ( paymentConfig == null ) {
			FmsOg og = FmsOgLocalServiceUtil.getFmsOg( Long.valueOf(getVoucherId()) );
			paymentConfig = StiPtLocalServiceUtil.findByVendorCycle( og.getVendrId(), og.getCycleId() );
		}
		return paymentConfig;
	}

}
