package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.ZipFy;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/**
 * The cache model class for representing ZipFy in entity cache.
 *
 * @author caret
 * @see ZipFy
 * @generated
 */
public class ZipFyCacheModel implements CacheModel<ZipFy>, Externalizable {
    public long zipFyId;
    public long facilId;
    public String facilZip;
    public double distance;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{zipFyId=");
        sb.append(zipFyId);
        sb.append(", facilId=");
        sb.append(facilId);
        sb.append(", facilZip=");
        sb.append(facilZip);
        sb.append(", distance=");
        sb.append(distance);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public ZipFy toEntityModel() {
        ZipFyImpl zipFyImpl = new ZipFyImpl();

        zipFyImpl.setZipFyId(zipFyId);
        zipFyImpl.setFacilId(facilId);

        if (facilZip == null) {
            zipFyImpl.setFacilZip(StringPool.BLANK);
        } else {
            zipFyImpl.setFacilZip(facilZip);
        }

        zipFyImpl.setDistance(distance);

        zipFyImpl.resetOriginalValues();

        return zipFyImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        zipFyId = objectInput.readLong();
        facilId = objectInput.readLong();
        facilZip = objectInput.readUTF();
        distance = objectInput.readDouble();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(zipFyId);
        objectOutput.writeLong(facilId);

        if (facilZip == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(facilZip);
        }

        objectOutput.writeDouble(distance);
    }
}
