package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.WorSe;
import gov.va.caret.model.WorSeModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the WorSe service. Represents a row in the &quot;CARET_WORK_ITEM_STATE&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.WorSeModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link WorSeImpl}.
 * </p>
 *
 * @author caret
 * @see WorSeImpl
 * @see gov.va.caret.model.WorSe
 * @see gov.va.caret.model.WorSeModel
 * @generated
 */
public class WorSeModelImpl extends BaseModelImpl<WorSe> implements WorSeModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a wor se model instance should use the {@link gov.va.caret.model.WorSe} interface instead.
     */
    public static final String TABLE_NAME = "CARET_WORK_ITEM_STATE";
    public static final Object[][] TABLE_COLUMNS = {
            { "worSeId", Types.BIGINT },
            { "worImId", Types.BIGINT },
            { "step", Types.VARCHAR },
            { "userId", Types.BIGINT },
            { "creationDate", Types.TIMESTAMP }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_WORK_ITEM_STATE (worSeId LONG not null primary key,worImId LONG,step VARCHAR(75) null,userId LONG,creationDate DATE null)";
    public static final String TABLE_SQL_DROP = "drop table CARET_WORK_ITEM_STATE";
    public static final String ORDER_BY_JPQL = " ORDER BY worSe.creationDate DESC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_WORK_ITEM_STATE.creationDate DESC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.WorSe"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.WorSe"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.WorSe"),
            true);
    public static long WORIMID_COLUMN_BITMASK = 1L;
    public static long CREATIONDATE_COLUMN_BITMASK = 2L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.WorSe"));
    private static ClassLoader _classLoader = WorSe.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { WorSe.class };
    private long _worSeId;
    private long _worImId;
    private long _originalWorImId;
    private boolean _setOriginalWorImId;
    private String _step;
    private long _userId;
    private String _userUuid;
    private Date _creationDate;
    private long _columnBitmask;
    private WorSe _escapedModel;

    public WorSeModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _worSeId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setWorSeId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _worSeId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return WorSe.class;
    }

    @Override
    public String getModelClassName() {
        return WorSe.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("worSeId", getWorSeId());
        attributes.put("worImId", getWorImId());
        attributes.put("step", getStep());
        attributes.put("userId", getUserId());
        attributes.put("creationDate", getCreationDate());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long worSeId = (Long) attributes.get("worSeId");

        if (worSeId != null) {
            setWorSeId(worSeId);
        }

        Long worImId = (Long) attributes.get("worImId");

        if (worImId != null) {
            setWorImId(worImId);
        }

        String step = (String) attributes.get("step");

        if (step != null) {
            setStep(step);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }
    }

    @Override
    public long getWorSeId() {
        return _worSeId;
    }

    @Override
    public void setWorSeId(long worSeId) {
        _worSeId = worSeId;
    }

    @Override
    public long getWorImId() {
        return _worImId;
    }

    @Override
    public void setWorImId(long worImId) {
        _columnBitmask |= WORIMID_COLUMN_BITMASK;

        if (!_setOriginalWorImId) {
            _setOriginalWorImId = true;

            _originalWorImId = _worImId;
        }

        _worImId = worImId;
    }

    public long getOriginalWorImId() {
        return _originalWorImId;
    }

    @Override
    public String getStep() {
        if (_step == null) {
            return StringPool.BLANK;
        } else {
            return _step;
        }
    }

    @Override
    public void setStep(String step) {
        _step = step;
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _userId = userId;
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _columnBitmask = -1L;

        _creationDate = creationDate;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            WorSe.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public WorSe toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (WorSe) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        WorSeImpl worSeImpl = new WorSeImpl();

        worSeImpl.setWorSeId(getWorSeId());
        worSeImpl.setWorImId(getWorImId());
        worSeImpl.setStep(getStep());
        worSeImpl.setUserId(getUserId());
        worSeImpl.setCreationDate(getCreationDate());

        worSeImpl.resetOriginalValues();

        return worSeImpl;
    }

    @Override
    public int compareTo(WorSe worSe) {
        int value = 0;

        value = DateUtil.compareTo(getCreationDate(), worSe.getCreationDate());

        value = value * -1;

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof WorSe)) {
            return false;
        }

        WorSe worSe = (WorSe) obj;

        long primaryKey = worSe.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        WorSeModelImpl worSeModelImpl = this;

        worSeModelImpl._originalWorImId = worSeModelImpl._worImId;

        worSeModelImpl._setOriginalWorImId = false;

        worSeModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<WorSe> toCacheModel() {
        WorSeCacheModel worSeCacheModel = new WorSeCacheModel();

        worSeCacheModel.worSeId = getWorSeId();

        worSeCacheModel.worImId = getWorImId();

        worSeCacheModel.step = getStep();

        String step = worSeCacheModel.step;

        if ((step != null) && (step.length() == 0)) {
            worSeCacheModel.step = null;
        }

        worSeCacheModel.userId = getUserId();

        Date creationDate = getCreationDate();

        if (creationDate != null) {
            worSeCacheModel.creationDate = creationDate.getTime();
        } else {
            worSeCacheModel.creationDate = Long.MIN_VALUE;
        }

        return worSeCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(11);

        sb.append("{worSeId=");
        sb.append(getWorSeId());
        sb.append(", worImId=");
        sb.append(getWorImId());
        sb.append(", step=");
        sb.append(getStep());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(19);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.WorSe");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>worSeId</column-name><column-value><![CDATA[");
        sb.append(getWorSeId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>worImId</column-name><column-value><![CDATA[");
        sb.append(getWorImId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>step</column-name><column-value><![CDATA[");
        sb.append(getStep());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
