package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.WorSe;
import gov.va.caret.service.WorSeLocalServiceUtil;

/**
 * The extended model base implementation for the WorSe service. Represents a row in the &quot;CARET_WORK_ITEM_STATE&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link WorSeImpl}.
 * </p>
 *
 * @author caret
 * @see WorSeImpl
 * @see gov.va.caret.model.WorSe
 * @generated
 */
public abstract class WorSeBaseImpl extends WorSeModelImpl implements WorSe {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a wor se model instance should use the {@link WorSe} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            WorSeLocalServiceUtil.addWorSe(this);
        } else {
            WorSeLocalServiceUtil.updateWorSe(this);
        }
    }
}
