package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.VetVr;
import gov.va.caret.model.VetVrModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the VetVr service. Represents a row in the &quot;CARET_VETERAN_VENDOR&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.VetVrModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link VetVrImpl}.
 * </p>
 *
 * @author caret
 * @see VetVrImpl
 * @see gov.va.caret.model.VetVr
 * @see gov.va.caret.model.VetVrModel
 * @generated
 */
public class VetVrModelImpl extends BaseModelImpl<VetVr> implements VetVrModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a vet vr model instance should use the {@link gov.va.caret.model.VetVr} interface instead.
     */
    public static final String TABLE_NAME = "CARET_VETERAN_VENDOR";
    public static final Object[][] TABLE_COLUMNS = {
            { "vetVrId", Types.BIGINT },
            { "vendrId", Types.BIGINT },
            { "cgId", Types.BIGINT },
            { "veteranId", Types.BIGINT },
            { "groupId", Types.BIGINT }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_VETERAN_VENDOR (vetVrId LONG not null primary key,vendrId LONG,cgId LONG,veteranId LONG,groupId LONG)";
    public static final String TABLE_SQL_DROP = "drop table CARET_VETERAN_VENDOR";
    public static final String ORDER_BY_JPQL = " ORDER BY vetVr.vetVrId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_VETERAN_VENDOR.vetVrId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.VetVr"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.VetVr"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = false;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.VetVr"));
    private static ClassLoader _classLoader = VetVr.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { VetVr.class };
    private long _vetVrId;
    private long _vendrId;
    private long _cgId;
    private long _veteranId;
    private long _groupId;
    private VetVr _escapedModel;

    public VetVrModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _vetVrId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setVetVrId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _vetVrId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return VetVr.class;
    }

    @Override
    public String getModelClassName() {
        return VetVr.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("vetVrId", getVetVrId());
        attributes.put("vendrId", getVendrId());
        attributes.put("cgId", getCgId());
        attributes.put("veteranId", getVeteranId());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long vetVrId = (Long) attributes.get("vetVrId");

        if (vetVrId != null) {
            setVetVrId(vetVrId);
        }

        Long vendrId = (Long) attributes.get("vendrId");

        if (vendrId != null) {
            setVendrId(vendrId);
        }

        Long cgId = (Long) attributes.get("cgId");

        if (cgId != null) {
            setCgId(cgId);
        }

        Long veteranId = (Long) attributes.get("veteranId");

        if (veteranId != null) {
            setVeteranId(veteranId);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    @Override
    public long getVetVrId() {
        return _vetVrId;
    }

    @Override
    public void setVetVrId(long vetVrId) {
        _vetVrId = vetVrId;
    }

    @Override
    public long getVendrId() {
        return _vendrId;
    }

    @Override
    public void setVendrId(long vendrId) {
        _vendrId = vendrId;
    }

    @Override
    public long getCgId() {
        return _cgId;
    }

    @Override
    public void setCgId(long cgId) {
        _cgId = cgId;
    }

    @Override
    public long getVeteranId() {
        return _veteranId;
    }

    @Override
    public void setVeteranId(long veteranId) {
        _veteranId = veteranId;
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            VetVr.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public VetVr toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (VetVr) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        VetVrImpl vetVrImpl = new VetVrImpl();

        vetVrImpl.setVetVrId(getVetVrId());
        vetVrImpl.setVendrId(getVendrId());
        vetVrImpl.setCgId(getCgId());
        vetVrImpl.setVeteranId(getVeteranId());
        vetVrImpl.setGroupId(getGroupId());

        vetVrImpl.resetOriginalValues();

        return vetVrImpl;
    }

    @Override
    public int compareTo(VetVr vetVr) {
        long primaryKey = vetVr.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof VetVr)) {
            return false;
        }

        VetVr vetVr = (VetVr) obj;

        long primaryKey = vetVr.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
    }

    @Override
    public CacheModel<VetVr> toCacheModel() {
        VetVrCacheModel vetVrCacheModel = new VetVrCacheModel();

        vetVrCacheModel.vetVrId = getVetVrId();

        vetVrCacheModel.vendrId = getVendrId();

        vetVrCacheModel.cgId = getCgId();

        vetVrCacheModel.veteranId = getVeteranId();

        vetVrCacheModel.groupId = getGroupId();

        return vetVrCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(11);

        sb.append("{vetVrId=");
        sb.append(getVetVrId());
        sb.append(", vendrId=");
        sb.append(getVendrId());
        sb.append(", cgId=");
        sb.append(getCgId());
        sb.append(", veteranId=");
        sb.append(getVeteranId());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(19);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.VetVr");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>vetVrId</column-name><column-value><![CDATA[");
        sb.append(getVetVrId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>vendrId</column-name><column-value><![CDATA[");
        sb.append(getVendrId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cgId</column-name><column-value><![CDATA[");
        sb.append(getCgId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>veteranId</column-name><column-value><![CDATA[");
        sb.append(getVeteranId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
