package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.VcgAn;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing VcgAn in entity cache.
 *
 * @author caret
 * @see VcgAn
 * @generated
 */
public class VcgAnCacheModel implements CacheModel<VcgAn>, Externalizable {
    public long vcgAnId;
    public long vcgId;
    public long veteranId;
    public long primaryId;
    public long secondaryId;
    public long secondaryTwoId;
    public String status;
    public long receivedDate;
    public String primaryRelationship;
    public String secondaryRelationship;
    public String secondaryTwoRelationship;
    public long primarySignDate;
    public long secondarySignDate;
    public long secondaryTwoSignDate;
    public boolean vaHealthEnrolled;
    public boolean mediEnrolled;
    public String lastTreatmentPlace;
    public boolean hospital;
    public boolean clinic;
    public long submitDate;
    public long creationDate;
    public long groupId;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(45);

        sb.append("{vcgAnId=");
        sb.append(vcgAnId);
        sb.append(", vcgId=");
        sb.append(vcgId);
        sb.append(", veteranId=");
        sb.append(veteranId);
        sb.append(", primaryId=");
        sb.append(primaryId);
        sb.append(", secondaryId=");
        sb.append(secondaryId);
        sb.append(", secondaryTwoId=");
        sb.append(secondaryTwoId);
        sb.append(", status=");
        sb.append(status);
        sb.append(", receivedDate=");
        sb.append(receivedDate);
        sb.append(", primaryRelationship=");
        sb.append(primaryRelationship);
        sb.append(", secondaryRelationship=");
        sb.append(secondaryRelationship);
        sb.append(", secondaryTwoRelationship=");
        sb.append(secondaryTwoRelationship);
        sb.append(", primarySignDate=");
        sb.append(primarySignDate);
        sb.append(", secondarySignDate=");
        sb.append(secondarySignDate);
        sb.append(", secondaryTwoSignDate=");
        sb.append(secondaryTwoSignDate);
        sb.append(", vaHealthEnrolled=");
        sb.append(vaHealthEnrolled);
        sb.append(", mediEnrolled=");
        sb.append(mediEnrolled);
        sb.append(", lastTreatmentPlace=");
        sb.append(lastTreatmentPlace);
        sb.append(", hospital=");
        sb.append(hospital);
        sb.append(", clinic=");
        sb.append(clinic);
        sb.append(", submitDate=");
        sb.append(submitDate);
        sb.append(", creationDate=");
        sb.append(creationDate);
        sb.append(", groupId=");
        sb.append(groupId);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public VcgAn toEntityModel() {
        VcgAnImpl vcgAnImpl = new VcgAnImpl();

        vcgAnImpl.setVcgAnId(vcgAnId);
        vcgAnImpl.setVcgId(vcgId);
        vcgAnImpl.setVeteranId(veteranId);
        vcgAnImpl.setPrimaryId(primaryId);
        vcgAnImpl.setSecondaryId(secondaryId);
        vcgAnImpl.setSecondaryTwoId(secondaryTwoId);

        if (status == null) {
            vcgAnImpl.setStatus(StringPool.BLANK);
        } else {
            vcgAnImpl.setStatus(status);
        }

        if (receivedDate == Long.MIN_VALUE) {
            vcgAnImpl.setReceivedDate(null);
        } else {
            vcgAnImpl.setReceivedDate(new Date(receivedDate));
        }

        if (primaryRelationship == null) {
            vcgAnImpl.setPrimaryRelationship(StringPool.BLANK);
        } else {
            vcgAnImpl.setPrimaryRelationship(primaryRelationship);
        }

        if (secondaryRelationship == null) {
            vcgAnImpl.setSecondaryRelationship(StringPool.BLANK);
        } else {
            vcgAnImpl.setSecondaryRelationship(secondaryRelationship);
        }

        if (secondaryTwoRelationship == null) {
            vcgAnImpl.setSecondaryTwoRelationship(StringPool.BLANK);
        } else {
            vcgAnImpl.setSecondaryTwoRelationship(secondaryTwoRelationship);
        }

        if (primarySignDate == Long.MIN_VALUE) {
            vcgAnImpl.setPrimarySignDate(null);
        } else {
            vcgAnImpl.setPrimarySignDate(new Date(primarySignDate));
        }

        if (secondarySignDate == Long.MIN_VALUE) {
            vcgAnImpl.setSecondarySignDate(null);
        } else {
            vcgAnImpl.setSecondarySignDate(new Date(secondarySignDate));
        }

        if (secondaryTwoSignDate == Long.MIN_VALUE) {
            vcgAnImpl.setSecondaryTwoSignDate(null);
        } else {
            vcgAnImpl.setSecondaryTwoSignDate(new Date(secondaryTwoSignDate));
        }

        vcgAnImpl.setVaHealthEnrolled(vaHealthEnrolled);
        vcgAnImpl.setMediEnrolled(mediEnrolled);

        if (lastTreatmentPlace == null) {
            vcgAnImpl.setLastTreatmentPlace(StringPool.BLANK);
        } else {
            vcgAnImpl.setLastTreatmentPlace(lastTreatmentPlace);
        }

        vcgAnImpl.setHospital(hospital);
        vcgAnImpl.setClinic(clinic);

        if (submitDate == Long.MIN_VALUE) {
            vcgAnImpl.setSubmitDate(null);
        } else {
            vcgAnImpl.setSubmitDate(new Date(submitDate));
        }

        if (creationDate == Long.MIN_VALUE) {
            vcgAnImpl.setCreationDate(null);
        } else {
            vcgAnImpl.setCreationDate(new Date(creationDate));
        }

        vcgAnImpl.setGroupId(groupId);

        vcgAnImpl.resetOriginalValues();

        return vcgAnImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        vcgAnId = objectInput.readLong();
        vcgId = objectInput.readLong();
        veteranId = objectInput.readLong();
        primaryId = objectInput.readLong();
        secondaryId = objectInput.readLong();
        secondaryTwoId = objectInput.readLong();
        status = objectInput.readUTF();
        receivedDate = objectInput.readLong();
        primaryRelationship = objectInput.readUTF();
        secondaryRelationship = objectInput.readUTF();
        secondaryTwoRelationship = objectInput.readUTF();
        primarySignDate = objectInput.readLong();
        secondarySignDate = objectInput.readLong();
        secondaryTwoSignDate = objectInput.readLong();
        vaHealthEnrolled = objectInput.readBoolean();
        mediEnrolled = objectInput.readBoolean();
        lastTreatmentPlace = objectInput.readUTF();
        hospital = objectInput.readBoolean();
        clinic = objectInput.readBoolean();
        submitDate = objectInput.readLong();
        creationDate = objectInput.readLong();
        groupId = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(vcgAnId);
        objectOutput.writeLong(vcgId);
        objectOutput.writeLong(veteranId);
        objectOutput.writeLong(primaryId);
        objectOutput.writeLong(secondaryId);
        objectOutput.writeLong(secondaryTwoId);

        if (status == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(status);
        }

        objectOutput.writeLong(receivedDate);

        if (primaryRelationship == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(primaryRelationship);
        }

        if (secondaryRelationship == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(secondaryRelationship);
        }

        if (secondaryTwoRelationship == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(secondaryTwoRelationship);
        }

        objectOutput.writeLong(primarySignDate);
        objectOutput.writeLong(secondarySignDate);
        objectOutput.writeLong(secondaryTwoSignDate);
        objectOutput.writeBoolean(vaHealthEnrolled);
        objectOutput.writeBoolean(mediEnrolled);

        if (lastTreatmentPlace == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(lastTreatmentPlace);
        }

        objectOutput.writeBoolean(hospital);
        objectOutput.writeBoolean(clinic);
        objectOutput.writeLong(submitDate);
        objectOutput.writeLong(creationDate);
        objectOutput.writeLong(groupId);
    }
}
