package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.PMReadMessage;
import gov.va.caret.service.PMReadMessageLocalServiceUtil;

/**
 * The extended model base implementation for the PMReadMessage service. Represents a row in the &quot;read_message&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PMReadMessageImpl}.
 * </p>
 *
 * @author caret
 * @see PMReadMessageImpl
 * @see gov.va.caret.model.PMReadMessage
 * @generated
 */
public abstract class PMReadMessageBaseImpl extends PMReadMessageModelImpl
    implements PMReadMessage {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a p m read message model instance should use the {@link PMReadMessage} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            PMReadMessageLocalServiceUtil.addPMReadMessage(this);
        } else {
            PMReadMessageLocalServiceUtil.updatePMReadMessage(this);
        }
    }
}
