package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.PMMessage;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing PMMessage in entity cache.
 *
 * @author caret
 * @see PMMessage
 * @generated
 */
public class PMMessageCacheModel implements CacheModel<PMMessage>,
    Externalizable {
    public long messageId;
    public String subject;
    public String body;
    public String url;
    public long parentMessageId;
    public long ownerId;
    public String ownerName;
    public long postedDate;
    public String recepients;
    public String readRecepients;
    public boolean isRead;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(23);

        sb.append("{messageId=");
        sb.append(messageId);
        sb.append(", subject=");
        sb.append(subject);
        sb.append(", body=");
        sb.append(body);
        sb.append(", url=");
        sb.append(url);
        sb.append(", parentMessageId=");
        sb.append(parentMessageId);
        sb.append(", ownerId=");
        sb.append(ownerId);
        sb.append(", ownerName=");
        sb.append(ownerName);
        sb.append(", postedDate=");
        sb.append(postedDate);
        sb.append(", recepients=");
        sb.append(recepients);
        sb.append(", readRecepients=");
        sb.append(readRecepients);
        sb.append(", isRead=");
        sb.append(isRead);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public PMMessage toEntityModel() {
        PMMessageImpl pmMessageImpl = new PMMessageImpl();

        pmMessageImpl.setMessageId(messageId);

        if (subject == null) {
            pmMessageImpl.setSubject(StringPool.BLANK);
        } else {
            pmMessageImpl.setSubject(subject);
        }

        if (body == null) {
            pmMessageImpl.setBody(StringPool.BLANK);
        } else {
            pmMessageImpl.setBody(body);
        }

        if (url == null) {
            pmMessageImpl.setUrl(StringPool.BLANK);
        } else {
            pmMessageImpl.setUrl(url);
        }

        pmMessageImpl.setParentMessageId(parentMessageId);
        pmMessageImpl.setOwnerId(ownerId);

        if (ownerName == null) {
            pmMessageImpl.setOwnerName(StringPool.BLANK);
        } else {
            pmMessageImpl.setOwnerName(ownerName);
        }

        if (postedDate == Long.MIN_VALUE) {
            pmMessageImpl.setPostedDate(null);
        } else {
            pmMessageImpl.setPostedDate(new Date(postedDate));
        }

        if (recepients == null) {
            pmMessageImpl.setRecepients(StringPool.BLANK);
        } else {
            pmMessageImpl.setRecepients(recepients);
        }

        if (readRecepients == null) {
            pmMessageImpl.setReadRecepients(StringPool.BLANK);
        } else {
            pmMessageImpl.setReadRecepients(readRecepients);
        }

        pmMessageImpl.setIsRead(isRead);

        pmMessageImpl.resetOriginalValues();

        return pmMessageImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        messageId = objectInput.readLong();
        subject = objectInput.readUTF();
        body = objectInput.readUTF();
        url = objectInput.readUTF();
        parentMessageId = objectInput.readLong();
        ownerId = objectInput.readLong();
        ownerName = objectInput.readUTF();
        postedDate = objectInput.readLong();
        recepients = objectInput.readUTF();
        readRecepients = objectInput.readUTF();
        isRead = objectInput.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(messageId);

        if (subject == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(subject);
        }

        if (body == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(body);
        }

        if (url == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(url);
        }

        objectOutput.writeLong(parentMessageId);
        objectOutput.writeLong(ownerId);

        if (ownerName == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(ownerName);
        }

        objectOutput.writeLong(postedDate);

        if (recepients == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(recepients);
        }

        if (readRecepients == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(readRecepients);
        }

        objectOutput.writeBoolean(isRead);
    }
}
