package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.Notif;
import gov.va.caret.service.NotifLocalServiceUtil;

/**
 * The extended model base implementation for the Notif service. Represents a row in the &quot;CARET_NOTIFICATION&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link NotifImpl}.
 * </p>
 *
 * @author caret
 * @see NotifImpl
 * @see gov.va.caret.model.Notif
 * @generated
 */
public abstract class NotifBaseImpl extends NotifModelImpl implements Notif {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a notif model instance should use the {@link Notif} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            NotifLocalServiceUtil.addNotif(this);
        } else {
            NotifLocalServiceUtil.updateNotif(this);
        }
    }
}
