package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.Docum;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/**
 * The cache model class for representing Docum in entity cache.
 *
 * @author caret
 * @see Docum
 * @generated
 */
public class DocumCacheModel implements CacheModel<Docum>, Externalizable {
    public long documId;
    public long classId;
    public long classPk;
    public String name;
    public String type;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(11);

        sb.append("{documId=");
        sb.append(documId);
        sb.append(", classId=");
        sb.append(classId);
        sb.append(", classPk=");
        sb.append(classPk);
        sb.append(", name=");
        sb.append(name);
        sb.append(", type=");
        sb.append(type);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public Docum toEntityModel() {
        DocumImpl documImpl = new DocumImpl();

        documImpl.setDocumId(documId);
        documImpl.setClassId(classId);
        documImpl.setClassPk(classPk);

        if (name == null) {
            documImpl.setName(StringPool.BLANK);
        } else {
            documImpl.setName(name);
        }

        if (type == null) {
            documImpl.setType(StringPool.BLANK);
        } else {
            documImpl.setType(type);
        }

        documImpl.resetOriginalValues();

        return documImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        documId = objectInput.readLong();
        classId = objectInput.readLong();
        classPk = objectInput.readLong();
        name = objectInput.readUTF();
        type = objectInput.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(documId);
        objectOutput.writeLong(classId);
        objectOutput.writeLong(classPk);

        if (name == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(name);
        }

        if (type == null) {
            objectOutput.writeUTF(StringPool.BLANK);
        } else {
            objectOutput.writeUTF(type);
        }
    }
}
