package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.Docum;
import gov.va.caret.service.DocumLocalServiceUtil;

/**
 * The extended model base implementation for the Docum service. Represents a row in the &quot;CARET_DOCUMENT&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DocumImpl}.
 * </p>
 *
 * @author caret
 * @see DocumImpl
 * @see gov.va.caret.model.Docum
 * @generated
 */
public abstract class DocumBaseImpl extends DocumModelImpl implements Docum {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a docum model instance should use the {@link Docum} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            DocumLocalServiceUtil.addDocum(this);
        } else {
            DocumLocalServiceUtil.updateDocum(this);
        }
    }
}
