package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.ClSoc;
import gov.va.caret.model.ClSocModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the ClSoc service. Represents a row in the &quot;CARET_SOC&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.ClSocModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ClSocImpl}.
 * </p>
 *
 * @author caret
 * @see ClSocImpl
 * @see gov.va.caret.model.ClSoc
 * @see gov.va.caret.model.ClSocModel
 * @generated
 */
public class ClSocModelImpl extends BaseModelImpl<ClSoc> implements ClSocModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a cl soc model instance should use the {@link gov.va.caret.model.ClSoc} interface instead.
     */
    public static final String TABLE_NAME = "CARET_SOC";
    public static final Object[][] TABLE_COLUMNS = {
            { "clSocId", Types.BIGINT },
            { "callId", Types.BIGINT },
            { "persnId", Types.BIGINT },
            { "surveyStatus", Types.VARCHAR },
            { "surveyComment", Types.VARCHAR },
            { "creationDate", Types.TIMESTAMP },
            { "attemptNum", Types.VARCHAR },
            { "callerAvailable", Types.VARCHAR },
            { "requestedCallbackTime", Types.VARCHAR },
            { "willingToAnsQues", Types.VARCHAR },
            { "calledCsl", Types.VARCHAR },
            { "cslKnowledgable", Types.VARCHAR },
            { "cslSupportive", Types.VARCHAR },
            { "localResSuggested", Types.VARCHAR },
            { "localResContacted", Types.VARCHAR },
            { "rsnLocalResNotContacted", Types.VARCHAR },
            { "localResHelpful", Types.VARCHAR },
            { "concernsAnswered", Types.VARCHAR },
            { "understandNextSteps", Types.VARCHAR },
            { "callCslAgain", Types.VARCHAR },
            { "recommendCsl", Types.VARCHAR },
            { "suggestions", Types.VARCHAR },
            { "followupCall", Types.VARCHAR },
            { "followupCallTime", Types.VARCHAR },
            { "tresholdMet", Types.VARCHAR }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_SOC (clSocId LONG not null primary key,callId LONG,persnId LONG,surveyStatus VARCHAR(75) null,surveyComment VARCHAR(75) null,creationDate DATE null,attemptNum VARCHAR(75) null,callerAvailable VARCHAR(75) null,requestedCallbackTime VARCHAR(75) null,willingToAnsQues VARCHAR(75) null,calledCsl VARCHAR(75) null,cslKnowledgable VARCHAR(75) null,cslSupportive VARCHAR(75) null,localResSuggested VARCHAR(75) null,localResContacted VARCHAR(75) null,rsnLocalResNotContacted VARCHAR(75) null,localResHelpful VARCHAR(75) null,concernsAnswered VARCHAR(75) null,understandNextSteps VARCHAR(75) null,callCslAgain VARCHAR(75) null,recommendCsl VARCHAR(75) null,suggestions VARCHAR(75) null,followupCall VARCHAR(75) null,followupCallTime VARCHAR(75) null,tresholdMet VARCHAR(75) null)";
    public static final String TABLE_SQL_DROP = "drop table CARET_SOC";
    public static final String ORDER_BY_JPQL = " ORDER BY clSoc.clSocId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_SOC.clSocId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.ClSoc"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.ClSoc"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.ClSoc"),
            true);
    public static long CALLID_COLUMN_BITMASK = 1L;
    public static long CLSOCID_COLUMN_BITMASK = 2L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.ClSoc"));
    private static ClassLoader _classLoader = ClSoc.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { ClSoc.class };
    private long _clSocId;
    private long _callId;
    private long _originalCallId;
    private boolean _setOriginalCallId;
    private long _persnId;
    private String _surveyStatus;
    private String _surveyComment;
    private Date _creationDate;
    private String _attemptNum;
    private String _callerAvailable;
    private String _requestedCallbackTime;
    private String _willingToAnsQues;
    private String _calledCsl;
    private String _cslKnowledgable;
    private String _cslSupportive;
    private String _localResSuggested;
    private String _localResContacted;
    private String _rsnLocalResNotContacted;
    private String _localResHelpful;
    private String _concernsAnswered;
    private String _understandNextSteps;
    private String _callCslAgain;
    private String _recommendCsl;
    private String _suggestions;
    private String _followupCall;
    private String _followupCallTime;
    private String _tresholdMet;
    private long _columnBitmask;
    private ClSoc _escapedModel;

    public ClSocModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _clSocId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setClSocId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _clSocId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return ClSoc.class;
    }

    @Override
    public String getModelClassName() {
        return ClSoc.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("clSocId", getClSocId());
        attributes.put("callId", getCallId());
        attributes.put("persnId", getPersnId());
        attributes.put("surveyStatus", getSurveyStatus());
        attributes.put("surveyComment", getSurveyComment());
        attributes.put("creationDate", getCreationDate());
        attributes.put("attemptNum", getAttemptNum());
        attributes.put("callerAvailable", getCallerAvailable());
        attributes.put("requestedCallbackTime", getRequestedCallbackTime());
        attributes.put("willingToAnsQues", getWillingToAnsQues());
        attributes.put("calledCsl", getCalledCsl());
        attributes.put("cslKnowledgable", getCslKnowledgable());
        attributes.put("cslSupportive", getCslSupportive());
        attributes.put("localResSuggested", getLocalResSuggested());
        attributes.put("localResContacted", getLocalResContacted());
        attributes.put("rsnLocalResNotContacted", getRsnLocalResNotContacted());
        attributes.put("localResHelpful", getLocalResHelpful());
        attributes.put("concernsAnswered", getConcernsAnswered());
        attributes.put("understandNextSteps", getUnderstandNextSteps());
        attributes.put("callCslAgain", getCallCslAgain());
        attributes.put("recommendCsl", getRecommendCsl());
        attributes.put("suggestions", getSuggestions());
        attributes.put("followupCall", getFollowupCall());
        attributes.put("followupCallTime", getFollowupCallTime());
        attributes.put("tresholdMet", getTresholdMet());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long clSocId = (Long) attributes.get("clSocId");

        if (clSocId != null) {
            setClSocId(clSocId);
        }

        Long callId = (Long) attributes.get("callId");

        if (callId != null) {
            setCallId(callId);
        }

        Long persnId = (Long) attributes.get("persnId");

        if (persnId != null) {
            setPersnId(persnId);
        }

        String surveyStatus = (String) attributes.get("surveyStatus");

        if (surveyStatus != null) {
            setSurveyStatus(surveyStatus);
        }

        String surveyComment = (String) attributes.get("surveyComment");

        if (surveyComment != null) {
            setSurveyComment(surveyComment);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        String attemptNum = (String) attributes.get("attemptNum");

        if (attemptNum != null) {
            setAttemptNum(attemptNum);
        }

        String callerAvailable = (String) attributes.get("callerAvailable");

        if (callerAvailable != null) {
            setCallerAvailable(callerAvailable);
        }

        String requestedCallbackTime = (String) attributes.get(
                "requestedCallbackTime");

        if (requestedCallbackTime != null) {
            setRequestedCallbackTime(requestedCallbackTime);
        }

        String willingToAnsQues = (String) attributes.get("willingToAnsQues");

        if (willingToAnsQues != null) {
            setWillingToAnsQues(willingToAnsQues);
        }

        String calledCsl = (String) attributes.get("calledCsl");

        if (calledCsl != null) {
            setCalledCsl(calledCsl);
        }

        String cslKnowledgable = (String) attributes.get("cslKnowledgable");

        if (cslKnowledgable != null) {
            setCslKnowledgable(cslKnowledgable);
        }

        String cslSupportive = (String) attributes.get("cslSupportive");

        if (cslSupportive != null) {
            setCslSupportive(cslSupportive);
        }

        String localResSuggested = (String) attributes.get("localResSuggested");

        if (localResSuggested != null) {
            setLocalResSuggested(localResSuggested);
        }

        String localResContacted = (String) attributes.get("localResContacted");

        if (localResContacted != null) {
            setLocalResContacted(localResContacted);
        }

        String rsnLocalResNotContacted = (String) attributes.get(
                "rsnLocalResNotContacted");

        if (rsnLocalResNotContacted != null) {
            setRsnLocalResNotContacted(rsnLocalResNotContacted);
        }

        String localResHelpful = (String) attributes.get("localResHelpful");

        if (localResHelpful != null) {
            setLocalResHelpful(localResHelpful);
        }

        String concernsAnswered = (String) attributes.get("concernsAnswered");

        if (concernsAnswered != null) {
            setConcernsAnswered(concernsAnswered);
        }

        String understandNextSteps = (String) attributes.get(
                "understandNextSteps");

        if (understandNextSteps != null) {
            setUnderstandNextSteps(understandNextSteps);
        }

        String callCslAgain = (String) attributes.get("callCslAgain");

        if (callCslAgain != null) {
            setCallCslAgain(callCslAgain);
        }

        String recommendCsl = (String) attributes.get("recommendCsl");

        if (recommendCsl != null) {
            setRecommendCsl(recommendCsl);
        }

        String suggestions = (String) attributes.get("suggestions");

        if (suggestions != null) {
            setSuggestions(suggestions);
        }

        String followupCall = (String) attributes.get("followupCall");

        if (followupCall != null) {
            setFollowupCall(followupCall);
        }

        String followupCallTime = (String) attributes.get("followupCallTime");

        if (followupCallTime != null) {
            setFollowupCallTime(followupCallTime);
        }

        String tresholdMet = (String) attributes.get("tresholdMet");

        if (tresholdMet != null) {
            setTresholdMet(tresholdMet);
        }
    }

    @Override
    public long getClSocId() {
        return _clSocId;
    }

    @Override
    public void setClSocId(long clSocId) {
        _clSocId = clSocId;
    }

    @Override
    public long getCallId() {
        return _callId;
    }

    @Override
    public void setCallId(long callId) {
        _columnBitmask |= CALLID_COLUMN_BITMASK;

        if (!_setOriginalCallId) {
            _setOriginalCallId = true;

            _originalCallId = _callId;
        }

        _callId = callId;
    }

    public long getOriginalCallId() {
        return _originalCallId;
    }

    @Override
    public long getPersnId() {
        return _persnId;
    }

    @Override
    public void setPersnId(long persnId) {
        _persnId = persnId;
    }

    @Override
    public String getSurveyStatus() {
        if (_surveyStatus == null) {
            return StringPool.BLANK;
        } else {
            return _surveyStatus;
        }
    }

    @Override
    public void setSurveyStatus(String surveyStatus) {
        _surveyStatus = surveyStatus;
    }

    @Override
    public String getSurveyComment() {
        if (_surveyComment == null) {
            return StringPool.BLANK;
        } else {
            return _surveyComment;
        }
    }

    @Override
    public void setSurveyComment(String surveyComment) {
        _surveyComment = surveyComment;
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;
    }

    @Override
    public String getAttemptNum() {
        if (_attemptNum == null) {
            return StringPool.BLANK;
        } else {
            return _attemptNum;
        }
    }

    @Override
    public void setAttemptNum(String attemptNum) {
        _attemptNum = attemptNum;
    }

    @Override
    public String getCallerAvailable() {
        if (_callerAvailable == null) {
            return StringPool.BLANK;
        } else {
            return _callerAvailable;
        }
    }

    @Override
    public void setCallerAvailable(String callerAvailable) {
        _callerAvailable = callerAvailable;
    }

    @Override
    public String getRequestedCallbackTime() {
        if (_requestedCallbackTime == null) {
            return StringPool.BLANK;
        } else {
            return _requestedCallbackTime;
        }
    }

    @Override
    public void setRequestedCallbackTime(String requestedCallbackTime) {
        _requestedCallbackTime = requestedCallbackTime;
    }

    @Override
    public String getWillingToAnsQues() {
        if (_willingToAnsQues == null) {
            return StringPool.BLANK;
        } else {
            return _willingToAnsQues;
        }
    }

    @Override
    public void setWillingToAnsQues(String willingToAnsQues) {
        _willingToAnsQues = willingToAnsQues;
    }

    @Override
    public String getCalledCsl() {
        if (_calledCsl == null) {
            return StringPool.BLANK;
        } else {
            return _calledCsl;
        }
    }

    @Override
    public void setCalledCsl(String calledCsl) {
        _calledCsl = calledCsl;
    }

    @Override
    public String getCslKnowledgable() {
        if (_cslKnowledgable == null) {
            return StringPool.BLANK;
        } else {
            return _cslKnowledgable;
        }
    }

    @Override
    public void setCslKnowledgable(String cslKnowledgable) {
        _cslKnowledgable = cslKnowledgable;
    }

    @Override
    public String getCslSupportive() {
        if (_cslSupportive == null) {
            return StringPool.BLANK;
        } else {
            return _cslSupportive;
        }
    }

    @Override
    public void setCslSupportive(String cslSupportive) {
        _cslSupportive = cslSupportive;
    }

    @Override
    public String getLocalResSuggested() {
        if (_localResSuggested == null) {
            return StringPool.BLANK;
        } else {
            return _localResSuggested;
        }
    }

    @Override
    public void setLocalResSuggested(String localResSuggested) {
        _localResSuggested = localResSuggested;
    }

    @Override
    public String getLocalResContacted() {
        if (_localResContacted == null) {
            return StringPool.BLANK;
        } else {
            return _localResContacted;
        }
    }

    @Override
    public void setLocalResContacted(String localResContacted) {
        _localResContacted = localResContacted;
    }

    @Override
    public String getRsnLocalResNotContacted() {
        if (_rsnLocalResNotContacted == null) {
            return StringPool.BLANK;
        } else {
            return _rsnLocalResNotContacted;
        }
    }

    @Override
    public void setRsnLocalResNotContacted(String rsnLocalResNotContacted) {
        _rsnLocalResNotContacted = rsnLocalResNotContacted;
    }

    @Override
    public String getLocalResHelpful() {
        if (_localResHelpful == null) {
            return StringPool.BLANK;
        } else {
            return _localResHelpful;
        }
    }

    @Override
    public void setLocalResHelpful(String localResHelpful) {
        _localResHelpful = localResHelpful;
    }

    @Override
    public String getConcernsAnswered() {
        if (_concernsAnswered == null) {
            return StringPool.BLANK;
        } else {
            return _concernsAnswered;
        }
    }

    @Override
    public void setConcernsAnswered(String concernsAnswered) {
        _concernsAnswered = concernsAnswered;
    }

    @Override
    public String getUnderstandNextSteps() {
        if (_understandNextSteps == null) {
            return StringPool.BLANK;
        } else {
            return _understandNextSteps;
        }
    }

    @Override
    public void setUnderstandNextSteps(String understandNextSteps) {
        _understandNextSteps = understandNextSteps;
    }

    @Override
    public String getCallCslAgain() {
        if (_callCslAgain == null) {
            return StringPool.BLANK;
        } else {
            return _callCslAgain;
        }
    }

    @Override
    public void setCallCslAgain(String callCslAgain) {
        _callCslAgain = callCslAgain;
    }

    @Override
    public String getRecommendCsl() {
        if (_recommendCsl == null) {
            return StringPool.BLANK;
        } else {
            return _recommendCsl;
        }
    }

    @Override
    public void setRecommendCsl(String recommendCsl) {
        _recommendCsl = recommendCsl;
    }

    @Override
    public String getSuggestions() {
        if (_suggestions == null) {
            return StringPool.BLANK;
        } else {
            return _suggestions;
        }
    }

    @Override
    public void setSuggestions(String suggestions) {
        _suggestions = suggestions;
    }

    @Override
    public String getFollowupCall() {
        if (_followupCall == null) {
            return StringPool.BLANK;
        } else {
            return _followupCall;
        }
    }

    @Override
    public void setFollowupCall(String followupCall) {
        _followupCall = followupCall;
    }

    @Override
    public String getFollowupCallTime() {
        if (_followupCallTime == null) {
            return StringPool.BLANK;
        } else {
            return _followupCallTime;
        }
    }

    @Override
    public void setFollowupCallTime(String followupCallTime) {
        _followupCallTime = followupCallTime;
    }

    @Override
    public String getTresholdMet() {
        if (_tresholdMet == null) {
            return StringPool.BLANK;
        } else {
            return _tresholdMet;
        }
    }

    @Override
    public void setTresholdMet(String tresholdMet) {
        _tresholdMet = tresholdMet;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            ClSoc.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public ClSoc toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (ClSoc) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        ClSocImpl clSocImpl = new ClSocImpl();

        clSocImpl.setClSocId(getClSocId());
        clSocImpl.setCallId(getCallId());
        clSocImpl.setPersnId(getPersnId());
        clSocImpl.setSurveyStatus(getSurveyStatus());
        clSocImpl.setSurveyComment(getSurveyComment());
        clSocImpl.setCreationDate(getCreationDate());
        clSocImpl.setAttemptNum(getAttemptNum());
        clSocImpl.setCallerAvailable(getCallerAvailable());
        clSocImpl.setRequestedCallbackTime(getRequestedCallbackTime());
        clSocImpl.setWillingToAnsQues(getWillingToAnsQues());
        clSocImpl.setCalledCsl(getCalledCsl());
        clSocImpl.setCslKnowledgable(getCslKnowledgable());
        clSocImpl.setCslSupportive(getCslSupportive());
        clSocImpl.setLocalResSuggested(getLocalResSuggested());
        clSocImpl.setLocalResContacted(getLocalResContacted());
        clSocImpl.setRsnLocalResNotContacted(getRsnLocalResNotContacted());
        clSocImpl.setLocalResHelpful(getLocalResHelpful());
        clSocImpl.setConcernsAnswered(getConcernsAnswered());
        clSocImpl.setUnderstandNextSteps(getUnderstandNextSteps());
        clSocImpl.setCallCslAgain(getCallCslAgain());
        clSocImpl.setRecommendCsl(getRecommendCsl());
        clSocImpl.setSuggestions(getSuggestions());
        clSocImpl.setFollowupCall(getFollowupCall());
        clSocImpl.setFollowupCallTime(getFollowupCallTime());
        clSocImpl.setTresholdMet(getTresholdMet());

        clSocImpl.resetOriginalValues();

        return clSocImpl;
    }

    @Override
    public int compareTo(ClSoc clSoc) {
        long primaryKey = clSoc.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof ClSoc)) {
            return false;
        }

        ClSoc clSoc = (ClSoc) obj;

        long primaryKey = clSoc.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        ClSocModelImpl clSocModelImpl = this;

        clSocModelImpl._originalCallId = clSocModelImpl._callId;

        clSocModelImpl._setOriginalCallId = false;

        clSocModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<ClSoc> toCacheModel() {
        ClSocCacheModel clSocCacheModel = new ClSocCacheModel();

        clSocCacheModel.clSocId = getClSocId();

        clSocCacheModel.callId = getCallId();

        clSocCacheModel.persnId = getPersnId();

        clSocCacheModel.surveyStatus = getSurveyStatus();

        String surveyStatus = clSocCacheModel.surveyStatus;

        if ((surveyStatus != null) && (surveyStatus.length() == 0)) {
            clSocCacheModel.surveyStatus = null;
        }

        clSocCacheModel.surveyComment = getSurveyComment();

        String surveyComment = clSocCacheModel.surveyComment;

        if ((surveyComment != null) && (surveyComment.length() == 0)) {
            clSocCacheModel.surveyComment = null;
        }

        Date creationDate = getCreationDate();

        if (creationDate != null) {
            clSocCacheModel.creationDate = creationDate.getTime();
        } else {
            clSocCacheModel.creationDate = Long.MIN_VALUE;
        }

        clSocCacheModel.attemptNum = getAttemptNum();

        String attemptNum = clSocCacheModel.attemptNum;

        if ((attemptNum != null) && (attemptNum.length() == 0)) {
            clSocCacheModel.attemptNum = null;
        }

        clSocCacheModel.callerAvailable = getCallerAvailable();

        String callerAvailable = clSocCacheModel.callerAvailable;

        if ((callerAvailable != null) && (callerAvailable.length() == 0)) {
            clSocCacheModel.callerAvailable = null;
        }

        clSocCacheModel.requestedCallbackTime = getRequestedCallbackTime();

        String requestedCallbackTime = clSocCacheModel.requestedCallbackTime;

        if ((requestedCallbackTime != null) &&
                (requestedCallbackTime.length() == 0)) {
            clSocCacheModel.requestedCallbackTime = null;
        }

        clSocCacheModel.willingToAnsQues = getWillingToAnsQues();

        String willingToAnsQues = clSocCacheModel.willingToAnsQues;

        if ((willingToAnsQues != null) && (willingToAnsQues.length() == 0)) {
            clSocCacheModel.willingToAnsQues = null;
        }

        clSocCacheModel.calledCsl = getCalledCsl();

        String calledCsl = clSocCacheModel.calledCsl;

        if ((calledCsl != null) && (calledCsl.length() == 0)) {
            clSocCacheModel.calledCsl = null;
        }

        clSocCacheModel.cslKnowledgable = getCslKnowledgable();

        String cslKnowledgable = clSocCacheModel.cslKnowledgable;

        if ((cslKnowledgable != null) && (cslKnowledgable.length() == 0)) {
            clSocCacheModel.cslKnowledgable = null;
        }

        clSocCacheModel.cslSupportive = getCslSupportive();

        String cslSupportive = clSocCacheModel.cslSupportive;

        if ((cslSupportive != null) && (cslSupportive.length() == 0)) {
            clSocCacheModel.cslSupportive = null;
        }

        clSocCacheModel.localResSuggested = getLocalResSuggested();

        String localResSuggested = clSocCacheModel.localResSuggested;

        if ((localResSuggested != null) && (localResSuggested.length() == 0)) {
            clSocCacheModel.localResSuggested = null;
        }

        clSocCacheModel.localResContacted = getLocalResContacted();

        String localResContacted = clSocCacheModel.localResContacted;

        if ((localResContacted != null) && (localResContacted.length() == 0)) {
            clSocCacheModel.localResContacted = null;
        }

        clSocCacheModel.rsnLocalResNotContacted = getRsnLocalResNotContacted();

        String rsnLocalResNotContacted = clSocCacheModel.rsnLocalResNotContacted;

        if ((rsnLocalResNotContacted != null) &&
                (rsnLocalResNotContacted.length() == 0)) {
            clSocCacheModel.rsnLocalResNotContacted = null;
        }

        clSocCacheModel.localResHelpful = getLocalResHelpful();

        String localResHelpful = clSocCacheModel.localResHelpful;

        if ((localResHelpful != null) && (localResHelpful.length() == 0)) {
            clSocCacheModel.localResHelpful = null;
        }

        clSocCacheModel.concernsAnswered = getConcernsAnswered();

        String concernsAnswered = clSocCacheModel.concernsAnswered;

        if ((concernsAnswered != null) && (concernsAnswered.length() == 0)) {
            clSocCacheModel.concernsAnswered = null;
        }

        clSocCacheModel.understandNextSteps = getUnderstandNextSteps();

        String understandNextSteps = clSocCacheModel.understandNextSteps;

        if ((understandNextSteps != null) &&
                (understandNextSteps.length() == 0)) {
            clSocCacheModel.understandNextSteps = null;
        }

        clSocCacheModel.callCslAgain = getCallCslAgain();

        String callCslAgain = clSocCacheModel.callCslAgain;

        if ((callCslAgain != null) && (callCslAgain.length() == 0)) {
            clSocCacheModel.callCslAgain = null;
        }

        clSocCacheModel.recommendCsl = getRecommendCsl();

        String recommendCsl = clSocCacheModel.recommendCsl;

        if ((recommendCsl != null) && (recommendCsl.length() == 0)) {
            clSocCacheModel.recommendCsl = null;
        }

        clSocCacheModel.suggestions = getSuggestions();

        String suggestions = clSocCacheModel.suggestions;

        if ((suggestions != null) && (suggestions.length() == 0)) {
            clSocCacheModel.suggestions = null;
        }

        clSocCacheModel.followupCall = getFollowupCall();

        String followupCall = clSocCacheModel.followupCall;

        if ((followupCall != null) && (followupCall.length() == 0)) {
            clSocCacheModel.followupCall = null;
        }

        clSocCacheModel.followupCallTime = getFollowupCallTime();

        String followupCallTime = clSocCacheModel.followupCallTime;

        if ((followupCallTime != null) && (followupCallTime.length() == 0)) {
            clSocCacheModel.followupCallTime = null;
        }

        clSocCacheModel.tresholdMet = getTresholdMet();

        String tresholdMet = clSocCacheModel.tresholdMet;

        if ((tresholdMet != null) && (tresholdMet.length() == 0)) {
            clSocCacheModel.tresholdMet = null;
        }

        return clSocCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(51);

        sb.append("{clSocId=");
        sb.append(getClSocId());
        sb.append(", callId=");
        sb.append(getCallId());
        sb.append(", persnId=");
        sb.append(getPersnId());
        sb.append(", surveyStatus=");
        sb.append(getSurveyStatus());
        sb.append(", surveyComment=");
        sb.append(getSurveyComment());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", attemptNum=");
        sb.append(getAttemptNum());
        sb.append(", callerAvailable=");
        sb.append(getCallerAvailable());
        sb.append(", requestedCallbackTime=");
        sb.append(getRequestedCallbackTime());
        sb.append(", willingToAnsQues=");
        sb.append(getWillingToAnsQues());
        sb.append(", calledCsl=");
        sb.append(getCalledCsl());
        sb.append(", cslKnowledgable=");
        sb.append(getCslKnowledgable());
        sb.append(", cslSupportive=");
        sb.append(getCslSupportive());
        sb.append(", localResSuggested=");
        sb.append(getLocalResSuggested());
        sb.append(", localResContacted=");
        sb.append(getLocalResContacted());
        sb.append(", rsnLocalResNotContacted=");
        sb.append(getRsnLocalResNotContacted());
        sb.append(", localResHelpful=");
        sb.append(getLocalResHelpful());
        sb.append(", concernsAnswered=");
        sb.append(getConcernsAnswered());
        sb.append(", understandNextSteps=");
        sb.append(getUnderstandNextSteps());
        sb.append(", callCslAgain=");
        sb.append(getCallCslAgain());
        sb.append(", recommendCsl=");
        sb.append(getRecommendCsl());
        sb.append(", suggestions=");
        sb.append(getSuggestions());
        sb.append(", followupCall=");
        sb.append(getFollowupCall());
        sb.append(", followupCallTime=");
        sb.append(getFollowupCallTime());
        sb.append(", tresholdMet=");
        sb.append(getTresholdMet());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(79);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.ClSoc");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>clSocId</column-name><column-value><![CDATA[");
        sb.append(getClSocId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callId</column-name><column-value><![CDATA[");
        sb.append(getCallId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>persnId</column-name><column-value><![CDATA[");
        sb.append(getPersnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>surveyStatus</column-name><column-value><![CDATA[");
        sb.append(getSurveyStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>surveyComment</column-name><column-value><![CDATA[");
        sb.append(getSurveyComment());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>attemptNum</column-name><column-value><![CDATA[");
        sb.append(getAttemptNum());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callerAvailable</column-name><column-value><![CDATA[");
        sb.append(getCallerAvailable());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>requestedCallbackTime</column-name><column-value><![CDATA[");
        sb.append(getRequestedCallbackTime());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>willingToAnsQues</column-name><column-value><![CDATA[");
        sb.append(getWillingToAnsQues());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>calledCsl</column-name><column-value><![CDATA[");
        sb.append(getCalledCsl());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cslKnowledgable</column-name><column-value><![CDATA[");
        sb.append(getCslKnowledgable());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cslSupportive</column-name><column-value><![CDATA[");
        sb.append(getCslSupportive());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>localResSuggested</column-name><column-value><![CDATA[");
        sb.append(getLocalResSuggested());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>localResContacted</column-name><column-value><![CDATA[");
        sb.append(getLocalResContacted());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>rsnLocalResNotContacted</column-name><column-value><![CDATA[");
        sb.append(getRsnLocalResNotContacted());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>localResHelpful</column-name><column-value><![CDATA[");
        sb.append(getLocalResHelpful());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>concernsAnswered</column-name><column-value><![CDATA[");
        sb.append(getConcernsAnswered());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>understandNextSteps</column-name><column-value><![CDATA[");
        sb.append(getUnderstandNextSteps());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callCslAgain</column-name><column-value><![CDATA[");
        sb.append(getCallCslAgain());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>recommendCsl</column-name><column-value><![CDATA[");
        sb.append(getRecommendCsl());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>suggestions</column-name><column-value><![CDATA[");
        sb.append(getSuggestions());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>followupCall</column-name><column-value><![CDATA[");
        sb.append(getFollowupCall());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>followupCallTime</column-name><column-value><![CDATA[");
        sb.append(getFollowupCallTime());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>tresholdMet</column-name><column-value><![CDATA[");
        sb.append(getTresholdMet());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
