package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.Cesp;
import gov.va.caret.model.CespModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the Cesp service. Represents a row in the &quot;CARET_CESP&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.CespModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CespImpl}.
 * </p>
 *
 * @author caret
 * @see CespImpl
 * @see gov.va.caret.model.Cesp
 * @see gov.va.caret.model.CespModel
 * @generated
 */
public class CespModelImpl extends BaseModelImpl<Cesp> implements CespModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a cesp model instance should use the {@link gov.va.caret.model.Cesp} interface instead.
     */
    public static final String TABLE_NAME = "CARET_CESP";
    public static final Object[][] TABLE_COLUMNS = {
            { "cespId", Types.BIGINT },
            { "callId", Types.BIGINT },
            { "createdByPersnId", Types.BIGINT },
            { "creationDate", Types.TIMESTAMP },
            { "step", Types.VARCHAR },
            { "status", Types.VARCHAR },
            { "referredBy", Types.VARCHAR },
            { "assignedCslPersnId", Types.VARCHAR },
            { "goals", Types.VARCHAR },
            { "planProgressBarrier", Types.VARCHAR },
            { "cespClosed", Types.VARCHAR },
            { "cespClosedReason", Types.VARCHAR },
            { "goalsReached", Types.VARCHAR }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_CESP (cespId LONG not null primary key,callId LONG,createdByPersnId LONG,creationDate DATE null,step VARCHAR(75) null,status VARCHAR(75) null,referredBy VARCHAR(75) null,assignedCslPersnId VARCHAR(75) null,goals VARCHAR(75) null,planProgressBarrier VARCHAR(75) null,cespClosed VARCHAR(75) null,cespClosedReason VARCHAR(75) null,goalsReached VARCHAR(75) null)";
    public static final String TABLE_SQL_DROP = "drop table CARET_CESP";
    public static final String ORDER_BY_JPQL = " ORDER BY cesp.cespId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_CESP.cespId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.Cesp"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.Cesp"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.Cesp"),
            true);
    public static long CALLID_COLUMN_BITMASK = 1L;
    public static long CESPID_COLUMN_BITMASK = 2L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.Cesp"));
    private static ClassLoader _classLoader = Cesp.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { Cesp.class };
    private long _cespId;
    private long _callId;
    private long _originalCallId;
    private boolean _setOriginalCallId;
    private long _createdByPersnId;
    private Date _creationDate;
    private String _step;
    private String _status;
    private String _referredBy;
    private String _assignedCslPersnId;
    private String _goals;
    private String _planProgressBarrier;
    private String _cespClosed;
    private String _cespClosedReason;
    private String _goalsReached;
    private long _columnBitmask;
    private Cesp _escapedModel;

    public CespModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _cespId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setCespId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _cespId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return Cesp.class;
    }

    @Override
    public String getModelClassName() {
        return Cesp.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("cespId", getCespId());
        attributes.put("callId", getCallId());
        attributes.put("createdByPersnId", getCreatedByPersnId());
        attributes.put("creationDate", getCreationDate());
        attributes.put("step", getStep());
        attributes.put("status", getStatus());
        attributes.put("referredBy", getReferredBy());
        attributes.put("assignedCslPersnId", getAssignedCslPersnId());
        attributes.put("goals", getGoals());
        attributes.put("planProgressBarrier", getPlanProgressBarrier());
        attributes.put("cespClosed", getCespClosed());
        attributes.put("cespClosedReason", getCespClosedReason());
        attributes.put("goalsReached", getGoalsReached());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long cespId = (Long) attributes.get("cespId");

        if (cespId != null) {
            setCespId(cespId);
        }

        Long callId = (Long) attributes.get("callId");

        if (callId != null) {
            setCallId(callId);
        }

        Long createdByPersnId = (Long) attributes.get("createdByPersnId");

        if (createdByPersnId != null) {
            setCreatedByPersnId(createdByPersnId);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        String step = (String) attributes.get("step");

        if (step != null) {
            setStep(step);
        }

        String status = (String) attributes.get("status");

        if (status != null) {
            setStatus(status);
        }

        String referredBy = (String) attributes.get("referredBy");

        if (referredBy != null) {
            setReferredBy(referredBy);
        }

        String assignedCslPersnId = (String) attributes.get(
                "assignedCslPersnId");

        if (assignedCslPersnId != null) {
            setAssignedCslPersnId(assignedCslPersnId);
        }

        String goals = (String) attributes.get("goals");

        if (goals != null) {
            setGoals(goals);
        }

        String planProgressBarrier = (String) attributes.get(
                "planProgressBarrier");

        if (planProgressBarrier != null) {
            setPlanProgressBarrier(planProgressBarrier);
        }

        String cespClosed = (String) attributes.get("cespClosed");

        if (cespClosed != null) {
            setCespClosed(cespClosed);
        }

        String cespClosedReason = (String) attributes.get("cespClosedReason");

        if (cespClosedReason != null) {
            setCespClosedReason(cespClosedReason);
        }

        String goalsReached = (String) attributes.get("goalsReached");

        if (goalsReached != null) {
            setGoalsReached(goalsReached);
        }
    }

    @Override
    public long getCespId() {
        return _cespId;
    }

    @Override
    public void setCespId(long cespId) {
        _cespId = cespId;
    }

    @Override
    public long getCallId() {
        return _callId;
    }

    @Override
    public void setCallId(long callId) {
        _columnBitmask |= CALLID_COLUMN_BITMASK;

        if (!_setOriginalCallId) {
            _setOriginalCallId = true;

            _originalCallId = _callId;
        }

        _callId = callId;
    }

    public long getOriginalCallId() {
        return _originalCallId;
    }

    @Override
    public long getCreatedByPersnId() {
        return _createdByPersnId;
    }

    @Override
    public void setCreatedByPersnId(long createdByPersnId) {
        _createdByPersnId = createdByPersnId;
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;
    }

    @Override
    public String getStep() {
        if (_step == null) {
            return StringPool.BLANK;
        } else {
            return _step;
        }
    }

    @Override
    public void setStep(String step) {
        _step = step;
    }

    @Override
    public String getStatus() {
        if (_status == null) {
            return StringPool.BLANK;
        } else {
            return _status;
        }
    }

    @Override
    public void setStatus(String status) {
        _status = status;
    }

    @Override
    public String getReferredBy() {
        if (_referredBy == null) {
            return StringPool.BLANK;
        } else {
            return _referredBy;
        }
    }

    @Override
    public void setReferredBy(String referredBy) {
        _referredBy = referredBy;
    }

    @Override
    public String getAssignedCslPersnId() {
        if (_assignedCslPersnId == null) {
            return StringPool.BLANK;
        } else {
            return _assignedCslPersnId;
        }
    }

    @Override
    public void setAssignedCslPersnId(String assignedCslPersnId) {
        _assignedCslPersnId = assignedCslPersnId;
    }

    @Override
    public String getGoals() {
        if (_goals == null) {
            return StringPool.BLANK;
        } else {
            return _goals;
        }
    }

    @Override
    public void setGoals(String goals) {
        _goals = goals;
    }

    @Override
    public String getPlanProgressBarrier() {
        if (_planProgressBarrier == null) {
            return StringPool.BLANK;
        } else {
            return _planProgressBarrier;
        }
    }

    @Override
    public void setPlanProgressBarrier(String planProgressBarrier) {
        _planProgressBarrier = planProgressBarrier;
    }

    @Override
    public String getCespClosed() {
        if (_cespClosed == null) {
            return StringPool.BLANK;
        } else {
            return _cespClosed;
        }
    }

    @Override
    public void setCespClosed(String cespClosed) {
        _cespClosed = cespClosed;
    }

    @Override
    public String getCespClosedReason() {
        if (_cespClosedReason == null) {
            return StringPool.BLANK;
        } else {
            return _cespClosedReason;
        }
    }

    @Override
    public void setCespClosedReason(String cespClosedReason) {
        _cespClosedReason = cespClosedReason;
    }

    @Override
    public String getGoalsReached() {
        if (_goalsReached == null) {
            return StringPool.BLANK;
        } else {
            return _goalsReached;
        }
    }

    @Override
    public void setGoalsReached(String goalsReached) {
        _goalsReached = goalsReached;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            Cesp.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public Cesp toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (Cesp) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        CespImpl cespImpl = new CespImpl();

        cespImpl.setCespId(getCespId());
        cespImpl.setCallId(getCallId());
        cespImpl.setCreatedByPersnId(getCreatedByPersnId());
        cespImpl.setCreationDate(getCreationDate());
        cespImpl.setStep(getStep());
        cespImpl.setStatus(getStatus());
        cespImpl.setReferredBy(getReferredBy());
        cespImpl.setAssignedCslPersnId(getAssignedCslPersnId());
        cespImpl.setGoals(getGoals());
        cespImpl.setPlanProgressBarrier(getPlanProgressBarrier());
        cespImpl.setCespClosed(getCespClosed());
        cespImpl.setCespClosedReason(getCespClosedReason());
        cespImpl.setGoalsReached(getGoalsReached());

        cespImpl.resetOriginalValues();

        return cespImpl;
    }

    @Override
    public int compareTo(Cesp cesp) {
        long primaryKey = cesp.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof Cesp)) {
            return false;
        }

        Cesp cesp = (Cesp) obj;

        long primaryKey = cesp.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        CespModelImpl cespModelImpl = this;

        cespModelImpl._originalCallId = cespModelImpl._callId;

        cespModelImpl._setOriginalCallId = false;

        cespModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<Cesp> toCacheModel() {
        CespCacheModel cespCacheModel = new CespCacheModel();

        cespCacheModel.cespId = getCespId();

        cespCacheModel.callId = getCallId();

        cespCacheModel.createdByPersnId = getCreatedByPersnId();

        Date creationDate = getCreationDate();

        if (creationDate != null) {
            cespCacheModel.creationDate = creationDate.getTime();
        } else {
            cespCacheModel.creationDate = Long.MIN_VALUE;
        }

        cespCacheModel.step = getStep();

        String step = cespCacheModel.step;

        if ((step != null) && (step.length() == 0)) {
            cespCacheModel.step = null;
        }

        cespCacheModel.status = getStatus();

        String status = cespCacheModel.status;

        if ((status != null) && (status.length() == 0)) {
            cespCacheModel.status = null;
        }

        cespCacheModel.referredBy = getReferredBy();

        String referredBy = cespCacheModel.referredBy;

        if ((referredBy != null) && (referredBy.length() == 0)) {
            cespCacheModel.referredBy = null;
        }

        cespCacheModel.assignedCslPersnId = getAssignedCslPersnId();

        String assignedCslPersnId = cespCacheModel.assignedCslPersnId;

        if ((assignedCslPersnId != null) && (assignedCslPersnId.length() == 0)) {
            cespCacheModel.assignedCslPersnId = null;
        }

        cespCacheModel.goals = getGoals();

        String goals = cespCacheModel.goals;

        if ((goals != null) && (goals.length() == 0)) {
            cespCacheModel.goals = null;
        }

        cespCacheModel.planProgressBarrier = getPlanProgressBarrier();

        String planProgressBarrier = cespCacheModel.planProgressBarrier;

        if ((planProgressBarrier != null) &&
                (planProgressBarrier.length() == 0)) {
            cespCacheModel.planProgressBarrier = null;
        }

        cespCacheModel.cespClosed = getCespClosed();

        String cespClosed = cespCacheModel.cespClosed;

        if ((cespClosed != null) && (cespClosed.length() == 0)) {
            cespCacheModel.cespClosed = null;
        }

        cespCacheModel.cespClosedReason = getCespClosedReason();

        String cespClosedReason = cespCacheModel.cespClosedReason;

        if ((cespClosedReason != null) && (cespClosedReason.length() == 0)) {
            cespCacheModel.cespClosedReason = null;
        }

        cespCacheModel.goalsReached = getGoalsReached();

        String goalsReached = cespCacheModel.goalsReached;

        if ((goalsReached != null) && (goalsReached.length() == 0)) {
            cespCacheModel.goalsReached = null;
        }

        return cespCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(27);

        sb.append("{cespId=");
        sb.append(getCespId());
        sb.append(", callId=");
        sb.append(getCallId());
        sb.append(", createdByPersnId=");
        sb.append(getCreatedByPersnId());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", step=");
        sb.append(getStep());
        sb.append(", status=");
        sb.append(getStatus());
        sb.append(", referredBy=");
        sb.append(getReferredBy());
        sb.append(", assignedCslPersnId=");
        sb.append(getAssignedCslPersnId());
        sb.append(", goals=");
        sb.append(getGoals());
        sb.append(", planProgressBarrier=");
        sb.append(getPlanProgressBarrier());
        sb.append(", cespClosed=");
        sb.append(getCespClosed());
        sb.append(", cespClosedReason=");
        sb.append(getCespClosedReason());
        sb.append(", goalsReached=");
        sb.append(getGoalsReached());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(43);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Cesp");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>cespId</column-name><column-value><![CDATA[");
        sb.append(getCespId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callId</column-name><column-value><![CDATA[");
        sb.append(getCallId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>createdByPersnId</column-name><column-value><![CDATA[");
        sb.append(getCreatedByPersnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>step</column-name><column-value><![CDATA[");
        sb.append(getStep());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>status</column-name><column-value><![CDATA[");
        sb.append(getStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>referredBy</column-name><column-value><![CDATA[");
        sb.append(getReferredBy());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>assignedCslPersnId</column-name><column-value><![CDATA[");
        sb.append(getAssignedCslPersnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>goals</column-name><column-value><![CDATA[");
        sb.append(getGoals());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>planProgressBarrier</column-name><column-value><![CDATA[");
        sb.append(getPlanProgressBarrier());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cespClosed</column-name><column-value><![CDATA[");
        sb.append(getCespClosed());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cespClosedReason</column-name><column-value><![CDATA[");
        sb.append(getCespClosedReason());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>goalsReached</column-name><column-value><![CDATA[");
        sb.append(getGoalsReached());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
