package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.BoxGp;
import gov.va.caret.service.BoxGpLocalServiceUtil;

/**
 * The extended model base implementation for the BoxGp service. Represents a row in the &quot;CARET_BOXED_GROUP&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BoxGpImpl}.
 * </p>
 *
 * @author caret
 * @see BoxGpImpl
 * @see gov.va.caret.model.BoxGp
 * @generated
 */
public abstract class BoxGpBaseImpl extends BoxGpModelImpl implements BoxGp {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a box gp model instance should use the {@link BoxGp} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            BoxGpLocalServiceUtil.addBoxGp(this);
        } else {
            BoxGpLocalServiceUtil.updateBoxGp(this);
        }
    }
}
