package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.BlsRe;
import gov.va.caret.service.BlsReLocalServiceUtil;

/**
 * The extended model base implementation for the BlsRe service. Represents a row in the &quot;CARET_BLS&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BlsReImpl}.
 * </p>
 *
 * @author caret
 * @see BlsReImpl
 * @see gov.va.caret.model.BlsRe
 * @generated
 */
public abstract class BlsReBaseImpl extends BlsReModelImpl implements BlsRe {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a bls re model instance should use the {@link BlsRe} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            BlsReLocalServiceUtil.addBlsRe(this);
        } else {
            BlsReLocalServiceUtil.updateBlsRe(this);
        }
    }
}
