package gov.va.caret.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.CacheModel;

import gov.va.caret.model.BgAsn;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/**
 * The cache model class for representing BgAsn in entity cache.
 *
 * @author caret
 * @see BgAsn
 * @generated
 */
public class BgAsnCacheModel implements CacheModel<BgAsn>, Externalizable {
    public long bgAsnId;
    public long ownerId;
    public long boxGpId;
    public boolean selected;

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);

        sb.append("{bgAsnId=");
        sb.append(bgAsnId);
        sb.append(", ownerId=");
        sb.append(ownerId);
        sb.append(", boxGpId=");
        sb.append(boxGpId);
        sb.append(", selected=");
        sb.append(selected);
        sb.append("}");

        return sb.toString();
    }

    @Override
    public BgAsn toEntityModel() {
        BgAsnImpl bgAsnImpl = new BgAsnImpl();

        bgAsnImpl.setBgAsnId(bgAsnId);
        bgAsnImpl.setOwnerId(ownerId);
        bgAsnImpl.setBoxGpId(boxGpId);
        bgAsnImpl.setSelected(selected);

        bgAsnImpl.resetOriginalValues();

        return bgAsnImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        bgAsnId = objectInput.readLong();
        ownerId = objectInput.readLong();
        boxGpId = objectInput.readLong();
        selected = objectInput.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput)
        throws IOException {
        objectOutput.writeLong(bgAsnId);
        objectOutput.writeLong(ownerId);
        objectOutput.writeLong(boxGpId);
        objectOutput.writeBoolean(selected);
    }
}
