package gov.va.caret.letters;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;
import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.Primary;
import gov.va.caret.model.support.Secondary;
import gov.va.caret.model.support.VcgApplication;
import gov.va.caret.model.support.Veteran;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xml.sax.InputSource;

public class PopulateLettersImpl implements PopulateLetters{
	
	public static final String FORM = "/letters/VeteranRevocation.pdf";
	private static Log _log = LogFactoryUtil.getLog(PopulateLettersImpl.class);
	
	public DocumentBuilderFactory createDocBuilderFactory() {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

        factory.setNamespaceAware(false);
       factory.setValidating(false);
       try {
    	   factory.setFeature("http://xml.org/sax/features/namespaces", false);
	       factory.setFeature("http://xml.org/sax/features/validation", false);
	       factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
	       factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);     
		} catch (ParserConfigurationException e) {
			_log.error(e);
		}  
       return factory;

	}
	public void generateAndPopulatePDFWithEditedContent(PortletRequest request, String letterName, Boolean isPreview) {
		
		String tempLocation = PortletProps.get(CaretStrPool.FILE_TEMP_STORE);
        String name = letterName + ".pdf";

    	try {
    		DocumentBuilderFactory factory = createDocBuilderFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
           
			String letterContent = ""; /*"<?xml version='1.0' encoding='UTF-8'?> "
					+ "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">   <wrapper>" + 
									"<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\">"+
									"<head>"+
									"<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></meta>"+
									"</head>"+
									"<body>";*/
			if (isPreview) {
				letterContent += request.getParameter(CaretStrPool.PREVIEW_LETTER_CONTENT);
			} else {
				letterContent += request.getParameter(CaretStrPool.EDITED_LETTER_CONTENT);
			}
			letterContent += "</body>"+
								"</html></wrapper>";
			ITextRenderer renderer = new ITextRenderer();
			
			// Create instance
			final Tidy tidy = new Tidy();
			tidy.setMakeClean( true );
			tidy.setXHTML( true );
			tidy.setSmartIndent( true );
			final ByteArrayOutputStream outStr2 = new ByteArrayOutputStream();
			final Document document = tidy.parseDOM( new ByteArrayInputStream( letterContent.getBytes() ) , null );
			tidy.pprint( document , outStr2 );
			final StringBuilder stringBuilder = new StringBuilder();
			stringBuilder.append( new String( outStr2.toByteArray() , "UTF-8" ) );
			final String validXHTML = stringBuilder.toString();
			
			InputSource inputSource = new InputSource(new StringReader(validXHTML));
			final Document doc = builder.parse(inputSource);

			renderer.setDocument(doc, tempLocation);
			renderer.layout();
			
			String fileNameWithPath = tempLocation + name;
			FileOutputStream fos = new FileOutputStream( fileNameWithPath );
			renderer.createPDF(fos, true);
		}
    	
        catch (IOException e2) {
			_log.error(e2);
		} catch (Exception e) {
			_log.error(e);
		}
		
		request.setAttribute(CaretStrPool.LETTER_FILE, name ); // tempLocation + name);
		
  }
	/* Removing from veteran dashboard. Keeping code if we decide to add back.
	public static void generateVeteranCGPDF(PortletRequest request)  {
		
		List<Long> persnRevisionIds = new ArrayList<Long>();
		OnlineDashboardConfig dashboard = CAction.loadOnlineRoleId( request );
		Map<String, Object> form = ResultMap.getForm(request);
		try {
			long persnId = CaretParam.getPersnId(request);
			long userId = PortalUtil.getUserId( request );
			persnRevisionIds.add( persnId );//TODO:...
			for ( Persn persn: PersnLocalServiceUtil.getByOwner( userId ) ){ //userId, the user who created this Persn record, revisions create new Persn records
				persnRevisionIds.add( persn.getPersnId() );
			}
			
			Map persnIdMap = Collections.singletonMap(CaretStrPool.PERSN_ID, persnRevisionIds );
			List<Map<String, Object>> myApplications = new ArrayList<Map<String, Object>> ();
			myApplications = (List<Map<String, Object>>) CaretLocalServiceUtil.getReport( dashboard.getDashboardReport(), persnIdMap );
			List<Docum> allLetters = new ArrayList<Docum>();
			List<DocumentSupport> allSupportLetters = new ArrayList<DocumentSupport>();
			for ( Map<String, Object> appFields : myApplications ){
				BigDecimal vcgAnId = (BigDecimal) appFields.get( CaretStrPool.NDX0 );
				VcgAn vcgAn = VcgAnLocalServiceUtil.getVcgAn(vcgAnId.longValue());
				VcgSupport vcgSupport = VcgSupport.getVcgSupport(vcgAn.getVcgId());
				allLetters.addAll( DocumLocalServiceUtil.getByClass(vcgAnId.longValue(), PortalUtil.getClassNameId(VcgAn.class), FileType.CSC_Letter.name()));
			}
			form.put("allLetters", allLetters);
			form.put("allSuportLetters", allSupportLetters);
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		} catch (PortalException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		} 
			
}*/
	
	public Map<String, String>  getLetterRecipients (PortletRequest request) {
		Map<String, String> recipients = new HashMap<String, String>();
		
		 LetterFieldValues letterFieldValues = populateLetterFields(request);
	  	  recipients.put(CaretStrPool.PERSON_CATEGORY_VETERAN, letterFieldValues.getVeteran().getFirstName() + " " + letterFieldValues.getVeteran().getLastName());
	  	  recipients.put(CaretStrPool.PERSON_CATEGORY_PRIMARY, letterFieldValues.getPrimary().getFirstName() + " " + letterFieldValues.getPrimary().getLastName());
	  	  if (letterFieldValues.getSecondary().getUserId() > 0) { 
		  	  recipients.put(CaretStrPool.PERSON_CATEGORY_SECONDARY, letterFieldValues.getSecondary().getFirstName() + " " + letterFieldValues.getSecondary().getLastName());
	  	  }
	  	  if (letterFieldValues.getSecondaryTwo() != null) { 
		  	  recipients.put(CaretStrPool.PERSON_CATEGORY_SECONDARYTWO, letterFieldValues.getSecondaryTwo().getFirstName() + " " + letterFieldValues.getSecondaryTwo().getLastName());
	  	  }
		return recipients;

	}

	public LetterFieldValues populateLetterFields (PortletRequest request) {
		LetterFieldValues letterFields = null;
		long vcgId = ParamUtil.getLong(request, "vcgId", 0);
		try {
			VcgAn vcgAn =  VcgAnLocalServiceUtil.getRecent(vcgId);
			Long vcgAnId = vcgAn.getVcgAnId();
			VcgApplication vcgApplication;
			Person veteran = null;
			Person primary = null;
			Person secondary = null;
			Person secondaryTwo = null;
			Person currentUser = null;
			if ( vcgAnId > 0 ) {  
				try {
					currentUser = new Person( PersnLocalServiceUtil.getByUser(PortalUtil.getUserId( request )) );
					vcgApplication = new VcgApplication( VcgAnLocalServiceUtil.getVcgAn(vcgAnId) ); 
					veteran = new Veteran ( PersnLocalServiceUtil.getPersn( vcgApplication.getVeteranId() ) );
					if ( vcgApplication.getPrimaryId() > 0 ){
							
						primary = new Primary ( PersnLocalServiceUtil.getPersn( vcgApplication.getPrimaryId() ) );
					}
					if ( vcgApplication.getSecondaryId() > 0 ){
						secondary = new Secondary ( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryId() ) );
					}
					if ( vcgApplication.getSecondaryTwoId() > 0 ){
						secondaryTwo = new Secondary ( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryTwoId() ) );
					}
					
				} catch (PortalException e) {
					throw new ApplicationWorkFlowException(e);
				} catch (SystemException e) {
					throw new ApplicationWorkFlowException(e);
				}
			}
			
			letterFields = new LetterFieldValues(currentUser, veteran, primary, secondary, secondaryTwo);
			
		} catch (ApplicationWorkFlowException e) {
			_log.error(e);
		} 
		
		return letterFields;
	}
	
  	public Document populateFieldValues(ResourceRequest request, Document doc)
  	{
  	  LetterFieldValues letterFieldValues = populateLetterFields(request);
	  Person  veteran = letterFieldValues.getVeteran();
  	  Person primary = letterFieldValues.getPrimary();
  	  Person secondary = letterFieldValues.getSecondary();
  	  Person currentUser = letterFieldValues.getCurrentUser();

	  List<LetterFields> letterFields = Arrays.asList(LetterFields.values());
		for ( Iterator<LetterFields> iter = letterFields.iterator(); iter.hasNext();) {
			String letterFieldName = iter.next().toString();
			if (elementExists(doc, letterFieldName)) {
				NodeList allElements = doc.getElementsByTagName(letterFieldName);
				for (int i = 0; i < allElements.getLength(); i++) {
					switch (letterFieldName) {
				  	  case "Date":
				  			allElements.item(i).setTextContent(new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a").format(new Date()));
				  		break;
				  	  case "VeteranName":
				  		allElements.item(i).setTextContent(veteran.getFirstName() + " " + veteran.getLastName());
				  		break;
				  	  case "CGName":
					  		allElements.item(i).setTextContent(primary.getFirstName() + " " + primary.getLastName());
					  		break;
				  	  case "CGName1":
					  		allElements.item(i).setTextContent(secondary.getFirstName() + " " + secondary.getLastName());
					  		break;
				  	  case "CSCName":
					  		allElements.item(i).setTextContent(currentUser.getFirstName() + " " + currentUser.getLastName());
					  		break;
				  	  case "CSCNumber":
					  		allElements.item(i).setTextContent(currentUser.getPhone());
					  		break;
				  	  case "CSCAdress":
					  		allElements.item(i).setTextContent(currentUser.getAddress() + " , "
					  				+currentUser.getAddress2() + " , "
					  				+currentUser.getCity() + " , "
					  				+currentUser.getState() + " , "
					  				+currentUser.getZip());
					  		break;
				  	  case "VeteranGender":
				  		  	if (veteran.getGender().equalsIgnoreCase("male")) {
				  		  	allElements.item(i).setTextContent("his");
				  		  	} else {
				  		  	allElements.item(i).setTextContent("her");
				  		  	}
					  		break;
				  	  case "CGGender":
				  		  	if (primary.getGender().equalsIgnoreCase("male")) {
				  		  	allElements.item(i).setTextContent("his");
				  		  	} else {
				  		  	allElements.item(i).setTextContent("her");
				  		  	}
					  		break;
				  	  case "VeteranGender1":
				  		  	if (veteran.getGender().equalsIgnoreCase("male")) {
				  		  	allElements.item(i).setTextContent("he");
				  		  	} else {
				  		  	allElements.item(i).setTextContent("she");
				  		  	}
					  		break;
				  	  case "CGGender1":
				  		  	if (primary.getGender().equalsIgnoreCase("male")) {
				  		  	allElements.item(i).setTextContent("he");
				  		  	} else {
				  		  	allElements.item(i).setTextContent("she");
				  		  	}
					  		break;
				  	  default:
					  		break;
				  	 }
					
				}
			}
		}
		return doc;
  	}
	
	public boolean elementExists(Document doc, String tagName) {
		
		NodeList nodeList = doc.getElementsByTagName(tagName);
		if (nodeList != null && nodeList.getLength() > 0) {
			return true;
		}
		return false;
	}
    
}
