package gov.va.caret.letters;

import gov.va.caret.model.support.Person;

import org.apache.pdfbox.pdmodel.PDDocument;

public class LetterFieldValues {

	private Person currentUser;
	private Person veteran;
	private Person primary;
	private Person secondary;
	private Person secondaryTwo;

	final static Person nullPerson = Person.DEFAULT_PERSON;

	public boolean isPrimaryPreview() {
		return false;
	}
	
	public boolean isSecondaryPreview() {
		return false;
	}
	
	private Person nullSafe ( Person persn ){
		return persn == null? nullPerson : persn;
	}

	public LetterFieldValues(Person currentUser, Person veteran, Person primary, Person secondary, Person secondaryTwo) {

		super();
		this.currentUser = currentUser;
		this.veteran = veteran;
		this.primary = primary;
		this.secondary = secondary;
		this.secondaryTwo = secondaryTwo;
	}

	public Person getCurrentUser() {
		return currentUser;
	}

	public void setCurrentUser(Person currentUser) {
		this.currentUser = currentUser;
	}
	
	public Person getVeteran() {
		return nullSafe(veteran);
	}

	public Person getPrimary() {
		return nullSafe(primary);
	}

	public Person getSecondary() {
		return nullSafe(secondary);
	}
	
	public Person getSecondaryTwo() {
		return secondaryTwo;
	}

	public void setSecondaryTwo(Person secondaryTwo) {
		this.secondaryTwo = secondaryTwo;
	}

}
