package gov.va.caret.hook;

import java.util.List;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

public class LandingGroupSequence {

	private static final Log _log = LogFactoryUtil.getLog( LandingGroupSequence.class );
	private static final String LANDING_SEQUENCE = "site.priority.order";
			
	public static Group getUserSite(User user) throws PortalException, SystemException {

		String[] landingSequence = PortalUtil.getPortalProperties().get( LANDING_SEQUENCE ).toString().split( StringPool.COMMA );
		List<Group> userSites = user.getSiteGroups();
		for ( String siteProp : landingSequence ){
			String siteName = PropsUtil.get( siteProp );
			if ( siteName == null || siteName.isEmpty() ) continue;
			for( Group group : userSites ){
				if( siteName.equalsIgnoreCase( group.getName() ) ){
					return group;
				}
			}
		}
		_log.error("Landing page could not identify user-group");
		return null;
	}
}
