package gov.va.caret.controller.dashboard.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.portlet.PortletRequest;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.soc.SocCachedReportUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.view.AdhocReport;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.EnabledSearch;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ReportParameter;
import gov.va.caret.view.ResultMap;

public class CslDashboardConfig extends DashboardConfig {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7440796283781503750L;
	public final String VIEW = "/jsp/dashboard/csl.jsp";
	static {SocCachedReportUtil.updateSearchUtilGenericUser();}
	
	Collection<WorkType> enabledWork = new ArrayList<WorkType>(Arrays.asList(new WorkType[]{
	WorkType.CALL_REFERRAL, WorkType.CSL_REFERRAL, WorkType.REFERRAL }));
	
	public CslDashboardConfig() {
		super();
		
		this.enabledSearch = new EnabledSearch( 
				new CachedReport(CaretStrPool.CALLS), 
				new CachedReport(CaretStrPool.REFFERALS), 
				new CachedReport("vcgs"),
				new CachedReport("searchCompletedSocs"),
				new CachedReport("searchSocs") );
		this.reports = new GenericReport[]{ 
					new GenericReport("myCalls", true, "c.creationDate", true, GenericReport.CALL_QUERY_NDX, ReportParameter.userId ),
//					new GenericReport("myNotes", true, "creationDate", true, GenericReport.NOTES_QUERY_NDX, ReportParameter.userId ),
					new AdhocReport("vcgNotes", ReportParameter.classPk ),
//					new GenericReport("myReferrals", true, "c.creationDate", true, GenericReport.CALL_QUERY_NDX, ReportParameter.userId ) ,
					new GenericReport("groupCalls", true, "c.creationDate", true, GenericReport.CALL_QUERY_NDX, ReportParameter.roleId ) ,
					new GenericReport("groupCallBacks", true, "c.creationDate", true, GenericReport.CALL_QUERY_NDX, ReportParameter.roleId ) ,
					new GenericReport("groupReferrals", true, "c.creationDate", true, GenericReport.CALL_QUERY_NDX, ReportParameter.roleId ) ,
					new GenericReport("groupSocs", true, "c.creationDate", true, GenericReport.CALL_QUERY_NDX, ReportParameter.roleId, ReportParameter.socDueDate ),
					new CachedReport("persnAudit"),
					new CachedReport("persn"),
					new CachedReport("workAudit"),
					new CachedReport("vcgAudit"),
					new CachedReport("vcgOpenWork"),
					new CachedReport("vcgOpenRefs"),
					new CachedReport("vcgClosedWork"),
					new CachedReport("vcgClosedRefs"),
					new CachedReport("assmtAudit"),
					new CachedReport("assmtAuditAll"),
					new CachedReport("assmtAuditPeriodicAll"),
					new CachedReport("periodicAssessmentsAll"),
					new CachedReport("vcgSupportingDocsAll"),
					new CachedReport("vcgDocsHistoryAll")
					};
	}

	public final CAction.CaretCan[] getCreateActions(){
		return new CAction.CaretCan[]{
			CAction.CaretCan.CREATE_CALLS,
			CAction.CaretCan.CREATE_VCG,
			CAction.CaretCan.CREATE_CALL_TYPE,
			CAction.CaretCan.CREATE_REFERRAL
		};
	}
	
	@Override
	public CaretCan[] getToolsActions() {
		return new CAction.CaretCan[]{};
	}
	
	@Override
	public String getView() {
		return VIEW;
	}
	
	public void loadReports( PortletRequest request ) throws ApplicationWorkFlowException{
		super.loadReports( request );
		ResultMap.getCaretMap(request).put(CaretStrPool.USE_PHONE, true);
		ResultMap.getCaretMap(request).put( CaretStrPool.VHA_SYSTEM, CaretUtil.getVhaOrgTree( PortalUtil.getCompanyId( request ), true ) );
		ResultMap.getCaretMap(request).put( "cgRoles", new String[]{"caller", "UNKNOWN_CALLER"} );
//		List<Map<String,Object>> list = 
		request.setAttribute("roleUsers", CaretLocalServiceUtil.getReport( "cslUserList", Collections.singletonMap("roleGroup", PortletProps.get(CaretStrPool.CSL_PROP) )) );
		String callType = PortletProps.get("call.type");
		if ( !callType.isEmpty() ){
			String[] array = (callType + StringPool.COMMA + "soc-call").split(StringPool.COMMA) ;
			List<String> c = ListUtil.fromArray(array);
			Collections.sort(c);
			ResultMap.getCaretMap(request).put( "standard-call-types", c );
		}
		ResultMap.getCaretMap(request).put( CaretStrPool.CUSTOM_CALL_TYPES, BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.CUSTOM_CALL_TYPES) );
	}
	
	public Collection<WorkType> getEnabledWork() {
		return enabledWork;
	}

}
/*
                Dashboard CSL
                                Main view
                                                create new call record
                                                search for existing call record
                                                view/edit/update call record
                                                create referral work item
                                                view CSL referrals
                                                create/read/reply internal messaging



 * 
 * 
 */
