package gov.va.caret.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.ResourceConstants;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.RoleConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.dashboard.config.DashboardConfig;
import gov.va.caret.controller.dashboard.config.DashboardConfigFactory;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.Primary;
import gov.va.caret.model.support.VcgSupport;
import gov.va.caret.model.support.Veteran;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.security.CAction;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.util.CaretMap;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.ResultMap;
import gov.va.caret.workflow.OwnerQueue;
import gov.va.caret.workflow.WorkName;

/*
 * Central controller for CareT Online... shared between ResourceCommand and ActionCommand
 * 
 */

public class CaretViewController extends CaretBaseViewController implements Serializable {
	
	private static final long serialVersionUID = 1L;
	private static CaretViewController viewController = new CaretViewController();
	public static Log _log = LogFactoryUtil.getLog(  CaretViewController.class );
	
	public static CaretViewController getViewController(){
		if ( viewController == null ){
			viewController = new CaretViewController();
		}
		return viewController;
	}
	
	@Override
	public String loadDefaultView( PortletRequest request, MimeResponse response ) {
		
		request.setAttribute( "isDemoEnabled", PortletProps.get(CaretStrPool.DEMO_FEATURES_ENABLED) );
		
		DashboardConfig dashboardConfig = DashboardConfigFactory.loadInstance( request, response );
		if ( dashboardConfig != null ){
			return dashboardConfig.getView();
		} else if ( StringPool.TRUE.equals( PortletProps.get(CaretStrPool.ROLES_SELECTION_ENABLED ) ) ) {
			initRoleChooser( request );
		}
		return StringPool.BLANK;
	}

	private void initRoleChooser(PortletRequest request) {
		try {
			User user = PortalUtil.getUser(request);
//			Group clinic = GroupLocalServiceUtil.getGroup( CompanyThreadLocal.getCompanyId(), Toolbox.getClinicSite() );
			String roleName = "RoleChooser";
			Role roleChooser = RoleLocalServiceUtil.fetchRole( CompanyThreadLocal.getCompanyId(), roleName );
					if ( roleChooser == null ){
						long classPK = CounterLocalServiceUtil.increment( Role.class.getName() );
						
						roleChooser = RoleLocalServiceUtil.addRole(UserLocalServiceUtil.getDefaultUserId( CompanyThreadLocal.getCompanyId() ), 
								Role.class.getName(), classPK, roleName, 
								Collections.singletonMap(LocaleUtil.getDefault(), roleName), 
								Collections.singletonMap(LocaleUtil.getDefault(), "Autogenerated role for CareT"),
								RoleConstants.TYPE_REGULAR, null, new ServiceContext());
						ResourcePermissionLocalServiceUtil.setResourcePermissions(  CompanyThreadLocal.getCompanyId(),
								CAction.CARET_PORTLET,
								ResourceConstants.SCOPE_COMPANY,
								String.valueOf( CompanyThreadLocal.getCompanyId() ),
								roleChooser.getRoleId(),
								new String[] { "VIEW" } );
					}
					UserLocalServiceUtil.setRoleUsers(roleChooser.getRoleId(), new long[]{user.getUserId()});
					
					request.setAttribute("roleChooser", RoleLocalServiceUtil.getSubtypeRoles( PropsUtil.get( "roles.regular.subtypes" ) ) );
					request.setAttribute("faciltyChooser", CaretUtil.getVhaOrgTree( PortalUtil.getCompanyId( request ), true ) );
					request.setAttribute("visnChooser", CaretUtil.getVisnMap() );
		} catch (PortalException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		}
	}

	public void loadRequiredInputs( String context, Map<String, Object> form ) {

		Map<String, String> required = new CaretMap<String, String>(StringPool.BLANK);
		form.put("required", required);
		
		if ( CaretStrPool.CALL ==  context ){
			for ( String key : PortletProps.get("required.call.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
			};
		} else if ( CaretStrPool.REFFERAL ==  context ){
			for ( String key : PortletProps.get("required.referral.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
			};
		} else if ( CaretStrPool.VETERAN_PERSN == context ){
			for ( String key : PortletProps.get("csc.required.veteran.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
				form.put("veteranRequired", required);
			}
		} else if ( CaretStrPool.PRIMARY_PERSN == context ){
			for ( String key : PortletProps.get("csc.required.primary.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
				form.put("primaryRequired", required);
			}		
		} else if ( CaretStrPool.SECONDARY_PERSN == context ){
			for ( String key : PortletProps.get("csc.required.secondary.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
				form.put("secondaryRequired", required);
			}	
		} else if ( CaretStrPool.SECONDARY_TWO_PERSN == context ){
			for ( String key : PortletProps.get("csc.required.secondaryTwo.input").split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
				form.put("secondaryTwoRequired", required);
			}
		} else if ( CaretStrPool.NEW_VCG_VETERAN_FORM == context ){
			for ( String key : PortletProps.get(CaretStrPool.NEW_VCG_VETERAN_FORM).split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
			}
		} else {
			for ( String key : PortletProps.get(context).split(StringPool.COMMA) ){
				required.put(key, CaretStrPool.REQUIRED_INPUT );
			};
		}
				
//		HashMap map = (HashMap) form.get("required");
		
	}
	
	public boolean validateRequired( String context, PortletRequest request ){
		Map<String, Object> form = getForm(request);
		loadRequiredInputs( context, form );
		for ( String key : form.keySet() ){
			
		}
		return true;
	}
	
//	public List<String> setVcgPerson ( PortletRequest request, Person formPerson, Person vcgPerson ){
//		return setVcgPerson(request, formPerson, vcgPerson, new boolean[Person.Changes.values().length]);
//	}
		
	public List<String> setVcgPerson ( PortletRequest request, Person formPerson, Person vcgPerson, boolean[] changes ){
		
		List<String> errors = new ArrayList<String>();
		
		boolean isActivated = true;
//		boolean isActivated = CaretStrPool.ACTIVE_VCG.equals( vcgPerson.getStatus() );
		
		if ( !Toolbox.isEmpty(formPerson.getLastName()) && !formPerson.getLastName().equals( vcgPerson.getLastName() ) ){
			 boolean allowed = true;
			 if ( isActivated ){
				 if ( vcgPerson.isVeteranRole() && !CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_VETERAN_LNAME.name() ) ){
					 errors.add("Updates to Veteran Last Name: Permission failure");
					 allowed = false;
				 }
				 if ( allowed && vcgPerson.isPrimaryRole() && !CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_PRIMARY_LNAME.name() ) ){
					 errors.add("Updates to Primary Last Name: Permission failure");
					 allowed = false;
				 }
				 if ( allowed && ( vcgPerson.isSecondaryRole() || vcgPerson.isSecondaryTwoRole() ) && !CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_CG_LNAME.name() ) ){
					 errors.add("Updates to Caregiver Last Name: Permission failure");
					 allowed = false;
				 }
			 }
			 if ( allowed ){
				 vcgPerson.setLastName( formPerson.getLastName() );
				 changes[Person.Changes.NAME_CHANGE.ordinal()] = true;
			 }
		}
		if ( !Toolbox.isEmpty( formPerson.getFirstName() ) && !formPerson.getFirstName().equals( vcgPerson.getFirstName() ) ){
			boolean allowed = true;
			if ( isActivated ){
				if ( vcgPerson.isVeteranRole() && !CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_VETERAN_FNAME.name() ) ){
					errors.add("Updates to Veteran First Name: Permission failure");
					allowed = false;
				}
				if ( allowed && vcgPerson.isPrimaryRole() && !CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_PRIMARY_FNAME.name() ) ){
					errors.add("Updates to Primary First Name: Permission failure");
					allowed = false;
				}
				if ( allowed && ( vcgPerson.isSecondaryRole() || vcgPerson.isSecondaryTwoRole() ) && !CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_CG_FNAME.name() ) ){
					errors.add("Updates to Caregiver First Name: Permission failure");
					allowed = false;
				}
			}
			if ( allowed ){
				vcgPerson.setFirstName( formPerson.getFirstName() );
				changes[Person.Changes.NAME_CHANGE.ordinal()] = true;
			}
		}
		if ( !Toolbox.isEmpty( formPerson.getMiddleName() ) &&  !formPerson.getMiddleName().equals( vcgPerson.getMiddleName() ) ) {
			boolean allowed = true;
			if ( isActivated && !CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_MNAME.name() ) ){
				 errors.add("Updates to Person Middle Name: Permission failure");
				 allowed = false;
			} 
			if ( allowed ) {
				vcgPerson.setMiddleName( formPerson.getMiddleName() );
				changes[Person.Changes.NAME_CHANGE.ordinal()] = true;
			}
		}
		if ( ( ! formPerson.getAddress().equals( vcgPerson.getAddress() ) || !formPerson.getCity().equals( vcgPerson.getCity() ) ||
				! formPerson.getAddress2().equals( vcgPerson.getAddress2() ) ||
				! formPerson.getZip().equals( vcgPerson.getZip() ) || ! formPerson.getState().equals( vcgPerson.getState() ) ) ){
			boolean allowed = true;
			if ( isActivated && !CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_ADDRESS.name() ) ){
				errors.add("Updates to Person Address: Permission failure");
				allowed = false;
			}
			if ( allowed ) {
				vcgPerson.setAddress( formPerson.getAddress() );
				vcgPerson.setAddress2( formPerson.getAddress2() );
				vcgPerson.setCity( formPerson.getCity() );
				vcgPerson.setState( formPerson.getState() );
				vcgPerson.setZip( formPerson.getZip() );
				vcgPerson.setValidAddress( formPerson.isValidAddress() );
				changes[Person.Changes.ADDRESS_CHANGE.ordinal()] = true;
			}
		}
		if ( !Toolbox.isEmpty( formPerson.getSsn() ) && !formPerson.getSsn().equals( vcgPerson.getSsn() ) ) {
			boolean allowed = true; 
			if ( isActivated && !CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_SSN.name() ) ){
				errors.add("Updates to Person SSN: Permission failure");
				allowed = false;
			}
			if ( allowed ){
				 vcgPerson.setSsn( formPerson.getSsn() );
				 changes[Person.Changes.PII_CHANGE.ordinal()] = true;
			}
		}
		if ( formPerson.getBirthDate() != null && !formPerson.getBirthDate().equals( vcgPerson.getBirthDate() ) ) {
			boolean allowed = true;
			if ( isActivated && !CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_BDAY.name() ) ){
				 errors.add("Updates to Person Birthdate: Permission failure");
				 allowed = false;
			} 
			if ( allowed ){
				 vcgPerson.setBirthDate( formPerson.getBirthDate() );
				 changes[Person.Changes.PII_CHANGE.ordinal()] = true;
			}
		}
		if ( vcgPerson.isVeteranRole() && formPerson.getGroupId() != vcgPerson.getGroupId() ) {
			boolean allowed = true;
			if ( isActivated && !CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_FACILITY.name() ) ){
				errors.add("Veteran Facility Change: Permission failure");
				allowed = false;
			} 
			if ( allowed ){
				vcgPerson.setGroupId( formPerson.getGroupId() );
				changes[Person.Changes.FACILITY_CHANGE.ordinal()] = true;
			}
		}

		if ( !Toolbox.isEmpty( formPerson.getGender() ) && ! formPerson.getGender().equals( vcgPerson.getGender() ) ) {
			boolean allowed = true;
			if ( isActivated && !CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_GENDER.name() ) ){
				errors.add("Updates to Person Gender: Permission failure");
				allowed = false;
			} 
			if ( allowed ){
				vcgPerson.setGender( formPerson.getGender() );
				changes[Person.Changes.PII_CHANGE.ordinal()] = true;				
			}
		}
		
		if ( vcgPerson.isPrimaryRole() ){
			boolean allowed = true;
			if ( !formPerson.getOtherHealthInsurance().equals( vcgPerson.getOtherHealthInsurance() ) ||
					((Primary)formPerson).getOtherInsChecked() != ((Primary)vcgPerson).getOtherInsChecked() ||
							((Primary)formPerson).getMediEnrolled() != ((Primary)vcgPerson).getMediEnrolled() ||
									((Primary)formPerson).getTricareEnrolled() != ((Primary)vcgPerson).getTricareEnrolled() ||
											((Primary)formPerson).getChampEnrolled() != ((Primary)vcgPerson).getChampEnrolled() ) {
				if ( !CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_INSURANCE.name() ) &&
						!CAction.canDoCaret( request, CAction.CaretCan.UPDATE_PRIMARY_INSURANCE.name() ) ){
					errors.add("Updates to Person Insurance: Permission failure");
					allowed = false;
				} 
				if ( allowed ){
					vcgPerson.setOtherHealthInsurance( ((Primary)formPerson).getOtherHealthInsurance() );
					((Primary)vcgPerson).setMediEnrolled( (Boolean) ((Primary)formPerson).getMediEnrolled() );
					((Primary)vcgPerson).setOtherInsChecked((Boolean) ((Primary)formPerson).getOtherInsChecked() );
					((Primary)vcgPerson).setTricareEnrolled((Boolean) ((Primary)formPerson).getTricareEnrolled() );
					((Primary)vcgPerson).setChampEnrolled((Boolean) ((Primary)formPerson).getChampEnrolled() );
					changes[Person.Changes.INSURANCE_CHANGE.ordinal()] = true;
				}
			}
		}

		if ( vcgPerson.isVeteranRole() && ((Veteran)formPerson).getVaHealthEnrolled() != ((Veteran)vcgPerson).getVaHealthEnrolled() ) {
			boolean allowed = true;
			if ( isActivated && !CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_INSURANCE.name() ) ){
				errors.add("Updates to VA Health Enrollment: Permission failure");
				allowed = false;
			}
			if ( allowed ){
				((Veteran)vcgPerson).setVaHealthEnrolled( ((Veteran)formPerson).getVaHealthEnrolled() );
				changes[Person.Changes.INSURANCE_CHANGE.ordinal()] = true;
			}
		}

		if ( !Toolbox.isEmpty( formPerson.getExternalId() ) && !formPerson.getExternalId().equals( vcgPerson.getExternalId() ) ){
			boolean allowed = true;
			if ( isActivated && !CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_ICN.name() )  ){
				errors.add("Updates to ICN: Permission failure");
				allowed = false;
			}
			if ( allowed ){
				vcgPerson.setExternalId( formPerson.getExternalId() );
				changes[Person.Changes.PII_CHANGE.ordinal()] = true;
			}
		}
		if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_ADDRESS.name() ) ){
			vcgPerson.setEmail( formPerson.getEmail() );
			vcgPerson.setEmail2( formPerson.getEmail2() );
			vcgPerson.setPhone( formPerson.getPhone() );
			vcgPerson.setPhone2( formPerson.getPhone2() );
		}
		return errors;
	}
	
	public void loadRelationshipLists ( PortletRequest request ) {
		Map<String,Object> caret = ResultMap.getCaretMap(request);
		if ( CAction.canDoCaret( request, CAction.CaretCan.CSL_FAMILY_RELATIONSHIPS.name() ) ){
			caret.put( CaretStrPool.RELATIONSHIP_NOT_FAMILY, PortletProps.get(CaretStrPool.CSL_RELATIONSHIP_NOT_FAMILY).split(StringPool.COMMA) );
			caret.put( CaretStrPool.RELATIONSHIP_FAMILY, PortletProps.get(CaretStrPool.CSL_RELATIONSHIP_FAMILY).split(StringPool.COMMA) );
		} else {
			caret.put( CaretStrPool.RELATIONSHIP_NOT_FAMILY, PortletProps.get(CaretStrPool.RELATIONSHIP_NOT_FAMILY).split(StringPool.COMMA) );
			caret.put( CaretStrPool.RELATIONSHIP_FAMILY, PortletProps.get(CaretStrPool.RELATIONSHIP_FAMILY).split(StringPool.COMMA) );
		}
	}
	
	public void applyWorkItem ( PortletRequest request, boolean[] change, Person person, VcgSupport vcg, Person.Role role ) throws ApplicationWorkFlowException{
//		List<String> errors = CaretViewController.getViewController().setVcgPerson( request, persn, person, role, change);
		
		ServiceContext sc = CaretParam.setCaretServiceContext(request);
		
		long userId = PortalUtil.getUserId(request);
		if ( !vcg.isPrimaryApproved() ) return;
		if ( change[Person.Changes.INSURANCE_CHANGE.ordinal()] || 
				change[Person.Changes.ADDRESS_CHANGE.ordinal()] || 
				change[Person.Changes.PII_CHANGE.ordinal()] || 
				change[Person.Changes.FACILITY_CHANGE.ordinal()] || 
				change[Person.Changes.NAME_CHANGE.ordinal()] ){
			
			boolean addedInsurChange = false;
			boolean addedInfoChange = false;
				List <WorIm> workItems =  CaretUtil.createWorkItems(request, vcg.getGroupId(), person, change, 
					vcg.getVeteranId(), person.getPersnId() == vcg.getVeteranId()? vcg.getPrimaryId(): person.getPersnId() ) ;

				if ( role == Person.Role.PRIMARY || role == Person.Role.VETERAN ) {
					for ( WorIm workItem : workItems ){
						if ( vcg.isPrimaryApproved() && WorkType.INSURANCE_CHANGE.name().equals( workItem.getType() ) ){
							if ( !addedInsurChange ){
								workItem.setVcgId( vcg.getVcgId() );
								workItem.setGroupId( vcg.getGroupId() );
//								workItem.setQueId(userId);
								workItem.setQueueId( OwnerQueue.PRIM_HEALTH_INS_Q.queueId );
								CaretLocalServiceUtil.save(workItem);
								addedInsurChange = true;
							}
						} else if ( !addedInfoChange ){
							if ( Person.Role.PRIMARY == person.getRole() ){
								workItem.setType( WorkName.C_INFO_CHANGE.name() );
								List<WorIm> workIms = WorImLocalServiceUtil.findByType(vcg.getVeteranId(), WorkName.V_INFO_CHANGE.name() );
								if ( !workIms.isEmpty() ){
									for ( WorIm w : workIms ){
										String status = w.getStatus();
										if ( status != null && !status.contains("COMPLETE") ){
											workItem.setType( WorkName.VCG_INFO_CHANGE.name() );
										}
									}
								}
							} else if ( Person.Role.VETERAN == person.getRole() ){
								workItem.setType( WorkName.V_INFO_CHANGE.name() );
								workItem.setGroupId( vcg.getGroupId() );
								if ( vcg.getPrimaryId() > 0 ){
									List<WorIm> workIms = WorImLocalServiceUtil.findByCgWork(vcg.getVcgId(), vcg.getPrimaryId(), WorkName.V_INFO_CHANGE.name() );
									if ( !workIms.isEmpty() ){
										for ( WorIm w : workIms ){
											String status = w.getStatus();
											if ( status != null && !status.contains("COMPLETE") ){
												workItem.setType( WorkName.VCG_INFO_CHANGE.name() );
											}
										}
									}
								}
							}
							workItem.setQueueId( OwnerQueue.VCG_INFO_MOD_Q.queueId );
//							workItem.setQueId(userId);
							workItem.setVcgId( vcg.getVcgId() );
							CaretLocalServiceUtil.save(workItem);
							addedInfoChange = true;
						} 
		//				CaretLocalServiceUtil.addNote( CaretUtil.createNote( 
	//						sc.getCreateDate(),
	//						person.getPersnId(),
	//						workItem.getWorImId(),
	//						sc.getUserId(),
	//						ParamUtil.get(request,
	//								CaretStrPool.WORK_COMMENT, CaretStrPool.SYSTEM_GENERATED_WORK + " " + workItem.getType() ) ) );
					}
				}
			CaretLocalServiceUtil.save(person);
		}
	}
	
	public void getOutput( PortletRequest request ){
		if ( _log.isDebugEnabled() ){
			List<String> list = new ArrayList<String>();
			for ( Enumeration<String> enume = request.getParameterNames(); enume.hasMoreElements(); ){
				list.add(enume.nextElement());
			}
			Collections.sort(list);
			for ( String name: list ){
				_log.info( name + ":" + request.getParameter(name) );
			}
		}
	}
	
}
