package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.Waivr;

import java.util.List;

/**
 * The persistence utility for the waivr service. This utility wraps {@link WaivrPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see WaivrPersistence
 * @see WaivrPersistenceImpl
 * @generated
 */
public class WaivrUtil {
    private static WaivrPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(Waivr waivr) {
        getPersistence().clearCache(waivr);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<Waivr> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<Waivr> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<Waivr> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static Waivr update(Waivr waivr) throws SystemException {
        return getPersistence().update(waivr);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static Waivr update(Waivr waivr, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(waivr, serviceContext);
    }

    /**
    * Caches the waivr in the entity cache if it is enabled.
    *
    * @param waivr the waivr
    */
    public static void cacheResult(gov.va.caret.model.Waivr waivr) {
        getPersistence().cacheResult(waivr);
    }

    /**
    * Caches the waivrs in the entity cache if it is enabled.
    *
    * @param waivrs the waivrs
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.Waivr> waivrs) {
        getPersistence().cacheResult(waivrs);
    }

    /**
    * Creates a new waivr with the primary key. Does not add the waivr to the database.
    *
    * @param waivrId the primary key for the new waivr
    * @return the new waivr
    */
    public static gov.va.caret.model.Waivr create(long waivrId) {
        return getPersistence().create(waivrId);
    }

    /**
    * Removes the waivr with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param waivrId the primary key of the waivr
    * @return the waivr that was removed
    * @throws gov.va.caret.NoSuchWaivrException if a waivr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Waivr remove(long waivrId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchWaivrException {
        return getPersistence().remove(waivrId);
    }

    public static gov.va.caret.model.Waivr updateImpl(
        gov.va.caret.model.Waivr waivr)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(waivr);
    }

    /**
    * Returns the waivr with the primary key or throws a {@link gov.va.caret.NoSuchWaivrException} if it could not be found.
    *
    * @param waivrId the primary key of the waivr
    * @return the waivr
    * @throws gov.va.caret.NoSuchWaivrException if a waivr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Waivr findByPrimaryKey(long waivrId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchWaivrException {
        return getPersistence().findByPrimaryKey(waivrId);
    }

    /**
    * Returns the waivr with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param waivrId the primary key of the waivr
    * @return the waivr, or <code>null</code> if a waivr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Waivr fetchByPrimaryKey(long waivrId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(waivrId);
    }

    /**
    * Returns all the waivrs.
    *
    * @return the waivrs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Waivr> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the waivrs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WaivrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of waivrs
    * @param end the upper bound of the range of waivrs (not inclusive)
    * @return the range of waivrs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Waivr> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the waivrs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WaivrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of waivrs
    * @param end the upper bound of the range of waivrs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of waivrs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Waivr> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the waivrs from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of waivrs.
    *
    * @return the number of waivrs
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static WaivrPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (WaivrPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    WaivrPersistence.class.getName());

            ReferenceRegistry.registerReference(WaivrUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(WaivrPersistence persistence) {
    }
}
