package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.Vendr;

/**
 * The persistence interface for the vendr service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see VendrPersistenceImpl
 * @see VendrUtil
 * @generated
 */
public interface VendrPersistence extends BasePersistence<Vendr> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link VendrUtil} to access the vendr persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the vendrs where fedTaxId = &#63;.
    *
    * @param fedTaxId the fed tax ID
    * @return the matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Vendr> findByFedTaxId(
        java.lang.String fedTaxId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the vendrs where fedTaxId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param fedTaxId the fed tax ID
    * @param start the lower bound of the range of vendrs
    * @param end the upper bound of the range of vendrs (not inclusive)
    * @return the range of matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Vendr> findByFedTaxId(
        java.lang.String fedTaxId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the vendrs where fedTaxId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param fedTaxId the fed tax ID
    * @param start the lower bound of the range of vendrs
    * @param end the upper bound of the range of vendrs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Vendr> findByFedTaxId(
        java.lang.String fedTaxId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first vendr in the ordered set where fedTaxId = &#63;.
    *
    * @param fedTaxId the fed tax ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vendr
    * @throws gov.va.caret.NoSuchVendrException if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vendr findByFedTaxId_First(
        java.lang.String fedTaxId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException;

    /**
    * Returns the first vendr in the ordered set where fedTaxId = &#63;.
    *
    * @param fedTaxId the fed tax ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vendr, or <code>null</code> if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vendr fetchByFedTaxId_First(
        java.lang.String fedTaxId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last vendr in the ordered set where fedTaxId = &#63;.
    *
    * @param fedTaxId the fed tax ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vendr
    * @throws gov.va.caret.NoSuchVendrException if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vendr findByFedTaxId_Last(
        java.lang.String fedTaxId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException;

    /**
    * Returns the last vendr in the ordered set where fedTaxId = &#63;.
    *
    * @param fedTaxId the fed tax ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vendr, or <code>null</code> if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vendr fetchByFedTaxId_Last(
        java.lang.String fedTaxId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the vendrs before and after the current vendr in the ordered set where fedTaxId = &#63;.
    *
    * @param vendrId the primary key of the current vendr
    * @param fedTaxId the fed tax ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next vendr
    * @throws gov.va.caret.NoSuchVendrException if a vendr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vendr[] findByFedTaxId_PrevAndNext(long vendrId,
        java.lang.String fedTaxId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException;

    /**
    * Removes all the vendrs where fedTaxId = &#63; from the database.
    *
    * @param fedTaxId the fed tax ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByFedTaxId(java.lang.String fedTaxId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of vendrs where fedTaxId = &#63;.
    *
    * @param fedTaxId the fed tax ID
    * @return the number of matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public int countByFedTaxId(java.lang.String fedTaxId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the vendrs where lastName = &#63;.
    *
    * @param lastName the last name
    * @return the matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Vendr> findByLastName(
        java.lang.String lastName)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the vendrs where lastName = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param lastName the last name
    * @param start the lower bound of the range of vendrs
    * @param end the upper bound of the range of vendrs (not inclusive)
    * @return the range of matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Vendr> findByLastName(
        java.lang.String lastName, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the vendrs where lastName = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param lastName the last name
    * @param start the lower bound of the range of vendrs
    * @param end the upper bound of the range of vendrs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Vendr> findByLastName(
        java.lang.String lastName, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first vendr in the ordered set where lastName = &#63;.
    *
    * @param lastName the last name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vendr
    * @throws gov.va.caret.NoSuchVendrException if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vendr findByLastName_First(
        java.lang.String lastName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException;

    /**
    * Returns the first vendr in the ordered set where lastName = &#63;.
    *
    * @param lastName the last name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vendr, or <code>null</code> if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vendr fetchByLastName_First(
        java.lang.String lastName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last vendr in the ordered set where lastName = &#63;.
    *
    * @param lastName the last name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vendr
    * @throws gov.va.caret.NoSuchVendrException if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vendr findByLastName_Last(
        java.lang.String lastName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException;

    /**
    * Returns the last vendr in the ordered set where lastName = &#63;.
    *
    * @param lastName the last name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vendr, or <code>null</code> if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vendr fetchByLastName_Last(
        java.lang.String lastName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the vendrs before and after the current vendr in the ordered set where lastName = &#63;.
    *
    * @param vendrId the primary key of the current vendr
    * @param lastName the last name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next vendr
    * @throws gov.va.caret.NoSuchVendrException if a vendr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vendr[] findByLastName_PrevAndNext(long vendrId,
        java.lang.String lastName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException;

    /**
    * Removes all the vendrs where lastName = &#63; from the database.
    *
    * @param lastName the last name
    * @throws SystemException if a system exception occurred
    */
    public void removeByLastName(java.lang.String lastName)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of vendrs where lastName = &#63;.
    *
    * @param lastName the last name
    * @return the number of matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public int countByLastName(java.lang.String lastName)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the vendrs where firstName = &#63;.
    *
    * @param firstName the first name
    * @return the matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Vendr> findByFirstName(
        java.lang.String firstName)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the vendrs where firstName = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param firstName the first name
    * @param start the lower bound of the range of vendrs
    * @param end the upper bound of the range of vendrs (not inclusive)
    * @return the range of matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Vendr> findByFirstName(
        java.lang.String firstName, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the vendrs where firstName = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param firstName the first name
    * @param start the lower bound of the range of vendrs
    * @param end the upper bound of the range of vendrs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Vendr> findByFirstName(
        java.lang.String firstName, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first vendr in the ordered set where firstName = &#63;.
    *
    * @param firstName the first name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vendr
    * @throws gov.va.caret.NoSuchVendrException if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vendr findByFirstName_First(
        java.lang.String firstName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException;

    /**
    * Returns the first vendr in the ordered set where firstName = &#63;.
    *
    * @param firstName the first name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching vendr, or <code>null</code> if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vendr fetchByFirstName_First(
        java.lang.String firstName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last vendr in the ordered set where firstName = &#63;.
    *
    * @param firstName the first name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vendr
    * @throws gov.va.caret.NoSuchVendrException if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vendr findByFirstName_Last(
        java.lang.String firstName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException;

    /**
    * Returns the last vendr in the ordered set where firstName = &#63;.
    *
    * @param firstName the first name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching vendr, or <code>null</code> if a matching vendr could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vendr fetchByFirstName_Last(
        java.lang.String firstName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the vendrs before and after the current vendr in the ordered set where firstName = &#63;.
    *
    * @param vendrId the primary key of the current vendr
    * @param firstName the first name
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next vendr
    * @throws gov.va.caret.NoSuchVendrException if a vendr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vendr[] findByFirstName_PrevAndNext(
        long vendrId, java.lang.String firstName,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException;

    /**
    * Removes all the vendrs where firstName = &#63; from the database.
    *
    * @param firstName the first name
    * @throws SystemException if a system exception occurred
    */
    public void removeByFirstName(java.lang.String firstName)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of vendrs where firstName = &#63;.
    *
    * @param firstName the first name
    * @return the number of matching vendrs
    * @throws SystemException if a system exception occurred
    */
    public int countByFirstName(java.lang.String firstName)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the vendr in the entity cache if it is enabled.
    *
    * @param vendr the vendr
    */
    public void cacheResult(gov.va.caret.model.Vendr vendr);

    /**
    * Caches the vendrs in the entity cache if it is enabled.
    *
    * @param vendrs the vendrs
    */
    public void cacheResult(java.util.List<gov.va.caret.model.Vendr> vendrs);

    /**
    * Creates a new vendr with the primary key. Does not add the vendr to the database.
    *
    * @param vendrId the primary key for the new vendr
    * @return the new vendr
    */
    public gov.va.caret.model.Vendr create(long vendrId);

    /**
    * Removes the vendr with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param vendrId the primary key of the vendr
    * @return the vendr that was removed
    * @throws gov.va.caret.NoSuchVendrException if a vendr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vendr remove(long vendrId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException;

    public gov.va.caret.model.Vendr updateImpl(gov.va.caret.model.Vendr vendr)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the vendr with the primary key or throws a {@link gov.va.caret.NoSuchVendrException} if it could not be found.
    *
    * @param vendrId the primary key of the vendr
    * @return the vendr
    * @throws gov.va.caret.NoSuchVendrException if a vendr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vendr findByPrimaryKey(long vendrId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchVendrException;

    /**
    * Returns the vendr with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param vendrId the primary key of the vendr
    * @return the vendr, or <code>null</code> if a vendr with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Vendr fetchByPrimaryKey(long vendrId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the vendrs.
    *
    * @return the vendrs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Vendr> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the vendrs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of vendrs
    * @param end the upper bound of the range of vendrs (not inclusive)
    * @return the range of vendrs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Vendr> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the vendrs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VendrModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of vendrs
    * @param end the upper bound of the range of vendrs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of vendrs
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Vendr> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the vendrs from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of vendrs.
    *
    * @return the number of vendrs
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
