package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.StiRd;

/**
 * The persistence interface for the sti rd service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see StiRdPersistenceImpl
 * @see StiRdUtil
 * @generated
 */
public interface StiRdPersistence extends BasePersistence<StiRd> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link StiRdUtil} to access the sti rd persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the sti rds where vcgAnId = &#63;.
    *
    * @param vcgAnId the vcg an ID
    * @return the matching sti rds
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.StiRd> findByVcgAnId(long vcgAnId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the sti rds where vcgAnId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiRdModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param vcgAnId the vcg an ID
    * @param start the lower bound of the range of sti rds
    * @param end the upper bound of the range of sti rds (not inclusive)
    * @return the range of matching sti rds
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.StiRd> findByVcgAnId(
        long vcgAnId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the sti rds where vcgAnId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiRdModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param vcgAnId the vcg an ID
    * @param start the lower bound of the range of sti rds
    * @param end the upper bound of the range of sti rds (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching sti rds
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.StiRd> findByVcgAnId(
        long vcgAnId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first sti rd in the ordered set where vcgAnId = &#63;.
    *
    * @param vcgAnId the vcg an ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching sti rd
    * @throws gov.va.caret.NoSuchStiRdException if a matching sti rd could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiRd findByVcgAnId_First(long vcgAnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiRdException;

    /**
    * Returns the first sti rd in the ordered set where vcgAnId = &#63;.
    *
    * @param vcgAnId the vcg an ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching sti rd, or <code>null</code> if a matching sti rd could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiRd fetchByVcgAnId_First(long vcgAnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last sti rd in the ordered set where vcgAnId = &#63;.
    *
    * @param vcgAnId the vcg an ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching sti rd
    * @throws gov.va.caret.NoSuchStiRdException if a matching sti rd could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiRd findByVcgAnId_Last(long vcgAnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiRdException;

    /**
    * Returns the last sti rd in the ordered set where vcgAnId = &#63;.
    *
    * @param vcgAnId the vcg an ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching sti rd, or <code>null</code> if a matching sti rd could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiRd fetchByVcgAnId_Last(long vcgAnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the sti rds before and after the current sti rd in the ordered set where vcgAnId = &#63;.
    *
    * @param stiRdId the primary key of the current sti rd
    * @param vcgAnId the vcg an ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next sti rd
    * @throws gov.va.caret.NoSuchStiRdException if a sti rd with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiRd[] findByVcgAnId_PrevAndNext(long stiRdId,
        long vcgAnId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiRdException;

    /**
    * Removes all the sti rds where vcgAnId = &#63; from the database.
    *
    * @param vcgAnId the vcg an ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByVcgAnId(long vcgAnId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of sti rds where vcgAnId = &#63;.
    *
    * @param vcgAnId the vcg an ID
    * @return the number of matching sti rds
    * @throws SystemException if a system exception occurred
    */
    public int countByVcgAnId(long vcgAnId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the sti rd in the entity cache if it is enabled.
    *
    * @param stiRd the sti rd
    */
    public void cacheResult(gov.va.caret.model.StiRd stiRd);

    /**
    * Caches the sti rds in the entity cache if it is enabled.
    *
    * @param stiRds the sti rds
    */
    public void cacheResult(java.util.List<gov.va.caret.model.StiRd> stiRds);

    /**
    * Creates a new sti rd with the primary key. Does not add the sti rd to the database.
    *
    * @param stiRdId the primary key for the new sti rd
    * @return the new sti rd
    */
    public gov.va.caret.model.StiRd create(long stiRdId);

    /**
    * Removes the sti rd with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param stiRdId the primary key of the sti rd
    * @return the sti rd that was removed
    * @throws gov.va.caret.NoSuchStiRdException if a sti rd with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiRd remove(long stiRdId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiRdException;

    public gov.va.caret.model.StiRd updateImpl(gov.va.caret.model.StiRd stiRd)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the sti rd with the primary key or throws a {@link gov.va.caret.NoSuchStiRdException} if it could not be found.
    *
    * @param stiRdId the primary key of the sti rd
    * @return the sti rd
    * @throws gov.va.caret.NoSuchStiRdException if a sti rd with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiRd findByPrimaryKey(long stiRdId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchStiRdException;

    /**
    * Returns the sti rd with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param stiRdId the primary key of the sti rd
    * @return the sti rd, or <code>null</code> if a sti rd with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.StiRd fetchByPrimaryKey(long stiRdId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the sti rds.
    *
    * @return the sti rds
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.StiRd> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the sti rds.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiRdModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of sti rds
    * @param end the upper bound of the range of sti rds (not inclusive)
    * @return the range of sti rds
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.StiRd> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the sti rds.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiRdModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of sti rds
    * @param end the upper bound of the range of sti rds (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of sti rds
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.StiRd> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the sti rds from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of sti rds.
    *
    * @return the number of sti rds
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
