/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.PMDeletedMessage;

/**
 * The persistence interface for the p m deleted message service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see PMDeletedMessagePersistenceImpl
 * @see PMDeletedMessageUtil
 * @generated
 */
public interface PMDeletedMessagePersistence extends BasePersistence<PMDeletedMessage> {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. Always use {@link PMDeletedMessageUtil} to access the p m deleted message persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
	 */

	/**
	* Returns all the p m deleted messages where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @return the matching p m deleted messages
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.PMDeletedMessage> findByOwnerId(
		long ownerId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the p m deleted messages where ownerId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PMDeletedMessageModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param ownerId the owner ID
	* @param start the lower bound of the range of p m deleted messages
	* @param end the upper bound of the range of p m deleted messages (not inclusive)
	* @return the range of matching p m deleted messages
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.PMDeletedMessage> findByOwnerId(
		long ownerId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the p m deleted messages where ownerId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PMDeletedMessageModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param ownerId the owner ID
	* @param start the lower bound of the range of p m deleted messages
	* @param end the upper bound of the range of p m deleted messages (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching p m deleted messages
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.PMDeletedMessage> findByOwnerId(
		long ownerId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the first p m deleted message in the ordered set where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching p m deleted message
	* @throws gov.va.caret.NoSuchPMDeletedMessageException if a matching p m deleted message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMDeletedMessage findByOwnerId_First(
		long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMDeletedMessageException;

	/**
	* Returns the first p m deleted message in the ordered set where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching p m deleted message, or <code>null</code> if a matching p m deleted message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMDeletedMessage fetchByOwnerId_First(
		long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the last p m deleted message in the ordered set where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching p m deleted message
	* @throws gov.va.caret.NoSuchPMDeletedMessageException if a matching p m deleted message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMDeletedMessage findByOwnerId_Last(
		long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMDeletedMessageException;

	/**
	* Returns the last p m deleted message in the ordered set where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching p m deleted message, or <code>null</code> if a matching p m deleted message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMDeletedMessage fetchByOwnerId_Last(
		long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the p m deleted messages before and after the current p m deleted message in the ordered set where ownerId = &#63;.
	*
	* @param deletedMessageId the primary key of the current p m deleted message
	* @param ownerId the owner ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next p m deleted message
	* @throws gov.va.caret.NoSuchPMDeletedMessageException if a p m deleted message with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMDeletedMessage[] findByOwnerId_PrevAndNext(
		long deletedMessageId, long ownerId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMDeletedMessageException;

	/**
	* Removes all the p m deleted messages where ownerId = &#63; from the database.
	*
	* @param ownerId the owner ID
	* @throws SystemException if a system exception occurred
	*/
	public void removeByOwnerId(long ownerId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of p m deleted messages where ownerId = &#63;.
	*
	* @param ownerId the owner ID
	* @return the number of matching p m deleted messages
	* @throws SystemException if a system exception occurred
	*/
	public int countByOwnerId(long ownerId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns all the p m deleted messages where messageId = &#63;.
	*
	* @param messageId the message ID
	* @return the matching p m deleted messages
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.PMDeletedMessage> findByMessageId(
		long messageId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the p m deleted messages where messageId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PMDeletedMessageModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param messageId the message ID
	* @param start the lower bound of the range of p m deleted messages
	* @param end the upper bound of the range of p m deleted messages (not inclusive)
	* @return the range of matching p m deleted messages
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.PMDeletedMessage> findByMessageId(
		long messageId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the p m deleted messages where messageId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PMDeletedMessageModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param messageId the message ID
	* @param start the lower bound of the range of p m deleted messages
	* @param end the upper bound of the range of p m deleted messages (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching p m deleted messages
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.PMDeletedMessage> findByMessageId(
		long messageId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the first p m deleted message in the ordered set where messageId = &#63;.
	*
	* @param messageId the message ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching p m deleted message
	* @throws gov.va.caret.NoSuchPMDeletedMessageException if a matching p m deleted message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMDeletedMessage findByMessageId_First(
		long messageId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMDeletedMessageException;

	/**
	* Returns the first p m deleted message in the ordered set where messageId = &#63;.
	*
	* @param messageId the message ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching p m deleted message, or <code>null</code> if a matching p m deleted message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMDeletedMessage fetchByMessageId_First(
		long messageId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the last p m deleted message in the ordered set where messageId = &#63;.
	*
	* @param messageId the message ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching p m deleted message
	* @throws gov.va.caret.NoSuchPMDeletedMessageException if a matching p m deleted message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMDeletedMessage findByMessageId_Last(
		long messageId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMDeletedMessageException;

	/**
	* Returns the last p m deleted message in the ordered set where messageId = &#63;.
	*
	* @param messageId the message ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching p m deleted message, or <code>null</code> if a matching p m deleted message could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMDeletedMessage fetchByMessageId_Last(
		long messageId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the p m deleted messages before and after the current p m deleted message in the ordered set where messageId = &#63;.
	*
	* @param deletedMessageId the primary key of the current p m deleted message
	* @param messageId the message ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next p m deleted message
	* @throws gov.va.caret.NoSuchPMDeletedMessageException if a p m deleted message with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMDeletedMessage[] findByMessageId_PrevAndNext(
		long deletedMessageId, long messageId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMDeletedMessageException;

	/**
	* Removes all the p m deleted messages where messageId = &#63; from the database.
	*
	* @param messageId the message ID
	* @throws SystemException if a system exception occurred
	*/
	public void removeByMessageId(long messageId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of p m deleted messages where messageId = &#63;.
	*
	* @param messageId the message ID
	* @return the number of matching p m deleted messages
	* @throws SystemException if a system exception occurred
	*/
	public int countByMessageId(long messageId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Caches the p m deleted message in the entity cache if it is enabled.
	*
	* @param pmDeletedMessage the p m deleted message
	*/
	public void cacheResult(
		gov.va.caret.model.PMDeletedMessage pmDeletedMessage);

	/**
	* Caches the p m deleted messages in the entity cache if it is enabled.
	*
	* @param pmDeletedMessages the p m deleted messages
	*/
	public void cacheResult(
		java.util.List<gov.va.caret.model.PMDeletedMessage> pmDeletedMessages);

	/**
	* Creates a new p m deleted message with the primary key. Does not add the p m deleted message to the database.
	*
	* @param deletedMessageId the primary key for the new p m deleted message
	* @return the new p m deleted message
	*/
	public gov.va.caret.model.PMDeletedMessage create(long deletedMessageId);

	/**
	* Removes the p m deleted message with the primary key from the database. Also notifies the appropriate model listeners.
	*
	* @param deletedMessageId the primary key of the p m deleted message
	* @return the p m deleted message that was removed
	* @throws gov.va.caret.NoSuchPMDeletedMessageException if a p m deleted message with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMDeletedMessage remove(long deletedMessageId)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMDeletedMessageException;

	public gov.va.caret.model.PMDeletedMessage updateImpl(
		gov.va.caret.model.PMDeletedMessage pmDeletedMessage)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the p m deleted message with the primary key or throws a {@link gov.va.caret.NoSuchPMDeletedMessageException} if it could not be found.
	*
	* @param deletedMessageId the primary key of the p m deleted message
	* @return the p m deleted message
	* @throws gov.va.caret.NoSuchPMDeletedMessageException if a p m deleted message with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMDeletedMessage findByPrimaryKey(
		long deletedMessageId)
		throws com.liferay.portal.kernel.exception.SystemException,
			gov.va.caret.NoSuchPMDeletedMessageException;

	/**
	* Returns the p m deleted message with the primary key or returns <code>null</code> if it could not be found.
	*
	* @param deletedMessageId the primary key of the p m deleted message
	* @return the p m deleted message, or <code>null</code> if a p m deleted message with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public gov.va.caret.model.PMDeletedMessage fetchByPrimaryKey(
		long deletedMessageId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns all the p m deleted messages.
	*
	* @return the p m deleted messages
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.PMDeletedMessage> findAll()
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the p m deleted messages.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PMDeletedMessageModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param start the lower bound of the range of p m deleted messages
	* @param end the upper bound of the range of p m deleted messages (not inclusive)
	* @return the range of p m deleted messages
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.PMDeletedMessage> findAll(
		int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the p m deleted messages.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PMDeletedMessageModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param start the lower bound of the range of p m deleted messages
	* @param end the upper bound of the range of p m deleted messages (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of p m deleted messages
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<gov.va.caret.model.PMDeletedMessage> findAll(
		int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Removes all the p m deleted messages from the database.
	*
	* @throws SystemException if a system exception occurred
	*/
	public void removeAll()
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of p m deleted messages.
	*
	* @return the number of p m deleted messages
	* @throws SystemException if a system exception occurred
	*/
	public int countAll()
		throws com.liferay.portal.kernel.exception.SystemException;
}