package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.Notif;

import java.util.List;

/**
 * The persistence utility for the notif service. This utility wraps {@link NotifPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see NotifPersistence
 * @see NotifPersistenceImpl
 * @generated
 */
public class NotifUtil {
    private static NotifPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(Notif notif) {
        getPersistence().clearCache(notif);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<Notif> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<Notif> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<Notif> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static Notif update(Notif notif) throws SystemException {
        return getPersistence().update(notif);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static Notif update(Notif notif, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(notif, serviceContext);
    }

    /**
    * Caches the notif in the entity cache if it is enabled.
    *
    * @param notif the notif
    */
    public static void cacheResult(gov.va.caret.model.Notif notif) {
        getPersistence().cacheResult(notif);
    }

    /**
    * Caches the notifs in the entity cache if it is enabled.
    *
    * @param notifs the notifs
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.Notif> notifs) {
        getPersistence().cacheResult(notifs);
    }

    /**
    * Creates a new notif with the primary key. Does not add the notif to the database.
    *
    * @param notifId the primary key for the new notif
    * @return the new notif
    */
    public static gov.va.caret.model.Notif create(long notifId) {
        return getPersistence().create(notifId);
    }

    /**
    * Removes the notif with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param notifId the primary key of the notif
    * @return the notif that was removed
    * @throws gov.va.caret.NoSuchNotifException if a notif with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Notif remove(long notifId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNotifException {
        return getPersistence().remove(notifId);
    }

    public static gov.va.caret.model.Notif updateImpl(
        gov.va.caret.model.Notif notif)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(notif);
    }

    /**
    * Returns the notif with the primary key or throws a {@link gov.va.caret.NoSuchNotifException} if it could not be found.
    *
    * @param notifId the primary key of the notif
    * @return the notif
    * @throws gov.va.caret.NoSuchNotifException if a notif with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Notif findByPrimaryKey(long notifId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchNotifException {
        return getPersistence().findByPrimaryKey(notifId);
    }

    /**
    * Returns the notif with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param notifId the primary key of the notif
    * @return the notif, or <code>null</code> if a notif with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Notif fetchByPrimaryKey(long notifId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(notifId);
    }

    /**
    * Returns all the notifs.
    *
    * @return the notifs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Notif> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the notifs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.NotifModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of notifs
    * @param end the upper bound of the range of notifs (not inclusive)
    * @return the range of notifs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Notif> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the notifs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.NotifModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of notifs
    * @param end the upper bound of the range of notifs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of notifs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Notif> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the notifs from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of notifs.
    *
    * @return the number of notifs
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static NotifPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (NotifPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    NotifPersistence.class.getName());

            ReferenceRegistry.registerReference(NotifUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(NotifPersistence persistence) {
    }
}
