package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.Facil;

/**
 * The persistence interface for the facil service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see FacilPersistenceImpl
 * @see FacilUtil
 * @generated
 */
public interface FacilPersistence extends BasePersistence<Facil> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link FacilUtil} to access the facil persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns the facil where groupId = &#63; or throws a {@link gov.va.caret.NoSuchFacilException} if it could not be found.
    *
    * @param groupId the group ID
    * @return the matching facil
    * @throws gov.va.caret.NoSuchFacilException if a matching facil could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Facil findByGroupId(long groupId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchFacilException;

    /**
    * Returns the facil where groupId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param groupId the group ID
    * @return the matching facil, or <code>null</code> if a matching facil could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Facil fetchByGroupId(long groupId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the facil where groupId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param groupId the group ID
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching facil, or <code>null</code> if a matching facil could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Facil fetchByGroupId(long groupId,
        boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes the facil where groupId = &#63; from the database.
    *
    * @param groupId the group ID
    * @return the facil that was removed
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Facil removeByGroupId(long groupId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchFacilException;

    /**
    * Returns the number of facils where groupId = &#63;.
    *
    * @param groupId the group ID
    * @return the number of matching facils
    * @throws SystemException if a system exception occurred
    */
    public int countByGroupId(long groupId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the facil where facilityNumber = &#63; or throws a {@link gov.va.caret.NoSuchFacilException} if it could not be found.
    *
    * @param facilityNumber the facility number
    * @return the matching facil
    * @throws gov.va.caret.NoSuchFacilException if a matching facil could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Facil findByFacilityNumber(
        java.lang.String facilityNumber)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchFacilException;

    /**
    * Returns the facil where facilityNumber = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param facilityNumber the facility number
    * @return the matching facil, or <code>null</code> if a matching facil could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Facil fetchByFacilityNumber(
        java.lang.String facilityNumber)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the facil where facilityNumber = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param facilityNumber the facility number
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching facil, or <code>null</code> if a matching facil could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Facil fetchByFacilityNumber(
        java.lang.String facilityNumber, boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes the facil where facilityNumber = &#63; from the database.
    *
    * @param facilityNumber the facility number
    * @return the facil that was removed
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Facil removeByFacilityNumber(
        java.lang.String facilityNumber)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchFacilException;

    /**
    * Returns the number of facils where facilityNumber = &#63;.
    *
    * @param facilityNumber the facility number
    * @return the number of matching facils
    * @throws SystemException if a system exception occurred
    */
    public int countByFacilityNumber(java.lang.String facilityNumber)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the facil in the entity cache if it is enabled.
    *
    * @param facil the facil
    */
    public void cacheResult(gov.va.caret.model.Facil facil);

    /**
    * Caches the facils in the entity cache if it is enabled.
    *
    * @param facils the facils
    */
    public void cacheResult(java.util.List<gov.va.caret.model.Facil> facils);

    /**
    * Creates a new facil with the primary key. Does not add the facil to the database.
    *
    * @param facilId the primary key for the new facil
    * @return the new facil
    */
    public gov.va.caret.model.Facil create(long facilId);

    /**
    * Removes the facil with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param facilId the primary key of the facil
    * @return the facil that was removed
    * @throws gov.va.caret.NoSuchFacilException if a facil with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Facil remove(long facilId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchFacilException;

    public gov.va.caret.model.Facil updateImpl(gov.va.caret.model.Facil facil)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the facil with the primary key or throws a {@link gov.va.caret.NoSuchFacilException} if it could not be found.
    *
    * @param facilId the primary key of the facil
    * @return the facil
    * @throws gov.va.caret.NoSuchFacilException if a facil with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Facil findByPrimaryKey(long facilId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchFacilException;

    /**
    * Returns the facil with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param facilId the primary key of the facil
    * @return the facil, or <code>null</code> if a facil with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Facil fetchByPrimaryKey(long facilId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the facils.
    *
    * @return the facils
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Facil> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the facils.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.FacilModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of facils
    * @param end the upper bound of the range of facils (not inclusive)
    * @return the range of facils
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Facil> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the facils.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.FacilModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of facils
    * @param end the upper bound of the range of facils (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of facils
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Facil> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the facils from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of facils.
    *
    * @return the number of facils
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
