package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.Docum;

/**
 * The persistence interface for the docum service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see DocumPersistenceImpl
 * @see DocumUtil
 * @generated
 */
public interface DocumPersistence extends BasePersistence<Docum> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link DocumUtil} to access the docum persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the docums where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @return the matching docums
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Docum> findByType(long classPk,
        long classId, java.lang.String type)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the docums where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param start the lower bound of the range of docums
    * @param end the upper bound of the range of docums (not inclusive)
    * @return the range of matching docums
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Docum> findByType(long classPk,
        long classId, java.lang.String type, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the docums where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param start the lower bound of the range of docums
    * @param end the upper bound of the range of docums (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching docums
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Docum> findByType(long classPk,
        long classId, java.lang.String type, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first docum in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching docum
    * @throws gov.va.caret.NoSuchDocumException if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Docum findByType_First(long classPk,
        long classId, java.lang.String type,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException;

    /**
    * Returns the first docum in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching docum, or <code>null</code> if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Docum fetchByType_First(long classPk,
        long classId, java.lang.String type,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last docum in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching docum
    * @throws gov.va.caret.NoSuchDocumException if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Docum findByType_Last(long classPk, long classId,
        java.lang.String type,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException;

    /**
    * Returns the last docum in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching docum, or <code>null</code> if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Docum fetchByType_Last(long classPk,
        long classId, java.lang.String type,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the docums before and after the current docum in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param documId the primary key of the current docum
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next docum
    * @throws gov.va.caret.NoSuchDocumException if a docum with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Docum[] findByType_PrevAndNext(long documId,
        long classPk, long classId, java.lang.String type,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException;

    /**
    * Removes all the docums where classPk = &#63; and classId = &#63; and type = &#63; from the database.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @throws SystemException if a system exception occurred
    */
    public void removeByType(long classPk, long classId, java.lang.String type)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of docums where classPk = &#63; and classId = &#63; and type = &#63;.
    *
    * @param classPk the class pk
    * @param classId the class ID
    * @param type the type
    * @return the number of matching docums
    * @throws SystemException if a system exception occurred
    */
    public int countByType(long classPk, long classId, java.lang.String type)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the docums where classPk = &#63;.
    *
    * @param classPk the class pk
    * @return the matching docums
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Docum> findByClassPk(long classPk)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the docums where classPk = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classPk the class pk
    * @param start the lower bound of the range of docums
    * @param end the upper bound of the range of docums (not inclusive)
    * @return the range of matching docums
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Docum> findByClassPk(
        long classPk, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the docums where classPk = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classPk the class pk
    * @param start the lower bound of the range of docums
    * @param end the upper bound of the range of docums (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching docums
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Docum> findByClassPk(
        long classPk, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first docum in the ordered set where classPk = &#63;.
    *
    * @param classPk the class pk
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching docum
    * @throws gov.va.caret.NoSuchDocumException if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Docum findByClassPk_First(long classPk,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException;

    /**
    * Returns the first docum in the ordered set where classPk = &#63;.
    *
    * @param classPk the class pk
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching docum, or <code>null</code> if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Docum fetchByClassPk_First(long classPk,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last docum in the ordered set where classPk = &#63;.
    *
    * @param classPk the class pk
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching docum
    * @throws gov.va.caret.NoSuchDocumException if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Docum findByClassPk_Last(long classPk,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException;

    /**
    * Returns the last docum in the ordered set where classPk = &#63;.
    *
    * @param classPk the class pk
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching docum, or <code>null</code> if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Docum fetchByClassPk_Last(long classPk,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the docums before and after the current docum in the ordered set where classPk = &#63;.
    *
    * @param documId the primary key of the current docum
    * @param classPk the class pk
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next docum
    * @throws gov.va.caret.NoSuchDocumException if a docum with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Docum[] findByClassPk_PrevAndNext(long documId,
        long classPk,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException;

    /**
    * Removes all the docums where classPk = &#63; from the database.
    *
    * @param classPk the class pk
    * @throws SystemException if a system exception occurred
    */
    public void removeByClassPk(long classPk)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of docums where classPk = &#63;.
    *
    * @param classPk the class pk
    * @return the number of matching docums
    * @throws SystemException if a system exception occurred
    */
    public int countByClassPk(long classPk)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the docums where classId = &#63;.
    *
    * @param classId the class ID
    * @return the matching docums
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Docum> findByClassId(long classId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the docums where classId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classId the class ID
    * @param start the lower bound of the range of docums
    * @param end the upper bound of the range of docums (not inclusive)
    * @return the range of matching docums
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Docum> findByClassId(
        long classId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the docums where classId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param classId the class ID
    * @param start the lower bound of the range of docums
    * @param end the upper bound of the range of docums (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching docums
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Docum> findByClassId(
        long classId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first docum in the ordered set where classId = &#63;.
    *
    * @param classId the class ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching docum
    * @throws gov.va.caret.NoSuchDocumException if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Docum findByClassId_First(long classId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException;

    /**
    * Returns the first docum in the ordered set where classId = &#63;.
    *
    * @param classId the class ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching docum, or <code>null</code> if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Docum fetchByClassId_First(long classId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last docum in the ordered set where classId = &#63;.
    *
    * @param classId the class ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching docum
    * @throws gov.va.caret.NoSuchDocumException if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Docum findByClassId_Last(long classId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException;

    /**
    * Returns the last docum in the ordered set where classId = &#63;.
    *
    * @param classId the class ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching docum, or <code>null</code> if a matching docum could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Docum fetchByClassId_Last(long classId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the docums before and after the current docum in the ordered set where classId = &#63;.
    *
    * @param documId the primary key of the current docum
    * @param classId the class ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next docum
    * @throws gov.va.caret.NoSuchDocumException if a docum with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Docum[] findByClassId_PrevAndNext(long documId,
        long classId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException;

    /**
    * Removes all the docums where classId = &#63; from the database.
    *
    * @param classId the class ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByClassId(long classId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of docums where classId = &#63;.
    *
    * @param classId the class ID
    * @return the number of matching docums
    * @throws SystemException if a system exception occurred
    */
    public int countByClassId(long classId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the docum in the entity cache if it is enabled.
    *
    * @param docum the docum
    */
    public void cacheResult(gov.va.caret.model.Docum docum);

    /**
    * Caches the docums in the entity cache if it is enabled.
    *
    * @param docums the docums
    */
    public void cacheResult(java.util.List<gov.va.caret.model.Docum> docums);

    /**
    * Creates a new docum with the primary key. Does not add the docum to the database.
    *
    * @param documId the primary key for the new docum
    * @return the new docum
    */
    public gov.va.caret.model.Docum create(long documId);

    /**
    * Removes the docum with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param documId the primary key of the docum
    * @return the docum that was removed
    * @throws gov.va.caret.NoSuchDocumException if a docum with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Docum remove(long documId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException;

    public gov.va.caret.model.Docum updateImpl(gov.va.caret.model.Docum docum)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the docum with the primary key or throws a {@link gov.va.caret.NoSuchDocumException} if it could not be found.
    *
    * @param documId the primary key of the docum
    * @return the docum
    * @throws gov.va.caret.NoSuchDocumException if a docum with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Docum findByPrimaryKey(long documId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchDocumException;

    /**
    * Returns the docum with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param documId the primary key of the docum
    * @return the docum, or <code>null</code> if a docum with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Docum fetchByPrimaryKey(long documId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the docums.
    *
    * @return the docums
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Docum> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the docums.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of docums
    * @param end the upper bound of the range of docums (not inclusive)
    * @return the range of docums
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Docum> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the docums.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of docums
    * @param end the upper bound of the range of docums (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of docums
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Docum> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the docums from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of docums.
    *
    * @return the number of docums
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
