package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.ClSoc;

import java.util.List;

/**
 * The persistence utility for the cl soc service. This utility wraps {@link ClSocPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see ClSocPersistence
 * @see ClSocPersistenceImpl
 * @generated
 */
public class ClSocUtil {
    private static ClSocPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(ClSoc clSoc) {
        getPersistence().clearCache(clSoc);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<ClSoc> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<ClSoc> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<ClSoc> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static ClSoc update(ClSoc clSoc) throws SystemException {
        return getPersistence().update(clSoc);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static ClSoc update(ClSoc clSoc, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(clSoc, serviceContext);
    }

    /**
    * Returns all the cl socs where callId = &#63;.
    *
    * @param callId the call ID
    * @return the matching cl socs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.ClSoc> findByCallId(
        long callId) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByCallId(callId);
    }

    /**
    * Returns a range of all the cl socs where callId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ClSocModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param callId the call ID
    * @param start the lower bound of the range of cl socs
    * @param end the upper bound of the range of cl socs (not inclusive)
    * @return the range of matching cl socs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.ClSoc> findByCallId(
        long callId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByCallId(callId, start, end);
    }

    /**
    * Returns an ordered range of all the cl socs where callId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ClSocModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param callId the call ID
    * @param start the lower bound of the range of cl socs
    * @param end the upper bound of the range of cl socs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching cl socs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.ClSoc> findByCallId(
        long callId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByCallId(callId, start, end, orderByComparator);
    }

    /**
    * Returns the first cl soc in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching cl soc
    * @throws gov.va.caret.NoSuchClSocException if a matching cl soc could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.ClSoc findByCallId_First(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchClSocException {
        return getPersistence().findByCallId_First(callId, orderByComparator);
    }

    /**
    * Returns the first cl soc in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching cl soc, or <code>null</code> if a matching cl soc could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.ClSoc fetchByCallId_First(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByCallId_First(callId, orderByComparator);
    }

    /**
    * Returns the last cl soc in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching cl soc
    * @throws gov.va.caret.NoSuchClSocException if a matching cl soc could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.ClSoc findByCallId_Last(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchClSocException {
        return getPersistence().findByCallId_Last(callId, orderByComparator);
    }

    /**
    * Returns the last cl soc in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching cl soc, or <code>null</code> if a matching cl soc could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.ClSoc fetchByCallId_Last(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByCallId_Last(callId, orderByComparator);
    }

    /**
    * Returns the cl socs before and after the current cl soc in the ordered set where callId = &#63;.
    *
    * @param clSocId the primary key of the current cl soc
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next cl soc
    * @throws gov.va.caret.NoSuchClSocException if a cl soc with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.ClSoc[] findByCallId_PrevAndNext(
        long clSocId, long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchClSocException {
        return getPersistence()
                   .findByCallId_PrevAndNext(clSocId, callId, orderByComparator);
    }

    /**
    * Removes all the cl socs where callId = &#63; from the database.
    *
    * @param callId the call ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByCallId(long callId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByCallId(callId);
    }

    /**
    * Returns the number of cl socs where callId = &#63;.
    *
    * @param callId the call ID
    * @return the number of matching cl socs
    * @throws SystemException if a system exception occurred
    */
    public static int countByCallId(long callId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByCallId(callId);
    }

    /**
    * Caches the cl soc in the entity cache if it is enabled.
    *
    * @param clSoc the cl soc
    */
    public static void cacheResult(gov.va.caret.model.ClSoc clSoc) {
        getPersistence().cacheResult(clSoc);
    }

    /**
    * Caches the cl socs in the entity cache if it is enabled.
    *
    * @param clSocs the cl socs
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.ClSoc> clSocs) {
        getPersistence().cacheResult(clSocs);
    }

    /**
    * Creates a new cl soc with the primary key. Does not add the cl soc to the database.
    *
    * @param clSocId the primary key for the new cl soc
    * @return the new cl soc
    */
    public static gov.va.caret.model.ClSoc create(long clSocId) {
        return getPersistence().create(clSocId);
    }

    /**
    * Removes the cl soc with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param clSocId the primary key of the cl soc
    * @return the cl soc that was removed
    * @throws gov.va.caret.NoSuchClSocException if a cl soc with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.ClSoc remove(long clSocId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchClSocException {
        return getPersistence().remove(clSocId);
    }

    public static gov.va.caret.model.ClSoc updateImpl(
        gov.va.caret.model.ClSoc clSoc)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(clSoc);
    }

    /**
    * Returns the cl soc with the primary key or throws a {@link gov.va.caret.NoSuchClSocException} if it could not be found.
    *
    * @param clSocId the primary key of the cl soc
    * @return the cl soc
    * @throws gov.va.caret.NoSuchClSocException if a cl soc with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.ClSoc findByPrimaryKey(long clSocId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchClSocException {
        return getPersistence().findByPrimaryKey(clSocId);
    }

    /**
    * Returns the cl soc with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param clSocId the primary key of the cl soc
    * @return the cl soc, or <code>null</code> if a cl soc with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.ClSoc fetchByPrimaryKey(long clSocId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(clSocId);
    }

    /**
    * Returns all the cl socs.
    *
    * @return the cl socs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.ClSoc> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the cl socs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ClSocModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of cl socs
    * @param end the upper bound of the range of cl socs (not inclusive)
    * @return the range of cl socs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.ClSoc> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the cl socs.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.ClSocModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of cl socs
    * @param end the upper bound of the range of cl socs (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of cl socs
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.ClSoc> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the cl socs from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of cl socs.
    *
    * @return the number of cl socs
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static ClSocPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (ClSocPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    ClSocPersistence.class.getName());

            ReferenceRegistry.registerReference(ClSocUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(ClSocPersistence persistence) {
    }
}
