package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.Cesp;

/**
 * The persistence interface for the cesp service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see CespPersistenceImpl
 * @see CespUtil
 * @generated
 */
public interface CespPersistence extends BasePersistence<Cesp> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link CespUtil} to access the cesp persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the cesps where callId = &#63;.
    *
    * @param callId the call ID
    * @return the matching cesps
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Cesp> findByCallId(long callId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the cesps where callId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CespModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param callId the call ID
    * @param start the lower bound of the range of cesps
    * @param end the upper bound of the range of cesps (not inclusive)
    * @return the range of matching cesps
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Cesp> findByCallId(long callId,
        int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the cesps where callId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CespModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param callId the call ID
    * @param start the lower bound of the range of cesps
    * @param end the upper bound of the range of cesps (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching cesps
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Cesp> findByCallId(long callId,
        int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first cesp in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching cesp
    * @throws gov.va.caret.NoSuchCespException if a matching cesp could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Cesp findByCallId_First(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCespException;

    /**
    * Returns the first cesp in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching cesp, or <code>null</code> if a matching cesp could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Cesp fetchByCallId_First(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last cesp in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching cesp
    * @throws gov.va.caret.NoSuchCespException if a matching cesp could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Cesp findByCallId_Last(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCespException;

    /**
    * Returns the last cesp in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching cesp, or <code>null</code> if a matching cesp could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Cesp fetchByCallId_Last(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the cesps before and after the current cesp in the ordered set where callId = &#63;.
    *
    * @param cespId the primary key of the current cesp
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next cesp
    * @throws gov.va.caret.NoSuchCespException if a cesp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Cesp[] findByCallId_PrevAndNext(long cespId,
        long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCespException;

    /**
    * Removes all the cesps where callId = &#63; from the database.
    *
    * @param callId the call ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByCallId(long callId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of cesps where callId = &#63;.
    *
    * @param callId the call ID
    * @return the number of matching cesps
    * @throws SystemException if a system exception occurred
    */
    public int countByCallId(long callId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the cesp in the entity cache if it is enabled.
    *
    * @param cesp the cesp
    */
    public void cacheResult(gov.va.caret.model.Cesp cesp);

    /**
    * Caches the cesps in the entity cache if it is enabled.
    *
    * @param cesps the cesps
    */
    public void cacheResult(java.util.List<gov.va.caret.model.Cesp> cesps);

    /**
    * Creates a new cesp with the primary key. Does not add the cesp to the database.
    *
    * @param cespId the primary key for the new cesp
    * @return the new cesp
    */
    public gov.va.caret.model.Cesp create(long cespId);

    /**
    * Removes the cesp with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param cespId the primary key of the cesp
    * @return the cesp that was removed
    * @throws gov.va.caret.NoSuchCespException if a cesp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Cesp remove(long cespId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCespException;

    public gov.va.caret.model.Cesp updateImpl(gov.va.caret.model.Cesp cesp)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the cesp with the primary key or throws a {@link gov.va.caret.NoSuchCespException} if it could not be found.
    *
    * @param cespId the primary key of the cesp
    * @return the cesp
    * @throws gov.va.caret.NoSuchCespException if a cesp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Cesp findByPrimaryKey(long cespId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCespException;

    /**
    * Returns the cesp with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param cespId the primary key of the cesp
    * @return the cesp, or <code>null</code> if a cesp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.Cesp fetchByPrimaryKey(long cespId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the cesps.
    *
    * @return the cesps
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Cesp> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the cesps.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CespModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of cesps
    * @param end the upper bound of the range of cesps (not inclusive)
    * @return the range of cesps
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Cesp> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the cesps.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CespModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of cesps
    * @param end the upper bound of the range of cesps (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of cesps
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.Cesp> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the cesps from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of cesps.
    *
    * @return the number of cesps
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
