package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.CalEt;

/**
 * The persistence interface for the cal et service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see CalEtPersistenceImpl
 * @see CalEtUtil
 * @generated
 */
public interface CalEtPersistence extends BasePersistence<CalEt> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link CalEtUtil} to access the cal et persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the cal ets where callId = &#63;.
    *
    * @param callId the call ID
    * @return the matching cal ets
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.CalEt> findByCallId(long callId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the cal ets where callId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CalEtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param callId the call ID
    * @param start the lower bound of the range of cal ets
    * @param end the upper bound of the range of cal ets (not inclusive)
    * @return the range of matching cal ets
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.CalEt> findByCallId(long callId,
        int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the cal ets where callId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CalEtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param callId the call ID
    * @param start the lower bound of the range of cal ets
    * @param end the upper bound of the range of cal ets (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching cal ets
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.CalEt> findByCallId(long callId,
        int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first cal et in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching cal et
    * @throws gov.va.caret.NoSuchCalEtException if a matching cal et could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.CalEt findByCallId_First(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCalEtException;

    /**
    * Returns the first cal et in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching cal et, or <code>null</code> if a matching cal et could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.CalEt fetchByCallId_First(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last cal et in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching cal et
    * @throws gov.va.caret.NoSuchCalEtException if a matching cal et could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.CalEt findByCallId_Last(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCalEtException;

    /**
    * Returns the last cal et in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching cal et, or <code>null</code> if a matching cal et could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.CalEt fetchByCallId_Last(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the cal ets before and after the current cal et in the ordered set where callId = &#63;.
    *
    * @param calEtId the primary key of the current cal et
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next cal et
    * @throws gov.va.caret.NoSuchCalEtException if a cal et with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.CalEt[] findByCallId_PrevAndNext(long calEtId,
        long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCalEtException;

    /**
    * Removes all the cal ets where callId = &#63; from the database.
    *
    * @param callId the call ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByCallId(long callId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of cal ets where callId = &#63;.
    *
    * @param callId the call ID
    * @return the number of matching cal ets
    * @throws SystemException if a system exception occurred
    */
    public int countByCallId(long callId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the cal et in the entity cache if it is enabled.
    *
    * @param calEt the cal et
    */
    public void cacheResult(gov.va.caret.model.CalEt calEt);

    /**
    * Caches the cal ets in the entity cache if it is enabled.
    *
    * @param calEts the cal ets
    */
    public void cacheResult(java.util.List<gov.va.caret.model.CalEt> calEts);

    /**
    * Creates a new cal et with the primary key. Does not add the cal et to the database.
    *
    * @param calEtId the primary key for the new cal et
    * @return the new cal et
    */
    public gov.va.caret.model.CalEt create(long calEtId);

    /**
    * Removes the cal et with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param calEtId the primary key of the cal et
    * @return the cal et that was removed
    * @throws gov.va.caret.NoSuchCalEtException if a cal et with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.CalEt remove(long calEtId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCalEtException;

    public gov.va.caret.model.CalEt updateImpl(gov.va.caret.model.CalEt calEt)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the cal et with the primary key or throws a {@link gov.va.caret.NoSuchCalEtException} if it could not be found.
    *
    * @param calEtId the primary key of the cal et
    * @return the cal et
    * @throws gov.va.caret.NoSuchCalEtException if a cal et with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.CalEt findByPrimaryKey(long calEtId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCalEtException;

    /**
    * Returns the cal et with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param calEtId the primary key of the cal et
    * @return the cal et, or <code>null</code> if a cal et with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.CalEt fetchByPrimaryKey(long calEtId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the cal ets.
    *
    * @return the cal ets
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.CalEt> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the cal ets.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CalEtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of cal ets
    * @param end the upper bound of the range of cal ets (not inclusive)
    * @return the range of cal ets
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.CalEt> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the cal ets.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CalEtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of cal ets
    * @param end the upper bound of the range of cal ets (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of cal ets
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.CalEt> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the cal ets from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of cal ets.
    *
    * @return the number of cal ets
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
