package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.BlsRe;

import java.util.List;

/**
 * The persistence utility for the bls re service. This utility wraps {@link BlsRePersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BlsRePersistence
 * @see BlsRePersistenceImpl
 * @generated
 */
public class BlsReUtil {
    private static BlsRePersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(BlsRe blsRe) {
        getPersistence().clearCache(blsRe);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<BlsRe> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<BlsRe> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<BlsRe> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static BlsRe update(BlsRe blsRe) throws SystemException {
        return getPersistence().update(blsRe);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static BlsRe update(BlsRe blsRe, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(blsRe, serviceContext);
    }

    /**
    * Returns all the bls res where state = &#63;.
    *
    * @param state the state
    * @return the matching bls res
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BlsRe> findByState(
        java.lang.String state)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByState(state);
    }

    /**
    * Returns a range of all the bls res where state = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsReModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param state the state
    * @param start the lower bound of the range of bls res
    * @param end the upper bound of the range of bls res (not inclusive)
    * @return the range of matching bls res
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BlsRe> findByState(
        java.lang.String state, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByState(state, start, end);
    }

    /**
    * Returns an ordered range of all the bls res where state = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsReModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param state the state
    * @param start the lower bound of the range of bls res
    * @param end the upper bound of the range of bls res (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching bls res
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BlsRe> findByState(
        java.lang.String state, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByState(state, start, end, orderByComparator);
    }

    /**
    * Returns the first bls re in the ordered set where state = &#63;.
    *
    * @param state the state
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bls re
    * @throws gov.va.caret.NoSuchBlsReException if a matching bls re could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsRe findByState_First(
        java.lang.String state,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsReException {
        return getPersistence().findByState_First(state, orderByComparator);
    }

    /**
    * Returns the first bls re in the ordered set where state = &#63;.
    *
    * @param state the state
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bls re, or <code>null</code> if a matching bls re could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsRe fetchByState_First(
        java.lang.String state,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByState_First(state, orderByComparator);
    }

    /**
    * Returns the last bls re in the ordered set where state = &#63;.
    *
    * @param state the state
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bls re
    * @throws gov.va.caret.NoSuchBlsReException if a matching bls re could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsRe findByState_Last(
        java.lang.String state,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsReException {
        return getPersistence().findByState_Last(state, orderByComparator);
    }

    /**
    * Returns the last bls re in the ordered set where state = &#63;.
    *
    * @param state the state
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bls re, or <code>null</code> if a matching bls re could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsRe fetchByState_Last(
        java.lang.String state,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByState_Last(state, orderByComparator);
    }

    /**
    * Returns the bls res before and after the current bls re in the ordered set where state = &#63;.
    *
    * @param blsReId the primary key of the current bls re
    * @param state the state
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next bls re
    * @throws gov.va.caret.NoSuchBlsReException if a bls re with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsRe[] findByState_PrevAndNext(
        long blsReId, java.lang.String state,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsReException {
        return getPersistence()
                   .findByState_PrevAndNext(blsReId, state, orderByComparator);
    }

    /**
    * Removes all the bls res where state = &#63; from the database.
    *
    * @param state the state
    * @throws SystemException if a system exception occurred
    */
    public static void removeByState(java.lang.String state)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByState(state);
    }

    /**
    * Returns the number of bls res where state = &#63;.
    *
    * @param state the state
    * @return the number of matching bls res
    * @throws SystemException if a system exception occurred
    */
    public static int countByState(java.lang.String state)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByState(state);
    }

    /**
    * Returns all the bls res where zip = &#63;.
    *
    * @param zip the zip
    * @return the matching bls res
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BlsRe> findByZip(
        java.lang.String zip)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByZip(zip);
    }

    /**
    * Returns a range of all the bls res where zip = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsReModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param zip the zip
    * @param start the lower bound of the range of bls res
    * @param end the upper bound of the range of bls res (not inclusive)
    * @return the range of matching bls res
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BlsRe> findByZip(
        java.lang.String zip, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByZip(zip, start, end);
    }

    /**
    * Returns an ordered range of all the bls res where zip = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsReModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param zip the zip
    * @param start the lower bound of the range of bls res
    * @param end the upper bound of the range of bls res (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching bls res
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BlsRe> findByZip(
        java.lang.String zip, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByZip(zip, start, end, orderByComparator);
    }

    /**
    * Returns the first bls re in the ordered set where zip = &#63;.
    *
    * @param zip the zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bls re
    * @throws gov.va.caret.NoSuchBlsReException if a matching bls re could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsRe findByZip_First(
        java.lang.String zip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsReException {
        return getPersistence().findByZip_First(zip, orderByComparator);
    }

    /**
    * Returns the first bls re in the ordered set where zip = &#63;.
    *
    * @param zip the zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bls re, or <code>null</code> if a matching bls re could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsRe fetchByZip_First(
        java.lang.String zip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByZip_First(zip, orderByComparator);
    }

    /**
    * Returns the last bls re in the ordered set where zip = &#63;.
    *
    * @param zip the zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bls re
    * @throws gov.va.caret.NoSuchBlsReException if a matching bls re could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsRe findByZip_Last(
        java.lang.String zip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsReException {
        return getPersistence().findByZip_Last(zip, orderByComparator);
    }

    /**
    * Returns the last bls re in the ordered set where zip = &#63;.
    *
    * @param zip the zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bls re, or <code>null</code> if a matching bls re could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsRe fetchByZip_Last(
        java.lang.String zip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByZip_Last(zip, orderByComparator);
    }

    /**
    * Returns the bls res before and after the current bls re in the ordered set where zip = &#63;.
    *
    * @param blsReId the primary key of the current bls re
    * @param zip the zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next bls re
    * @throws gov.va.caret.NoSuchBlsReException if a bls re with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsRe[] findByZip_PrevAndNext(
        long blsReId, java.lang.String zip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsReException {
        return getPersistence()
                   .findByZip_PrevAndNext(blsReId, zip, orderByComparator);
    }

    /**
    * Removes all the bls res where zip = &#63; from the database.
    *
    * @param zip the zip
    * @throws SystemException if a system exception occurred
    */
    public static void removeByZip(java.lang.String zip)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByZip(zip);
    }

    /**
    * Returns the number of bls res where zip = &#63;.
    *
    * @param zip the zip
    * @return the number of matching bls res
    * @throws SystemException if a system exception occurred
    */
    public static int countByZip(java.lang.String zip)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByZip(zip);
    }

    /**
    * Caches the bls re in the entity cache if it is enabled.
    *
    * @param blsRe the bls re
    */
    public static void cacheResult(gov.va.caret.model.BlsRe blsRe) {
        getPersistence().cacheResult(blsRe);
    }

    /**
    * Caches the bls res in the entity cache if it is enabled.
    *
    * @param blsRes the bls res
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.BlsRe> blsRes) {
        getPersistence().cacheResult(blsRes);
    }

    /**
    * Creates a new bls re with the primary key. Does not add the bls re to the database.
    *
    * @param blsReId the primary key for the new bls re
    * @return the new bls re
    */
    public static gov.va.caret.model.BlsRe create(long blsReId) {
        return getPersistence().create(blsReId);
    }

    /**
    * Removes the bls re with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param blsReId the primary key of the bls re
    * @return the bls re that was removed
    * @throws gov.va.caret.NoSuchBlsReException if a bls re with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsRe remove(long blsReId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsReException {
        return getPersistence().remove(blsReId);
    }

    public static gov.va.caret.model.BlsRe updateImpl(
        gov.va.caret.model.BlsRe blsRe)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(blsRe);
    }

    /**
    * Returns the bls re with the primary key or throws a {@link gov.va.caret.NoSuchBlsReException} if it could not be found.
    *
    * @param blsReId the primary key of the bls re
    * @return the bls re
    * @throws gov.va.caret.NoSuchBlsReException if a bls re with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsRe findByPrimaryKey(long blsReId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsReException {
        return getPersistence().findByPrimaryKey(blsReId);
    }

    /**
    * Returns the bls re with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param blsReId the primary key of the bls re
    * @return the bls re, or <code>null</code> if a bls re with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BlsRe fetchByPrimaryKey(long blsReId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(blsReId);
    }

    /**
    * Returns all the bls res.
    *
    * @return the bls res
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BlsRe> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the bls res.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsReModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bls res
    * @param end the upper bound of the range of bls res (not inclusive)
    * @return the range of bls res
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BlsRe> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the bls res.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsReModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bls res
    * @param end the upper bound of the range of bls res (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of bls res
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BlsRe> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the bls res from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of bls res.
    *
    * @return the number of bls res
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static BlsRePersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (BlsRePersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    BlsRePersistence.class.getName());

            ReferenceRegistry.registerReference(BlsReUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(BlsRePersistence persistence) {
    }
}
