package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.BlsRe;

/**
 * The persistence interface for the bls re service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BlsRePersistenceImpl
 * @see BlsReUtil
 * @generated
 */
public interface BlsRePersistence extends BasePersistence<BlsRe> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link BlsReUtil} to access the bls re persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the bls res where state = &#63;.
    *
    * @param state the state
    * @return the matching bls res
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BlsRe> findByState(
        java.lang.String state)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the bls res where state = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsReModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param state the state
    * @param start the lower bound of the range of bls res
    * @param end the upper bound of the range of bls res (not inclusive)
    * @return the range of matching bls res
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BlsRe> findByState(
        java.lang.String state, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the bls res where state = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsReModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param state the state
    * @param start the lower bound of the range of bls res
    * @param end the upper bound of the range of bls res (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching bls res
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BlsRe> findByState(
        java.lang.String state, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first bls re in the ordered set where state = &#63;.
    *
    * @param state the state
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bls re
    * @throws gov.va.caret.NoSuchBlsReException if a matching bls re could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsRe findByState_First(java.lang.String state,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsReException;

    /**
    * Returns the first bls re in the ordered set where state = &#63;.
    *
    * @param state the state
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bls re, or <code>null</code> if a matching bls re could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsRe fetchByState_First(java.lang.String state,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last bls re in the ordered set where state = &#63;.
    *
    * @param state the state
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bls re
    * @throws gov.va.caret.NoSuchBlsReException if a matching bls re could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsRe findByState_Last(java.lang.String state,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsReException;

    /**
    * Returns the last bls re in the ordered set where state = &#63;.
    *
    * @param state the state
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bls re, or <code>null</code> if a matching bls re could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsRe fetchByState_Last(java.lang.String state,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the bls res before and after the current bls re in the ordered set where state = &#63;.
    *
    * @param blsReId the primary key of the current bls re
    * @param state the state
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next bls re
    * @throws gov.va.caret.NoSuchBlsReException if a bls re with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsRe[] findByState_PrevAndNext(long blsReId,
        java.lang.String state,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsReException;

    /**
    * Removes all the bls res where state = &#63; from the database.
    *
    * @param state the state
    * @throws SystemException if a system exception occurred
    */
    public void removeByState(java.lang.String state)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of bls res where state = &#63;.
    *
    * @param state the state
    * @return the number of matching bls res
    * @throws SystemException if a system exception occurred
    */
    public int countByState(java.lang.String state)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the bls res where zip = &#63;.
    *
    * @param zip the zip
    * @return the matching bls res
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BlsRe> findByZip(
        java.lang.String zip)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the bls res where zip = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsReModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param zip the zip
    * @param start the lower bound of the range of bls res
    * @param end the upper bound of the range of bls res (not inclusive)
    * @return the range of matching bls res
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BlsRe> findByZip(
        java.lang.String zip, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the bls res where zip = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsReModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param zip the zip
    * @param start the lower bound of the range of bls res
    * @param end the upper bound of the range of bls res (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching bls res
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BlsRe> findByZip(
        java.lang.String zip, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first bls re in the ordered set where zip = &#63;.
    *
    * @param zip the zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bls re
    * @throws gov.va.caret.NoSuchBlsReException if a matching bls re could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsRe findByZip_First(java.lang.String zip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsReException;

    /**
    * Returns the first bls re in the ordered set where zip = &#63;.
    *
    * @param zip the zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bls re, or <code>null</code> if a matching bls re could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsRe fetchByZip_First(java.lang.String zip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last bls re in the ordered set where zip = &#63;.
    *
    * @param zip the zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bls re
    * @throws gov.va.caret.NoSuchBlsReException if a matching bls re could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsRe findByZip_Last(java.lang.String zip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsReException;

    /**
    * Returns the last bls re in the ordered set where zip = &#63;.
    *
    * @param zip the zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bls re, or <code>null</code> if a matching bls re could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsRe fetchByZip_Last(java.lang.String zip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the bls res before and after the current bls re in the ordered set where zip = &#63;.
    *
    * @param blsReId the primary key of the current bls re
    * @param zip the zip
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next bls re
    * @throws gov.va.caret.NoSuchBlsReException if a bls re with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsRe[] findByZip_PrevAndNext(long blsReId,
        java.lang.String zip,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsReException;

    /**
    * Removes all the bls res where zip = &#63; from the database.
    *
    * @param zip the zip
    * @throws SystemException if a system exception occurred
    */
    public void removeByZip(java.lang.String zip)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of bls res where zip = &#63;.
    *
    * @param zip the zip
    * @return the number of matching bls res
    * @throws SystemException if a system exception occurred
    */
    public int countByZip(java.lang.String zip)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the bls re in the entity cache if it is enabled.
    *
    * @param blsRe the bls re
    */
    public void cacheResult(gov.va.caret.model.BlsRe blsRe);

    /**
    * Caches the bls res in the entity cache if it is enabled.
    *
    * @param blsRes the bls res
    */
    public void cacheResult(java.util.List<gov.va.caret.model.BlsRe> blsRes);

    /**
    * Creates a new bls re with the primary key. Does not add the bls re to the database.
    *
    * @param blsReId the primary key for the new bls re
    * @return the new bls re
    */
    public gov.va.caret.model.BlsRe create(long blsReId);

    /**
    * Removes the bls re with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param blsReId the primary key of the bls re
    * @return the bls re that was removed
    * @throws gov.va.caret.NoSuchBlsReException if a bls re with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsRe remove(long blsReId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsReException;

    public gov.va.caret.model.BlsRe updateImpl(gov.va.caret.model.BlsRe blsRe)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the bls re with the primary key or throws a {@link gov.va.caret.NoSuchBlsReException} if it could not be found.
    *
    * @param blsReId the primary key of the bls re
    * @return the bls re
    * @throws gov.va.caret.NoSuchBlsReException if a bls re with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsRe findByPrimaryKey(long blsReId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBlsReException;

    /**
    * Returns the bls re with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param blsReId the primary key of the bls re
    * @return the bls re, or <code>null</code> if a bls re with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BlsRe fetchByPrimaryKey(long blsReId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the bls res.
    *
    * @return the bls res
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BlsRe> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the bls res.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsReModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bls res
    * @param end the upper bound of the range of bls res (not inclusive)
    * @return the range of bls res
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BlsRe> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the bls res.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BlsReModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bls res
    * @param end the upper bound of the range of bls res (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of bls res
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BlsRe> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the bls res from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of bls res.
    *
    * @return the number of bls res
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
