package gov.va.caret.service;

import com.liferay.portal.service.ServiceWrapper;

/**
 * Provides a wrapper for {@link DocumLocalService}.
 *
 * @author caret
 * @see DocumLocalService
 * @generated
 */
public class DocumLocalServiceWrapper implements DocumLocalService,
    ServiceWrapper<DocumLocalService> {
    private DocumLocalService _documLocalService;

    public DocumLocalServiceWrapper(DocumLocalService documLocalService) {
        _documLocalService = documLocalService;
    }

    /**
    * Adds the docum to the database. Also notifies the appropriate model listeners.
    *
    * @param docum the docum
    * @return the docum that was added
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.Docum addDocum(gov.va.caret.model.Docum docum)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _documLocalService.addDocum(docum);
    }

    /**
    * Creates a new docum with the primary key. Does not add the docum to the database.
    *
    * @param documId the primary key for the new docum
    * @return the new docum
    */
    @Override
    public gov.va.caret.model.Docum createDocum(long documId) {
        return _documLocalService.createDocum(documId);
    }

    /**
    * Deletes the docum with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param documId the primary key of the docum
    * @return the docum that was removed
    * @throws PortalException if a docum with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.Docum deleteDocum(long documId)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _documLocalService.deleteDocum(documId);
    }

    /**
    * Deletes the docum from the database. Also notifies the appropriate model listeners.
    *
    * @param docum the docum
    * @return the docum that was removed
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.Docum deleteDocum(gov.va.caret.model.Docum docum)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _documLocalService.deleteDocum(docum);
    }

    @Override
    public com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery() {
        return _documLocalService.dynamicQuery();
    }

    /**
    * Performs a dynamic query on the database and returns the matching rows.
    *
    * @param dynamicQuery the dynamic query
    * @return the matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _documLocalService.dynamicQuery(dynamicQuery);
    }

    /**
    * Performs a dynamic query on the database and returns a range of the matching rows.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param dynamicQuery the dynamic query
    * @param start the lower bound of the range of model instances
    * @param end the upper bound of the range of model instances (not inclusive)
    * @return the range of matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return _documLocalService.dynamicQuery(dynamicQuery, start, end);
    }

    /**
    * Performs a dynamic query on the database and returns an ordered range of the matching rows.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param dynamicQuery the dynamic query
    * @param start the lower bound of the range of model instances
    * @param end the upper bound of the range of model instances (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching rows
    * @throws SystemException if a system exception occurred
    */
    @Override
    @SuppressWarnings("rawtypes")
    public java.util.List dynamicQuery(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _documLocalService.dynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
    * Returns the number of rows that match the dynamic query.
    *
    * @param dynamicQuery the dynamic query
    * @return the number of rows that match the dynamic query
    * @throws SystemException if a system exception occurred
    */
    @Override
    public long dynamicQueryCount(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _documLocalService.dynamicQueryCount(dynamicQuery);
    }

    /**
    * Returns the number of rows that match the dynamic query.
    *
    * @param dynamicQuery the dynamic query
    * @param projection the projection to apply to the query
    * @return the number of rows that match the dynamic query
    * @throws SystemException if a system exception occurred
    */
    @Override
    public long dynamicQueryCount(
        com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery,
        com.liferay.portal.kernel.dao.orm.Projection projection)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _documLocalService.dynamicQueryCount(dynamicQuery, projection);
    }

    @Override
    public gov.va.caret.model.Docum fetchDocum(long documId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _documLocalService.fetchDocum(documId);
    }

    /**
    * Returns the docum with the primary key.
    *
    * @param documId the primary key of the docum
    * @return the docum
    * @throws PortalException if a docum with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.Docum getDocum(long documId)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _documLocalService.getDocum(documId);
    }

    @Override
    public com.liferay.portal.model.PersistedModel getPersistedModel(
        java.io.Serializable primaryKeyObj)
        throws com.liferay.portal.kernel.exception.PortalException,
            com.liferay.portal.kernel.exception.SystemException {
        return _documLocalService.getPersistedModel(primaryKeyObj);
    }

    /**
    * Returns a range of all the docums.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.DocumModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of docums
    * @param end the upper bound of the range of docums (not inclusive)
    * @return the range of docums
    * @throws SystemException if a system exception occurred
    */
    @Override
    public java.util.List<gov.va.caret.model.Docum> getDocums(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _documLocalService.getDocums(start, end);
    }

    /**
    * Returns the number of docums.
    *
    * @return the number of docums
    * @throws SystemException if a system exception occurred
    */
    @Override
    public int getDocumsCount()
        throws com.liferay.portal.kernel.exception.SystemException {
        return _documLocalService.getDocumsCount();
    }

    /**
    * Updates the docum in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
    *
    * @param docum the docum
    * @return the docum that was updated
    * @throws SystemException if a system exception occurred
    */
    @Override
    public gov.va.caret.model.Docum updateDocum(gov.va.caret.model.Docum docum)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _documLocalService.updateDocum(docum);
    }

    @Override
    public gov.va.caret.model.DocumDocumentBlobModel getDocumentBlobModel(
        java.io.Serializable primaryKey)
        throws com.liferay.portal.kernel.exception.SystemException {
        return _documLocalService.getDocumentBlobModel(primaryKey);
    }

    /**
    * Returns the Spring bean ID for this bean.
    *
    * @return the Spring bean ID for this bean
    */
    @Override
    public java.lang.String getBeanIdentifier() {
        return _documLocalService.getBeanIdentifier();
    }

    /**
    * Sets the Spring bean ID for this bean.
    *
    * @param beanIdentifier the Spring bean ID for this bean
    */
    @Override
    public void setBeanIdentifier(java.lang.String beanIdentifier) {
        _documLocalService.setBeanIdentifier(beanIdentifier);
    }

    @Override
    public java.lang.Object invokeMethod(java.lang.String name,
        java.lang.String[] parameterTypes, java.lang.Object[] arguments)
        throws java.lang.Throwable {
        return _documLocalService.invokeMethod(name, parameterTypes, arguments);
    }

    @Override
    public java.util.List<gov.va.caret.model.Docum> getByClass(
        long primaryKey, long classId, java.lang.String type)
        throws gov.va.caret.ApplicationWorkFlowException {
        return _documLocalService.getByClass(primaryKey, classId, type);
    }

    @Override
    public java.util.List<gov.va.caret.model.Docum> getByPrimaryKey(
        long primaryKey) throws gov.va.caret.ApplicationWorkFlowException {
        return _documLocalService.getByPrimaryKey(primaryKey);
    }

    @Override
    public java.util.List<gov.va.caret.model.Docum> getByClassId(
        long primaryKey) throws gov.va.caret.ApplicationWorkFlowException {
        return _documLocalService.getByClassId(primaryKey);
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedService}
     */
    public DocumLocalService getWrappedDocumLocalService() {
        return _documLocalService;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #setWrappedService}
     */
    public void setWrappedDocumLocalService(DocumLocalService documLocalService) {
        _documLocalService = documLocalService;
    }

    @Override
    public DocumLocalService getWrappedService() {
        return _documLocalService;
    }

    @Override
    public void setWrappedService(DocumLocalService documLocalService) {
        _documLocalService = documLocalService;
    }
}
