package gov.va.caret.service;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ClassLoaderObjectInputStream;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;

import gov.va.caret.model.AssmtClp;
import gov.va.caret.model.AudLgClp;
import gov.va.caret.model.BgAsnClp;
import gov.va.caret.model.BgLaeClp;
import gov.va.caret.model.BgNumClp;
import gov.va.caret.model.BlsAeClp;
import gov.va.caret.model.BlsReClp;
import gov.va.caret.model.BoxGpClp;
import gov.va.caret.model.CalEtClp;
import gov.va.caret.model.CallClp;
import gov.va.caret.model.CespClp;
import gov.va.caret.model.ClSocClp;
import gov.va.caret.model.CryptoClp;
import gov.va.caret.model.DocumClp;
import gov.va.caret.model.FacilClp;
import gov.va.caret.model.NoteClp;
import gov.va.caret.model.NotifClp;
import gov.va.caret.model.PMDeletedMessageClp;
import gov.va.caret.model.PMMessageClp;
import gov.va.caret.model.PMReadMessageClp;
import gov.va.caret.model.PayLgClp;
import gov.va.caret.model.PersnClp;
import gov.va.caret.model.StiPtClp;
import gov.va.caret.model.StiRdClp;
import gov.va.caret.model.VcgAnClp;
import gov.va.caret.model.VcgClp;
import gov.va.caret.model.VendrClp;
import gov.va.caret.model.VetVrClp;
import gov.va.caret.model.WaivrClp;
import gov.va.caret.model.WorImClp;
import gov.va.caret.model.ZipFyClp;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import java.lang.reflect.Method;

import java.util.ArrayList;
import java.util.List;


public class ClpSerializer {
    private static Log _log = LogFactoryUtil.getLog(ClpSerializer.class);
    private static String _servletContextName;
    private static boolean _useReflectionToTranslateThrowable = true;

    public static String getServletContextName() {
        if (Validator.isNotNull(_servletContextName)) {
            return _servletContextName;
        }

        synchronized (ClpSerializer.class) {
            if (Validator.isNotNull(_servletContextName)) {
                return _servletContextName;
            }

            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Class<?> portletPropsClass = classLoader.loadClass(
                        "com.liferay.util.portlet.PortletProps");

                Method getMethod = portletPropsClass.getMethod("get",
                        new Class<?>[] { String.class });

                String portletPropsServletContextName = (String) getMethod.invoke(null,
                        "caret-portlet-deployment-context");

                if (Validator.isNotNull(portletPropsServletContextName)) {
                    _servletContextName = portletPropsServletContextName;
                }
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info(
                        "Unable to locate deployment context from portlet properties");
                }
            }

            if (Validator.isNull(_servletContextName)) {
                try {
                    String propsUtilServletContextName = PropsUtil.get(
                            "caret-portlet-deployment-context");

                    if (Validator.isNotNull(propsUtilServletContextName)) {
                        _servletContextName = propsUtilServletContextName;
                    }
                } catch (Throwable t) {
                    if (_log.isInfoEnabled()) {
                        _log.info(
                            "Unable to locate deployment context from portal properties");
                    }
                }
            }

            if (Validator.isNull(_servletContextName)) {
                _servletContextName = "caret-portlet";
            }

            return _servletContextName;
        }
    }

    public static Object translateInput(BaseModel<?> oldModel) {
        Class<?> oldModelClass = oldModel.getClass();

        String oldModelClassName = oldModelClass.getName();

        if (oldModelClassName.equals(AssmtClp.class.getName())) {
            return translateInputAssmt(oldModel);
        }

        if (oldModelClassName.equals(AudLgClp.class.getName())) {
            return translateInputAudLg(oldModel);
        }

        if (oldModelClassName.equals(BgAsnClp.class.getName())) {
            return translateInputBgAsn(oldModel);
        }

        if (oldModelClassName.equals(BgLaeClp.class.getName())) {
            return translateInputBgLae(oldModel);
        }

        if (oldModelClassName.equals(BgNumClp.class.getName())) {
            return translateInputBgNum(oldModel);
        }

        if (oldModelClassName.equals(BlsAeClp.class.getName())) {
            return translateInputBlsAe(oldModel);
        }

        if (oldModelClassName.equals(BlsReClp.class.getName())) {
            return translateInputBlsRe(oldModel);
        }

        if (oldModelClassName.equals(BoxGpClp.class.getName())) {
            return translateInputBoxGp(oldModel);
        }

        if (oldModelClassName.equals(CalEtClp.class.getName())) {
            return translateInputCalEt(oldModel);
        }

        if (oldModelClassName.equals(CallClp.class.getName())) {
            return translateInputCall(oldModel);
        }

        if (oldModelClassName.equals(CespClp.class.getName())) {
            return translateInputCesp(oldModel);
        }

        if (oldModelClassName.equals(ClSocClp.class.getName())) {
            return translateInputClSoc(oldModel);
        }

        if (oldModelClassName.equals(CryptoClp.class.getName())) {
            return translateInputCrypto(oldModel);
        }

        if (oldModelClassName.equals(DocumClp.class.getName())) {
            return translateInputDocum(oldModel);
        }

        if (oldModelClassName.equals(FacilClp.class.getName())) {
            return translateInputFacil(oldModel);
        }

        if (oldModelClassName.equals(NoteClp.class.getName())) {
            return translateInputNote(oldModel);
        }

        if (oldModelClassName.equals(NotifClp.class.getName())) {
            return translateInputNotif(oldModel);
        }

        if (oldModelClassName.equals(PayLgClp.class.getName())) {
            return translateInputPayLg(oldModel);
        }

        if (oldModelClassName.equals(PersnClp.class.getName())) {
            return translateInputPersn(oldModel);
        }

        if (oldModelClassName.equals(PMDeletedMessageClp.class.getName())) {
            return translateInputPMDeletedMessage(oldModel);
        }

        if (oldModelClassName.equals(PMMessageClp.class.getName())) {
            return translateInputPMMessage(oldModel);
        }

        if (oldModelClassName.equals(PMReadMessageClp.class.getName())) {
            return translateInputPMReadMessage(oldModel);
        }

        if (oldModelClassName.equals(StiPtClp.class.getName())) {
            return translateInputStiPt(oldModel);
        }

        if (oldModelClassName.equals(StiRdClp.class.getName())) {
            return translateInputStiRd(oldModel);
        }

        if (oldModelClassName.equals(VcgClp.class.getName())) {
            return translateInputVcg(oldModel);
        }

        if (oldModelClassName.equals(VcgAnClp.class.getName())) {
            return translateInputVcgAn(oldModel);
        }

        if (oldModelClassName.equals(VendrClp.class.getName())) {
            return translateInputVendr(oldModel);
        }

        if (oldModelClassName.equals(VetVrClp.class.getName())) {
            return translateInputVetVr(oldModel);
        }

        if (oldModelClassName.equals(WaivrClp.class.getName())) {
            return translateInputWaivr(oldModel);
        }

        if (oldModelClassName.equals(WorImClp.class.getName())) {
            return translateInputWorIm(oldModel);
        }

        if (oldModelClassName.equals(ZipFyClp.class.getName())) {
            return translateInputZipFy(oldModel);
        }

        return oldModel;
    }

    public static Object translateInput(List<Object> oldList) {
        List<Object> newList = new ArrayList<Object>(oldList.size());

        for (int i = 0; i < oldList.size(); i++) {
            Object curObj = oldList.get(i);

            newList.add(translateInput(curObj));
        }

        return newList;
    }

    public static Object translateInputAssmt(BaseModel<?> oldModel) {
        AssmtClp oldClpModel = (AssmtClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getAssmtRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputAudLg(BaseModel<?> oldModel) {
        AudLgClp oldClpModel = (AudLgClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getAudLgRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputBgAsn(BaseModel<?> oldModel) {
        BgAsnClp oldClpModel = (BgAsnClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getBgAsnRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputBgLae(BaseModel<?> oldModel) {
        BgLaeClp oldClpModel = (BgLaeClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getBgLaeRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputBgNum(BaseModel<?> oldModel) {
        BgNumClp oldClpModel = (BgNumClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getBgNumRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputBlsAe(BaseModel<?> oldModel) {
        BlsAeClp oldClpModel = (BlsAeClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getBlsAeRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputBlsRe(BaseModel<?> oldModel) {
        BlsReClp oldClpModel = (BlsReClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getBlsReRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputBoxGp(BaseModel<?> oldModel) {
        BoxGpClp oldClpModel = (BoxGpClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getBoxGpRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputCalEt(BaseModel<?> oldModel) {
        CalEtClp oldClpModel = (CalEtClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getCalEtRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputCall(BaseModel<?> oldModel) {
        CallClp oldClpModel = (CallClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getCallRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputCesp(BaseModel<?> oldModel) {
        CespClp oldClpModel = (CespClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getCespRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputClSoc(BaseModel<?> oldModel) {
        ClSocClp oldClpModel = (ClSocClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getClSocRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputCrypto(BaseModel<?> oldModel) {
        CryptoClp oldClpModel = (CryptoClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getCryptoRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputDocum(BaseModel<?> oldModel) {
        DocumClp oldClpModel = (DocumClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getDocumRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputFacil(BaseModel<?> oldModel) {
        FacilClp oldClpModel = (FacilClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getFacilRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputNote(BaseModel<?> oldModel) {
        NoteClp oldClpModel = (NoteClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getNoteRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputNotif(BaseModel<?> oldModel) {
        NotifClp oldClpModel = (NotifClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getNotifRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputPayLg(BaseModel<?> oldModel) {
        PayLgClp oldClpModel = (PayLgClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getPayLgRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputPersn(BaseModel<?> oldModel) {
        PersnClp oldClpModel = (PersnClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getPersnRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputPMDeletedMessage(BaseModel<?> oldModel) {
        PMDeletedMessageClp oldClpModel = (PMDeletedMessageClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getPMDeletedMessageRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputPMMessage(BaseModel<?> oldModel) {
        PMMessageClp oldClpModel = (PMMessageClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getPMMessageRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputPMReadMessage(BaseModel<?> oldModel) {
        PMReadMessageClp oldClpModel = (PMReadMessageClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getPMReadMessageRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputStiPt(BaseModel<?> oldModel) {
        StiPtClp oldClpModel = (StiPtClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getStiPtRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputStiRd(BaseModel<?> oldModel) {
        StiRdClp oldClpModel = (StiRdClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getStiRdRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputVcg(BaseModel<?> oldModel) {
        VcgClp oldClpModel = (VcgClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getVcgRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputVcgAn(BaseModel<?> oldModel) {
        VcgAnClp oldClpModel = (VcgAnClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getVcgAnRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputVendr(BaseModel<?> oldModel) {
        VendrClp oldClpModel = (VendrClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getVendrRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputVetVr(BaseModel<?> oldModel) {
        VetVrClp oldClpModel = (VetVrClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getVetVrRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputWaivr(BaseModel<?> oldModel) {
        WaivrClp oldClpModel = (WaivrClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getWaivrRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputWorIm(BaseModel<?> oldModel) {
        WorImClp oldClpModel = (WorImClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getWorImRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInputZipFy(BaseModel<?> oldModel) {
        ZipFyClp oldClpModel = (ZipFyClp) oldModel;

        BaseModel<?> newModel = oldClpModel.getZipFyRemoteModel();

        newModel.setModelAttributes(oldClpModel.getModelAttributes());

        return newModel;
    }

    public static Object translateInput(Object obj) {
        if (obj instanceof BaseModel<?>) {
            return translateInput((BaseModel<?>) obj);
        } else if (obj instanceof List<?>) {
            return translateInput((List<Object>) obj);
        } else {
            return obj;
        }
    }

    public static Object translateOutput(BaseModel<?> oldModel) {
        Class<?> oldModelClass = oldModel.getClass();

        String oldModelClassName = oldModelClass.getName();

        if (oldModelClassName.equals("gov.va.caret.model.impl.AssmtImpl")) {
            return translateOutputAssmt(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.AudLgImpl")) {
            return translateOutputAudLg(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.BgAsnImpl")) {
            return translateOutputBgAsn(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.BgLaeImpl")) {
            return translateOutputBgLae(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.BgNumImpl")) {
            return translateOutputBgNum(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.BlsAeImpl")) {
            return translateOutputBlsAe(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.BlsReImpl")) {
            return translateOutputBlsRe(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.BoxGpImpl")) {
            return translateOutputBoxGp(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.CalEtImpl")) {
            return translateOutputCalEt(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.CallImpl")) {
            return translateOutputCall(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.CespImpl")) {
            return translateOutputCesp(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.ClSocImpl")) {
            return translateOutputClSoc(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.CryptoImpl")) {
            return translateOutputCrypto(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.DocumImpl")) {
            return translateOutputDocum(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.FacilImpl")) {
            return translateOutputFacil(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.NoteImpl")) {
            return translateOutputNote(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.NotifImpl")) {
            return translateOutputNotif(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.PayLgImpl")) {
            return translateOutputPayLg(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.PersnImpl")) {
            return translateOutputPersn(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals(
                    "gov.va.caret.model.impl.PMDeletedMessageImpl")) {
            return translateOutputPMDeletedMessage(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.PMMessageImpl")) {
            return translateOutputPMMessage(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals(
                    "gov.va.caret.model.impl.PMReadMessageImpl")) {
            return translateOutputPMReadMessage(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.StiPtImpl")) {
            return translateOutputStiPt(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.StiRdImpl")) {
            return translateOutputStiRd(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.VcgImpl")) {
            return translateOutputVcg(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.VcgAnImpl")) {
            return translateOutputVcgAn(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.VendrImpl")) {
            return translateOutputVendr(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.VetVrImpl")) {
            return translateOutputVetVr(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.WaivrImpl")) {
            return translateOutputWaivr(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.WorImImpl")) {
            return translateOutputWorIm(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        if (oldModelClassName.equals("gov.va.caret.model.impl.ZipFyImpl")) {
            return translateOutputZipFy(oldModel);
        } else if (oldModelClassName.endsWith("Clp")) {
            try {
                ClassLoader classLoader = ClpSerializer.class.getClassLoader();

                Method getClpSerializerClassMethod = oldModelClass.getMethod(
                        "getClpSerializerClass");

                Class<?> oldClpSerializerClass = (Class<?>) getClpSerializerClassMethod.invoke(oldModel);

                Class<?> newClpSerializerClass = classLoader.loadClass(oldClpSerializerClass.getName());

                Method translateOutputMethod = newClpSerializerClass.getMethod("translateOutput",
                        BaseModel.class);

                Class<?> oldModelModelClass = oldModel.getModelClass();

                Method getRemoteModelMethod = oldModelClass.getMethod("get" +
                        oldModelModelClass.getSimpleName() + "RemoteModel");

                Object oldRemoteModel = getRemoteModelMethod.invoke(oldModel);

                BaseModel<?> newModel = (BaseModel<?>) translateOutputMethod.invoke(null,
                        oldRemoteModel);

                return newModel;
            } catch (Throwable t) {
                if (_log.isInfoEnabled()) {
                    _log.info("Unable to translate " + oldModelClassName, t);
                }
            }
        }

        return oldModel;
    }

    public static Object translateOutput(List<Object> oldList) {
        List<Object> newList = new ArrayList<Object>(oldList.size());

        for (int i = 0; i < oldList.size(); i++) {
            Object curObj = oldList.get(i);

            newList.add(translateOutput(curObj));
        }

        return newList;
    }

    public static Object translateOutput(Object obj) {
        if (obj instanceof BaseModel<?>) {
            return translateOutput((BaseModel<?>) obj);
        } else if (obj instanceof List<?>) {
            return translateOutput((List<Object>) obj);
        } else {
            return obj;
        }
    }

    public static Throwable translateThrowable(Throwable throwable) {
        if (_useReflectionToTranslateThrowable) {
            try {
                UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(unsyncByteArrayOutputStream);

                objectOutputStream.writeObject(throwable);

                objectOutputStream.flush();
                objectOutputStream.close();

                UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(unsyncByteArrayOutputStream.unsafeGetByteArray(),
                        0, unsyncByteArrayOutputStream.size());

                Thread currentThread = Thread.currentThread();

                ClassLoader contextClassLoader = currentThread.getContextClassLoader();

                ObjectInputStream objectInputStream = new ClassLoaderObjectInputStream(unsyncByteArrayInputStream,
                        contextClassLoader);

                throwable = (Throwable) objectInputStream.readObject();

                objectInputStream.close();

                return throwable;
            } catch (SecurityException se) {
                if (_log.isInfoEnabled()) {
                    _log.info("Do not use reflection to translate throwable");
                }

                _useReflectionToTranslateThrowable = false;
            } catch (Throwable throwable2) {
                _log.error(throwable2, throwable2);

                return throwable2;
            }
        }

        Class<?> clazz = throwable.getClass();

        String className = clazz.getName();

        if (className.equals(PortalException.class.getName())) {
            return new PortalException();
        }

        if (className.equals(SystemException.class.getName())) {
            return new SystemException();
        }

        if (className.equals("gov.va.caret.ApplicationWorkFlowException")) {
            return new gov.va.caret.ApplicationWorkFlowException();
        }

        if (className.equals("gov.va.caret.NoSuchAssmtException")) {
            return new gov.va.caret.NoSuchAssmtException();
        }

        if (className.equals("gov.va.caret.NoSuchAudLgException")) {
            return new gov.va.caret.NoSuchAudLgException();
        }

        if (className.equals("gov.va.caret.NoSuchBgAsnException")) {
            return new gov.va.caret.NoSuchBgAsnException();
        }

        if (className.equals("gov.va.caret.NoSuchBgLaeException")) {
            return new gov.va.caret.NoSuchBgLaeException();
        }

        if (className.equals("gov.va.caret.NoSuchBgNumException")) {
            return new gov.va.caret.NoSuchBgNumException();
        }

        if (className.equals("gov.va.caret.NoSuchBlsAeException")) {
            return new gov.va.caret.NoSuchBlsAeException();
        }

        if (className.equals("gov.va.caret.NoSuchBlsReException")) {
            return new gov.va.caret.NoSuchBlsReException();
        }

        if (className.equals("gov.va.caret.NoSuchBoxGpException")) {
            return new gov.va.caret.NoSuchBoxGpException();
        }

        if (className.equals("gov.va.caret.NoSuchCalEtException")) {
            return new gov.va.caret.NoSuchCalEtException();
        }

        if (className.equals("gov.va.caret.NoSuchCallException")) {
            return new gov.va.caret.NoSuchCallException();
        }

        if (className.equals("gov.va.caret.NoSuchCespException")) {
            return new gov.va.caret.NoSuchCespException();
        }

        if (className.equals("gov.va.caret.NoSuchClSocException")) {
            return new gov.va.caret.NoSuchClSocException();
        }

        if (className.equals("gov.va.caret.NoSuchCryptoException")) {
            return new gov.va.caret.NoSuchCryptoException();
        }

        if (className.equals("gov.va.caret.NoSuchDocumException")) {
            return new gov.va.caret.NoSuchDocumException();
        }

        if (className.equals("gov.va.caret.NoSuchFacilException")) {
            return new gov.va.caret.NoSuchFacilException();
        }

        if (className.equals("gov.va.caret.NoSuchNoteException")) {
            return new gov.va.caret.NoSuchNoteException();
        }

        if (className.equals("gov.va.caret.NoSuchNotifException")) {
            return new gov.va.caret.NoSuchNotifException();
        }

        if (className.equals("gov.va.caret.NoSuchPayLgException")) {
            return new gov.va.caret.NoSuchPayLgException();
        }

        if (className.equals("gov.va.caret.NoSuchPersnException")) {
            return new gov.va.caret.NoSuchPersnException();
        }

        if (className.equals("gov.va.caret.NoSuchPMDeletedMessageException")) {
            return new gov.va.caret.NoSuchPMDeletedMessageException();
        }

        if (className.equals("gov.va.caret.NoSuchPMMessageException")) {
            return new gov.va.caret.NoSuchPMMessageException();
        }

        if (className.equals("gov.va.caret.NoSuchPMReadMessageException")) {
            return new gov.va.caret.NoSuchPMReadMessageException();
        }

        if (className.equals("gov.va.caret.NoSuchStiPtException")) {
            return new gov.va.caret.NoSuchStiPtException();
        }

        if (className.equals("gov.va.caret.NoSuchStiRdException")) {
            return new gov.va.caret.NoSuchStiRdException();
        }

        if (className.equals("gov.va.caret.NoSuchVcgException")) {
            return new gov.va.caret.NoSuchVcgException();
        }

        if (className.equals("gov.va.caret.NoSuchVcgAnException")) {
            return new gov.va.caret.NoSuchVcgAnException();
        }

        if (className.equals("gov.va.caret.NoSuchVendrException")) {
            return new gov.va.caret.NoSuchVendrException();
        }

        if (className.equals("gov.va.caret.NoSuchVetVrException")) {
            return new gov.va.caret.NoSuchVetVrException();
        }

        if (className.equals("gov.va.caret.NoSuchWaivrException")) {
            return new gov.va.caret.NoSuchWaivrException();
        }

        if (className.equals("gov.va.caret.NoSuchWorImException")) {
            return new gov.va.caret.NoSuchWorImException();
        }

        if (className.equals("gov.va.caret.NoSuchZipFyException")) {
            return new gov.va.caret.NoSuchZipFyException();
        }

        return throwable;
    }

    public static Object translateOutputAssmt(BaseModel<?> oldModel) {
        AssmtClp newModel = new AssmtClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setAssmtRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputAudLg(BaseModel<?> oldModel) {
        AudLgClp newModel = new AudLgClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setAudLgRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputBgAsn(BaseModel<?> oldModel) {
        BgAsnClp newModel = new BgAsnClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setBgAsnRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputBgLae(BaseModel<?> oldModel) {
        BgLaeClp newModel = new BgLaeClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setBgLaeRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputBgNum(BaseModel<?> oldModel) {
        BgNumClp newModel = new BgNumClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setBgNumRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputBlsAe(BaseModel<?> oldModel) {
        BlsAeClp newModel = new BlsAeClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setBlsAeRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputBlsRe(BaseModel<?> oldModel) {
        BlsReClp newModel = new BlsReClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setBlsReRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputBoxGp(BaseModel<?> oldModel) {
        BoxGpClp newModel = new BoxGpClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setBoxGpRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputCalEt(BaseModel<?> oldModel) {
        CalEtClp newModel = new CalEtClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setCalEtRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputCall(BaseModel<?> oldModel) {
        CallClp newModel = new CallClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setCallRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputCesp(BaseModel<?> oldModel) {
        CespClp newModel = new CespClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setCespRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputClSoc(BaseModel<?> oldModel) {
        ClSocClp newModel = new ClSocClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setClSocRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputCrypto(BaseModel<?> oldModel) {
        CryptoClp newModel = new CryptoClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setCryptoRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputDocum(BaseModel<?> oldModel) {
        DocumClp newModel = new DocumClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setDocumRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputFacil(BaseModel<?> oldModel) {
        FacilClp newModel = new FacilClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setFacilRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputNote(BaseModel<?> oldModel) {
        NoteClp newModel = new NoteClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setNoteRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputNotif(BaseModel<?> oldModel) {
        NotifClp newModel = new NotifClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setNotifRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputPayLg(BaseModel<?> oldModel) {
        PayLgClp newModel = new PayLgClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setPayLgRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputPersn(BaseModel<?> oldModel) {
        PersnClp newModel = new PersnClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setPersnRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputPMDeletedMessage(BaseModel<?> oldModel) {
        PMDeletedMessageClp newModel = new PMDeletedMessageClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setPMDeletedMessageRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputPMMessage(BaseModel<?> oldModel) {
        PMMessageClp newModel = new PMMessageClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setPMMessageRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputPMReadMessage(BaseModel<?> oldModel) {
        PMReadMessageClp newModel = new PMReadMessageClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setPMReadMessageRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputStiPt(BaseModel<?> oldModel) {
        StiPtClp newModel = new StiPtClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setStiPtRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputStiRd(BaseModel<?> oldModel) {
        StiRdClp newModel = new StiRdClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setStiRdRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputVcg(BaseModel<?> oldModel) {
        VcgClp newModel = new VcgClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setVcgRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputVcgAn(BaseModel<?> oldModel) {
        VcgAnClp newModel = new VcgAnClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setVcgAnRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputVendr(BaseModel<?> oldModel) {
        VendrClp newModel = new VendrClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setVendrRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputVetVr(BaseModel<?> oldModel) {
        VetVrClp newModel = new VetVrClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setVetVrRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputWaivr(BaseModel<?> oldModel) {
        WaivrClp newModel = new WaivrClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setWaivrRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputWorIm(BaseModel<?> oldModel) {
        WorImClp newModel = new WorImClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setWorImRemoteModel(oldModel);

        return newModel;
    }

    public static Object translateOutputZipFy(BaseModel<?> oldModel) {
        ZipFyClp newModel = new ZipFyClp();

        newModel.setModelAttributes(oldModel.getModelAttributes());

        newModel.setZipFyRemoteModel(oldModel);

        return newModel;
    }
}
