package gov.va.caret.service;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.InvokableLocalService;

/**
 * Provides the local service utility for Caret. This utility wraps
 * {@link gov.va.caret.service.impl.CaretLocalServiceImpl} and is the
 * primary access point for service operations in application layer code running
 * on the local server. Methods of this service will not have security checks
 * based on the propagated JAAS credentials because this service can only be
 * accessed from within the same VM.
 *
 * @author caret
 * @see CaretLocalService
 * @see gov.va.caret.service.base.CaretLocalServiceBaseImpl
 * @see gov.va.caret.service.impl.CaretLocalServiceImpl
 * @generated
 */
public class CaretLocalServiceUtil {
    private static CaretLocalService _service;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Add custom service methods to {@link gov.va.caret.service.impl.CaretLocalServiceImpl} and rerun ServiceBuilder to regenerate this class.
     */

    /**
    * Returns the Spring bean ID for this bean.
    *
    * @return the Spring bean ID for this bean
    */
    public static java.lang.String getBeanIdentifier() {
        return getService().getBeanIdentifier();
    }

    /**
    * Sets the Spring bean ID for this bean.
    *
    * @param beanIdentifier the Spring bean ID for this bean
    */
    public static void setBeanIdentifier(java.lang.String beanIdentifier) {
        getService().setBeanIdentifier(beanIdentifier);
    }

    public static java.lang.Object invokeMethod(java.lang.String name,
        java.lang.String[] parameterTypes, java.lang.Object[] arguments)
        throws java.lang.Throwable {
        return getService().invokeMethod(name, parameterTypes, arguments);
    }

    public static int getReportCount(java.lang.String name,
        java.lang.Object entries)
        throws gov.va.caret.ApplicationWorkFlowException {
        return getService().getReportCount(name, entries);
    }

    public static java.util.List<java.util.Map<java.lang.String, java.lang.Object>> getReport(
        java.lang.String name, java.lang.Object entries)
        throws gov.va.caret.ApplicationWorkFlowException {
        return getService().getReport(name, entries);
    }

    public static java.util.List<java.util.Map<java.lang.String, java.lang.Object>> getReport(
        java.lang.String name, java.lang.Object entries, int start, int end)
        throws gov.va.caret.ApplicationWorkFlowException {
        return getService().getReport(name, entries, start, end);
    }

    public static java.util.List<java.util.Map<java.lang.String, java.lang.Object>> getReport(
        java.lang.String name, java.lang.Object entries,
        java.lang.String column, boolean desc, int start, int end)
        throws gov.va.caret.ApplicationWorkFlowException {
        return getService().getReport(name, entries, column, desc, start, end);
    }

    public static com.liferay.portal.model.BaseModel<?> save(
        com.liferay.portal.model.BaseModel<?> model)
        throws gov.va.caret.ApplicationWorkFlowException {
        return getService().save(model);
    }

    public static gov.va.caret.model.Note addNote(gov.va.caret.model.Note note)
        throws gov.va.caret.ApplicationWorkFlowException {
        return getService().addNote(note);
    }

    public static gov.va.caret.model.Facil getFacilityByNumber(
        java.lang.String facilityNumber)
        throws gov.va.caret.ApplicationWorkFlowException {
        return getService().getFacilityByNumber(facilityNumber);
    }

    public static java.util.List<gov.va.caret.model.CalEt> getCallEvents(
        long callId) throws gov.va.caret.ApplicationWorkFlowException {
        return getService().getCallEvents(callId);
    }

    public static java.util.List<gov.va.caret.model.Assmt> getAssessments(
        long vcgId) throws gov.va.caret.ApplicationWorkFlowException {
        return getService().getAssessments(vcgId);
    }

    public static gov.va.caret.model.AudLg getAudLg(long classId, long classPk,
        java.lang.String attribute)
        throws gov.va.caret.ApplicationWorkFlowException {
        return getService().getAudLg(classId, classPk, attribute);
    }

    public static java.util.List<gov.va.caret.model.Docum> getByClass(
        long primaryKey, long classId, java.lang.String type)
        throws gov.va.caret.ApplicationWorkFlowException {
        return getService().getByClass(primaryKey, classId, type);
    }

    public static java.util.List<gov.va.caret.model.Docum> getByPrimaryKey(
        long primaryKey) throws gov.va.caret.ApplicationWorkFlowException {
        return getService().getByPrimaryKey(primaryKey);
    }

    public static gov.va.caret.model.Persn getPerson(long persnId)
        throws gov.va.caret.ApplicationWorkFlowException {
        return getService().getPerson(persnId);
    }

    public static gov.va.caret.model.VcgAn getPrimaryApp(long veteranId)
        throws gov.va.caret.ApplicationWorkFlowException {
        return getService().getPrimaryApp(veteranId);
    }

    public static java.util.List<gov.va.caret.model.BoxGp> getBoxGroups(
        java.lang.String name) throws gov.va.caret.ApplicationWorkFlowException {
        return getService().getBoxGroups(name);
    }

    public static java.util.List<gov.va.caret.model.BoxGp> getBoxGroups(
        java.lang.String boxGroup, java.lang.String boxSubGroup)
        throws gov.va.caret.ApplicationWorkFlowException {
        return getService().getBoxGroups(boxGroup, boxSubGroup);
    }

    public static java.util.List<gov.va.caret.model.BgAsn> getBoxGroupAssociations(
        long ownerId) throws gov.va.caret.ApplicationWorkFlowException {
        return getService().getBoxGroupAssociations(ownerId);
    }

    public static java.util.List<gov.va.caret.model.BgAsn> getBoxGroupAssociations(
        long ownerId, boolean enabled)
        throws gov.va.caret.ApplicationWorkFlowException {
        return getService().getBoxGroupAssociations(ownerId, enabled);
    }

    public static gov.va.caret.model.BgAsn getBoxGroupAssociation(
        long ownerId, long boxGpId)
        throws gov.va.caret.ApplicationWorkFlowException {
        return getService().getBoxGroupAssociation(ownerId, boxGpId);
    }

    public static void clearService() {
        _service = null;
    }

    public static CaretLocalService getService() {
        if (_service == null) {
            InvokableLocalService invokableLocalService = (InvokableLocalService) PortletBeanLocatorUtil.locate(ClpSerializer.getServletContextName(),
                    CaretLocalService.class.getName());

            if (invokableLocalService instanceof CaretLocalService) {
                _service = (CaretLocalService) invokableLocalService;
            } else {
                _service = new CaretLocalServiceClp(invokableLocalService);
            }

            ReferenceRegistry.registerReference(CaretLocalServiceUtil.class,
                "_service");
        }

        return _service;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setService(CaretLocalService service) {
    }
}
