package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link VetVr}.
 * </p>
 *
 * @author caret
 * @see VetVr
 * @generated
 */
public class VetVrWrapper implements VetVr, ModelWrapper<VetVr> {
    private VetVr _vetVr;

    public VetVrWrapper(VetVr vetVr) {
        _vetVr = vetVr;
    }

    @Override
    public Class<?> getModelClass() {
        return VetVr.class;
    }

    @Override
    public String getModelClassName() {
        return VetVr.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("vetVrId", getVetVrId());
        attributes.put("vendrId", getVendrId());
        attributes.put("cgId", getCgId());
        attributes.put("veteranId", getVeteranId());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long vetVrId = (Long) attributes.get("vetVrId");

        if (vetVrId != null) {
            setVetVrId(vetVrId);
        }

        Long vendrId = (Long) attributes.get("vendrId");

        if (vendrId != null) {
            setVendrId(vendrId);
        }

        Long cgId = (Long) attributes.get("cgId");

        if (cgId != null) {
            setCgId(cgId);
        }

        Long veteranId = (Long) attributes.get("veteranId");

        if (veteranId != null) {
            setVeteranId(veteranId);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    /**
    * Returns the primary key of this vet vr.
    *
    * @return the primary key of this vet vr
    */
    @Override
    public long getPrimaryKey() {
        return _vetVr.getPrimaryKey();
    }

    /**
    * Sets the primary key of this vet vr.
    *
    * @param primaryKey the primary key of this vet vr
    */
    @Override
    public void setPrimaryKey(long primaryKey) {
        _vetVr.setPrimaryKey(primaryKey);
    }

    /**
    * Returns the vet vr ID of this vet vr.
    *
    * @return the vet vr ID of this vet vr
    */
    @Override
    public long getVetVrId() {
        return _vetVr.getVetVrId();
    }

    /**
    * Sets the vet vr ID of this vet vr.
    *
    * @param vetVrId the vet vr ID of this vet vr
    */
    @Override
    public void setVetVrId(long vetVrId) {
        _vetVr.setVetVrId(vetVrId);
    }

    /**
    * Returns the vendr ID of this vet vr.
    *
    * @return the vendr ID of this vet vr
    */
    @Override
    public long getVendrId() {
        return _vetVr.getVendrId();
    }

    /**
    * Sets the vendr ID of this vet vr.
    *
    * @param vendrId the vendr ID of this vet vr
    */
    @Override
    public void setVendrId(long vendrId) {
        _vetVr.setVendrId(vendrId);
    }

    /**
    * Returns the cg ID of this vet vr.
    *
    * @return the cg ID of this vet vr
    */
    @Override
    public long getCgId() {
        return _vetVr.getCgId();
    }

    /**
    * Sets the cg ID of this vet vr.
    *
    * @param cgId the cg ID of this vet vr
    */
    @Override
    public void setCgId(long cgId) {
        _vetVr.setCgId(cgId);
    }

    /**
    * Returns the veteran ID of this vet vr.
    *
    * @return the veteran ID of this vet vr
    */
    @Override
    public long getVeteranId() {
        return _vetVr.getVeteranId();
    }

    /**
    * Sets the veteran ID of this vet vr.
    *
    * @param veteranId the veteran ID of this vet vr
    */
    @Override
    public void setVeteranId(long veteranId) {
        _vetVr.setVeteranId(veteranId);
    }

    /**
    * Returns the group ID of this vet vr.
    *
    * @return the group ID of this vet vr
    */
    @Override
    public long getGroupId() {
        return _vetVr.getGroupId();
    }

    /**
    * Sets the group ID of this vet vr.
    *
    * @param groupId the group ID of this vet vr
    */
    @Override
    public void setGroupId(long groupId) {
        _vetVr.setGroupId(groupId);
    }

    @Override
    public boolean isNew() {
        return _vetVr.isNew();
    }

    @Override
    public void setNew(boolean n) {
        _vetVr.setNew(n);
    }

    @Override
    public boolean isCachedModel() {
        return _vetVr.isCachedModel();
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        _vetVr.setCachedModel(cachedModel);
    }

    @Override
    public boolean isEscapedModel() {
        return _vetVr.isEscapedModel();
    }

    @Override
    public java.io.Serializable getPrimaryKeyObj() {
        return _vetVr.getPrimaryKeyObj();
    }

    @Override
    public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
        _vetVr.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
        return _vetVr.getExpandoBridge();
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.model.BaseModel<?> baseModel) {
        _vetVr.setExpandoBridgeAttributes(baseModel);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
        _vetVr.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.service.ServiceContext serviceContext) {
        _vetVr.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public java.lang.Object clone() {
        return new VetVrWrapper((VetVr) _vetVr.clone());
    }

    @Override
    public int compareTo(gov.va.caret.model.VetVr vetVr) {
        return _vetVr.compareTo(vetVr);
    }

    @Override
    public int hashCode() {
        return _vetVr.hashCode();
    }

    @Override
    public com.liferay.portal.model.CacheModel<gov.va.caret.model.VetVr> toCacheModel() {
        return _vetVr.toCacheModel();
    }

    @Override
    public gov.va.caret.model.VetVr toEscapedModel() {
        return new VetVrWrapper(_vetVr.toEscapedModel());
    }

    @Override
    public gov.va.caret.model.VetVr toUnescapedModel() {
        return new VetVrWrapper(_vetVr.toUnescapedModel());
    }

    @Override
    public java.lang.String toString() {
        return _vetVr.toString();
    }

    @Override
    public java.lang.String toXmlString() {
        return _vetVr.toXmlString();
    }

    @Override
    public void persist()
        throws com.liferay.portal.kernel.exception.SystemException {
        _vetVr.persist();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof VetVrWrapper)) {
            return false;
        }

        VetVrWrapper vetVrWrapper = (VetVrWrapper) obj;

        if (Validator.equals(_vetVr, vetVrWrapper._vetVr)) {
            return true;
        }

        return false;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
     */
    public VetVr getWrappedVetVr() {
        return _vetVr;
    }

    @Override
    public VetVr getWrappedModel() {
        return _vetVr;
    }

    @Override
    public void resetOriginalValues() {
        _vetVr.resetOriginalValues();
    }
}
