package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class VcgSoap implements Serializable {
    private long _vcgId;
    private long _veteranId;
    private String _status;
    private Date _assessCompletionDate;
    private Date _primaryTrainedDate;
    private Date _visitationDate;
    private long _primaryId;
    private long _secondaryId;
    private long _secondaryTwoId;
    private boolean _generalCaregiver;
    private String _primaryType;
    private String _secondaryType;
    private String _secondaryTwoType;
    private Date _primaryDispositionDate;
    private Date _secondaryDispositionDate;
    private Date _secondaryTwoDispositionDate;
    private int _tierLevel;
    private Date _tierEffectiveDate;
    private String _veteranDispReason;
    private String _primaryDispReason;
    private String _secondaryDispReason;
    private String _secondaryTwoDispReason;
    private Date _primaryRevocationDate;
    private Date _secondaryRevocationDate;
    private Date _secondaryTwoRevocationDate;
    private long _groupId;

    public VcgSoap() {
    }

    public static VcgSoap toSoapModel(Vcg model) {
        VcgSoap soapModel = new VcgSoap();

        soapModel.setVcgId(model.getVcgId());
        soapModel.setVeteranId(model.getVeteranId());
        soapModel.setStatus(model.getStatus());
        soapModel.setAssessCompletionDate(model.getAssessCompletionDate());
        soapModel.setPrimaryTrainedDate(model.getPrimaryTrainedDate());
        soapModel.setVisitationDate(model.getVisitationDate());
        soapModel.setPrimaryId(model.getPrimaryId());
        soapModel.setSecondaryId(model.getSecondaryId());
        soapModel.setSecondaryTwoId(model.getSecondaryTwoId());
        soapModel.setGeneralCaregiver(model.getGeneralCaregiver());
        soapModel.setPrimaryType(model.getPrimaryType());
        soapModel.setSecondaryType(model.getSecondaryType());
        soapModel.setSecondaryTwoType(model.getSecondaryTwoType());
        soapModel.setPrimaryDispositionDate(model.getPrimaryDispositionDate());
        soapModel.setSecondaryDispositionDate(model.getSecondaryDispositionDate());
        soapModel.setSecondaryTwoDispositionDate(model.getSecondaryTwoDispositionDate());
        soapModel.setTierLevel(model.getTierLevel());
        soapModel.setTierEffectiveDate(model.getTierEffectiveDate());
        soapModel.setVeteranDispReason(model.getVeteranDispReason());
        soapModel.setPrimaryDispReason(model.getPrimaryDispReason());
        soapModel.setSecondaryDispReason(model.getSecondaryDispReason());
        soapModel.setSecondaryTwoDispReason(model.getSecondaryTwoDispReason());
        soapModel.setPrimaryRevocationDate(model.getPrimaryRevocationDate());
        soapModel.setSecondaryRevocationDate(model.getSecondaryRevocationDate());
        soapModel.setSecondaryTwoRevocationDate(model.getSecondaryTwoRevocationDate());
        soapModel.setGroupId(model.getGroupId());

        return soapModel;
    }

    public static VcgSoap[] toSoapModels(Vcg[] models) {
        VcgSoap[] soapModels = new VcgSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static VcgSoap[][] toSoapModels(Vcg[][] models) {
        VcgSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new VcgSoap[models.length][models[0].length];
        } else {
            soapModels = new VcgSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static VcgSoap[] toSoapModels(List<Vcg> models) {
        List<VcgSoap> soapModels = new ArrayList<VcgSoap>(models.size());

        for (Vcg model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new VcgSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _vcgId;
    }

    public void setPrimaryKey(long pk) {
        setVcgId(pk);
    }

    public long getVcgId() {
        return _vcgId;
    }

    public void setVcgId(long vcgId) {
        _vcgId = vcgId;
    }

    public long getVeteranId() {
        return _veteranId;
    }

    public void setVeteranId(long veteranId) {
        _veteranId = veteranId;
    }

    public String getStatus() {
        return _status;
    }

    public void setStatus(String status) {
        _status = status;
    }

    public Date getAssessCompletionDate() {
        return _assessCompletionDate;
    }

    public void setAssessCompletionDate(Date assessCompletionDate) {
        _assessCompletionDate = assessCompletionDate;
    }

    public Date getPrimaryTrainedDate() {
        return _primaryTrainedDate;
    }

    public void setPrimaryTrainedDate(Date primaryTrainedDate) {
        _primaryTrainedDate = primaryTrainedDate;
    }

    public Date getVisitationDate() {
        return _visitationDate;
    }

    public void setVisitationDate(Date visitationDate) {
        _visitationDate = visitationDate;
    }

    public long getPrimaryId() {
        return _primaryId;
    }

    public void setPrimaryId(long primaryId) {
        _primaryId = primaryId;
    }

    public long getSecondaryId() {
        return _secondaryId;
    }

    public void setSecondaryId(long secondaryId) {
        _secondaryId = secondaryId;
    }

    public long getSecondaryTwoId() {
        return _secondaryTwoId;
    }

    public void setSecondaryTwoId(long secondaryTwoId) {
        _secondaryTwoId = secondaryTwoId;
    }

    public boolean getGeneralCaregiver() {
        return _generalCaregiver;
    }

    public boolean isGeneralCaregiver() {
        return _generalCaregiver;
    }

    public void setGeneralCaregiver(boolean generalCaregiver) {
        _generalCaregiver = generalCaregiver;
    }

    public String getPrimaryType() {
        return _primaryType;
    }

    public void setPrimaryType(String primaryType) {
        _primaryType = primaryType;
    }

    public String getSecondaryType() {
        return _secondaryType;
    }

    public void setSecondaryType(String secondaryType) {
        _secondaryType = secondaryType;
    }

    public String getSecondaryTwoType() {
        return _secondaryTwoType;
    }

    public void setSecondaryTwoType(String secondaryTwoType) {
        _secondaryTwoType = secondaryTwoType;
    }

    public Date getPrimaryDispositionDate() {
        return _primaryDispositionDate;
    }

    public void setPrimaryDispositionDate(Date primaryDispositionDate) {
        _primaryDispositionDate = primaryDispositionDate;
    }

    public Date getSecondaryDispositionDate() {
        return _secondaryDispositionDate;
    }

    public void setSecondaryDispositionDate(Date secondaryDispositionDate) {
        _secondaryDispositionDate = secondaryDispositionDate;
    }

    public Date getSecondaryTwoDispositionDate() {
        return _secondaryTwoDispositionDate;
    }

    public void setSecondaryTwoDispositionDate(Date secondaryTwoDispositionDate) {
        _secondaryTwoDispositionDate = secondaryTwoDispositionDate;
    }

    public int getTierLevel() {
        return _tierLevel;
    }

    public void setTierLevel(int tierLevel) {
        _tierLevel = tierLevel;
    }

    public Date getTierEffectiveDate() {
        return _tierEffectiveDate;
    }

    public void setTierEffectiveDate(Date tierEffectiveDate) {
        _tierEffectiveDate = tierEffectiveDate;
    }

    public String getVeteranDispReason() {
        return _veteranDispReason;
    }

    public void setVeteranDispReason(String veteranDispReason) {
        _veteranDispReason = veteranDispReason;
    }

    public String getPrimaryDispReason() {
        return _primaryDispReason;
    }

    public void setPrimaryDispReason(String primaryDispReason) {
        _primaryDispReason = primaryDispReason;
    }

    public String getSecondaryDispReason() {
        return _secondaryDispReason;
    }

    public void setSecondaryDispReason(String secondaryDispReason) {
        _secondaryDispReason = secondaryDispReason;
    }

    public String getSecondaryTwoDispReason() {
        return _secondaryTwoDispReason;
    }

    public void setSecondaryTwoDispReason(String secondaryTwoDispReason) {
        _secondaryTwoDispReason = secondaryTwoDispReason;
    }

    public Date getPrimaryRevocationDate() {
        return _primaryRevocationDate;
    }

    public void setPrimaryRevocationDate(Date primaryRevocationDate) {
        _primaryRevocationDate = primaryRevocationDate;
    }

    public Date getSecondaryRevocationDate() {
        return _secondaryRevocationDate;
    }

    public void setSecondaryRevocationDate(Date secondaryRevocationDate) {
        _secondaryRevocationDate = secondaryRevocationDate;
    }

    public Date getSecondaryTwoRevocationDate() {
        return _secondaryTwoRevocationDate;
    }

    public void setSecondaryTwoRevocationDate(Date secondaryTwoRevocationDate) {
        _secondaryTwoRevocationDate = secondaryTwoRevocationDate;
    }

    public long getGroupId() {
        return _groupId;
    }

    public void setGroupId(long groupId) {
        _groupId = groupId;
    }
}
