package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.VcgLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class VcgClp extends BaseModelImpl<Vcg> implements Vcg {
    private long _vcgId;
    private long _veteranId;
    private String _status;
    private Date _assessCompletionDate;
    private Date _primaryTrainedDate;
    private Date _visitationDate;
    private long _primaryId;
    private long _secondaryId;
    private long _secondaryTwoId;
    private boolean _generalCaregiver;
    private String _primaryType;
    private String _secondaryType;
    private String _secondaryTwoType;
    private Date _primaryDispositionDate;
    private Date _secondaryDispositionDate;
    private Date _secondaryTwoDispositionDate;
    private int _tierLevel;
    private Date _tierEffectiveDate;
    private String _veteranDispReason;
    private String _primaryDispReason;
    private String _secondaryDispReason;
    private String _secondaryTwoDispReason;
    private Date _primaryRevocationDate;
    private Date _secondaryRevocationDate;
    private Date _secondaryTwoRevocationDate;
    private long _groupId;
    private BaseModel<?> _vcgRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public VcgClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return Vcg.class;
    }

    @Override
    public String getModelClassName() {
        return Vcg.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _vcgId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setVcgId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _vcgId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("vcgId", getVcgId());
        attributes.put("veteranId", getVeteranId());
        attributes.put("status", getStatus());
        attributes.put("assessCompletionDate", getAssessCompletionDate());
        attributes.put("primaryTrainedDate", getPrimaryTrainedDate());
        attributes.put("visitationDate", getVisitationDate());
        attributes.put("primaryId", getPrimaryId());
        attributes.put("secondaryId", getSecondaryId());
        attributes.put("secondaryTwoId", getSecondaryTwoId());
        attributes.put("generalCaregiver", getGeneralCaregiver());
        attributes.put("primaryType", getPrimaryType());
        attributes.put("secondaryType", getSecondaryType());
        attributes.put("secondaryTwoType", getSecondaryTwoType());
        attributes.put("primaryDispositionDate", getPrimaryDispositionDate());
        attributes.put("secondaryDispositionDate", getSecondaryDispositionDate());
        attributes.put("secondaryTwoDispositionDate",
            getSecondaryTwoDispositionDate());
        attributes.put("tierLevel", getTierLevel());
        attributes.put("tierEffectiveDate", getTierEffectiveDate());
        attributes.put("veteranDispReason", getVeteranDispReason());
        attributes.put("primaryDispReason", getPrimaryDispReason());
        attributes.put("secondaryDispReason", getSecondaryDispReason());
        attributes.put("secondaryTwoDispReason", getSecondaryTwoDispReason());
        attributes.put("primaryRevocationDate", getPrimaryRevocationDate());
        attributes.put("secondaryRevocationDate", getSecondaryRevocationDate());
        attributes.put("secondaryTwoRevocationDate",
            getSecondaryTwoRevocationDate());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long vcgId = (Long) attributes.get("vcgId");

        if (vcgId != null) {
            setVcgId(vcgId);
        }

        Long veteranId = (Long) attributes.get("veteranId");

        if (veteranId != null) {
            setVeteranId(veteranId);
        }

        String status = (String) attributes.get("status");

        if (status != null) {
            setStatus(status);
        }

        Date assessCompletionDate = (Date) attributes.get(
                "assessCompletionDate");

        if (assessCompletionDate != null) {
            setAssessCompletionDate(assessCompletionDate);
        }

        Date primaryTrainedDate = (Date) attributes.get("primaryTrainedDate");

        if (primaryTrainedDate != null) {
            setPrimaryTrainedDate(primaryTrainedDate);
        }

        Date visitationDate = (Date) attributes.get("visitationDate");

        if (visitationDate != null) {
            setVisitationDate(visitationDate);
        }

        Long primaryId = (Long) attributes.get("primaryId");

        if (primaryId != null) {
            setPrimaryId(primaryId);
        }

        Long secondaryId = (Long) attributes.get("secondaryId");

        if (secondaryId != null) {
            setSecondaryId(secondaryId);
        }

        Long secondaryTwoId = (Long) attributes.get("secondaryTwoId");

        if (secondaryTwoId != null) {
            setSecondaryTwoId(secondaryTwoId);
        }

        Boolean generalCaregiver = (Boolean) attributes.get("generalCaregiver");

        if (generalCaregiver != null) {
            setGeneralCaregiver(generalCaregiver);
        }

        String primaryType = (String) attributes.get("primaryType");

        if (primaryType != null) {
            setPrimaryType(primaryType);
        }

        String secondaryType = (String) attributes.get("secondaryType");

        if (secondaryType != null) {
            setSecondaryType(secondaryType);
        }

        String secondaryTwoType = (String) attributes.get("secondaryTwoType");

        if (secondaryTwoType != null) {
            setSecondaryTwoType(secondaryTwoType);
        }

        Date primaryDispositionDate = (Date) attributes.get(
                "primaryDispositionDate");

        if (primaryDispositionDate != null) {
            setPrimaryDispositionDate(primaryDispositionDate);
        }

        Date secondaryDispositionDate = (Date) attributes.get(
                "secondaryDispositionDate");

        if (secondaryDispositionDate != null) {
            setSecondaryDispositionDate(secondaryDispositionDate);
        }

        Date secondaryTwoDispositionDate = (Date) attributes.get(
                "secondaryTwoDispositionDate");

        if (secondaryTwoDispositionDate != null) {
            setSecondaryTwoDispositionDate(secondaryTwoDispositionDate);
        }

        Integer tierLevel = (Integer) attributes.get("tierLevel");

        if (tierLevel != null) {
            setTierLevel(tierLevel);
        }

        Date tierEffectiveDate = (Date) attributes.get("tierEffectiveDate");

        if (tierEffectiveDate != null) {
            setTierEffectiveDate(tierEffectiveDate);
        }

        String veteranDispReason = (String) attributes.get("veteranDispReason");

        if (veteranDispReason != null) {
            setVeteranDispReason(veteranDispReason);
        }

        String primaryDispReason = (String) attributes.get("primaryDispReason");

        if (primaryDispReason != null) {
            setPrimaryDispReason(primaryDispReason);
        }

        String secondaryDispReason = (String) attributes.get(
                "secondaryDispReason");

        if (secondaryDispReason != null) {
            setSecondaryDispReason(secondaryDispReason);
        }

        String secondaryTwoDispReason = (String) attributes.get(
                "secondaryTwoDispReason");

        if (secondaryTwoDispReason != null) {
            setSecondaryTwoDispReason(secondaryTwoDispReason);
        }

        Date primaryRevocationDate = (Date) attributes.get(
                "primaryRevocationDate");

        if (primaryRevocationDate != null) {
            setPrimaryRevocationDate(primaryRevocationDate);
        }

        Date secondaryRevocationDate = (Date) attributes.get(
                "secondaryRevocationDate");

        if (secondaryRevocationDate != null) {
            setSecondaryRevocationDate(secondaryRevocationDate);
        }

        Date secondaryTwoRevocationDate = (Date) attributes.get(
                "secondaryTwoRevocationDate");

        if (secondaryTwoRevocationDate != null) {
            setSecondaryTwoRevocationDate(secondaryTwoRevocationDate);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    @Override
    public long getVcgId() {
        return _vcgId;
    }

    @Override
    public void setVcgId(long vcgId) {
        _vcgId = vcgId;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setVcgId", long.class);

                method.invoke(_vcgRemoteModel, vcgId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getVeteranId() {
        return _veteranId;
    }

    @Override
    public void setVeteranId(long veteranId) {
        _veteranId = veteranId;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setVeteranId", long.class);

                method.invoke(_vcgRemoteModel, veteranId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getStatus() {
        return _status;
    }

    @Override
    public void setStatus(String status) {
        _status = status;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setStatus", String.class);

                method.invoke(_vcgRemoteModel, status);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getAssessCompletionDate() {
        return _assessCompletionDate;
    }

    @Override
    public void setAssessCompletionDate(Date assessCompletionDate) {
        _assessCompletionDate = assessCompletionDate;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setAssessCompletionDate",
                        Date.class);

                method.invoke(_vcgRemoteModel, assessCompletionDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getPrimaryTrainedDate() {
        return _primaryTrainedDate;
    }

    @Override
    public void setPrimaryTrainedDate(Date primaryTrainedDate) {
        _primaryTrainedDate = primaryTrainedDate;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setPrimaryTrainedDate",
                        Date.class);

                method.invoke(_vcgRemoteModel, primaryTrainedDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getVisitationDate() {
        return _visitationDate;
    }

    @Override
    public void setVisitationDate(Date visitationDate) {
        _visitationDate = visitationDate;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setVisitationDate", Date.class);

                method.invoke(_vcgRemoteModel, visitationDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getPrimaryId() {
        return _primaryId;
    }

    @Override
    public void setPrimaryId(long primaryId) {
        _primaryId = primaryId;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setPrimaryId", long.class);

                method.invoke(_vcgRemoteModel, primaryId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getSecondaryId() {
        return _secondaryId;
    }

    @Override
    public void setSecondaryId(long secondaryId) {
        _secondaryId = secondaryId;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setSecondaryId", long.class);

                method.invoke(_vcgRemoteModel, secondaryId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getSecondaryTwoId() {
        return _secondaryTwoId;
    }

    @Override
    public void setSecondaryTwoId(long secondaryTwoId) {
        _secondaryTwoId = secondaryTwoId;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setSecondaryTwoId", long.class);

                method.invoke(_vcgRemoteModel, secondaryTwoId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public boolean getGeneralCaregiver() {
        return _generalCaregiver;
    }

    @Override
    public boolean isGeneralCaregiver() {
        return _generalCaregiver;
    }

    @Override
    public void setGeneralCaregiver(boolean generalCaregiver) {
        _generalCaregiver = generalCaregiver;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setGeneralCaregiver",
                        boolean.class);

                method.invoke(_vcgRemoteModel, generalCaregiver);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getPrimaryType() {
        return _primaryType;
    }

    @Override
    public void setPrimaryType(String primaryType) {
        _primaryType = primaryType;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setPrimaryType", String.class);

                method.invoke(_vcgRemoteModel, primaryType);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getSecondaryType() {
        return _secondaryType;
    }

    @Override
    public void setSecondaryType(String secondaryType) {
        _secondaryType = secondaryType;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setSecondaryType", String.class);

                method.invoke(_vcgRemoteModel, secondaryType);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getSecondaryTwoType() {
        return _secondaryTwoType;
    }

    @Override
    public void setSecondaryTwoType(String secondaryTwoType) {
        _secondaryTwoType = secondaryTwoType;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setSecondaryTwoType",
                        String.class);

                method.invoke(_vcgRemoteModel, secondaryTwoType);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getPrimaryDispositionDate() {
        return _primaryDispositionDate;
    }

    @Override
    public void setPrimaryDispositionDate(Date primaryDispositionDate) {
        _primaryDispositionDate = primaryDispositionDate;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setPrimaryDispositionDate",
                        Date.class);

                method.invoke(_vcgRemoteModel, primaryDispositionDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getSecondaryDispositionDate() {
        return _secondaryDispositionDate;
    }

    @Override
    public void setSecondaryDispositionDate(Date secondaryDispositionDate) {
        _secondaryDispositionDate = secondaryDispositionDate;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setSecondaryDispositionDate",
                        Date.class);

                method.invoke(_vcgRemoteModel, secondaryDispositionDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getSecondaryTwoDispositionDate() {
        return _secondaryTwoDispositionDate;
    }

    @Override
    public void setSecondaryTwoDispositionDate(Date secondaryTwoDispositionDate) {
        _secondaryTwoDispositionDate = secondaryTwoDispositionDate;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setSecondaryTwoDispositionDate",
                        Date.class);

                method.invoke(_vcgRemoteModel, secondaryTwoDispositionDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public int getTierLevel() {
        return _tierLevel;
    }

    @Override
    public void setTierLevel(int tierLevel) {
        _tierLevel = tierLevel;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setTierLevel", int.class);

                method.invoke(_vcgRemoteModel, tierLevel);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getTierEffectiveDate() {
        return _tierEffectiveDate;
    }

    @Override
    public void setTierEffectiveDate(Date tierEffectiveDate) {
        _tierEffectiveDate = tierEffectiveDate;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setTierEffectiveDate",
                        Date.class);

                method.invoke(_vcgRemoteModel, tierEffectiveDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getVeteranDispReason() {
        return _veteranDispReason;
    }

    @Override
    public void setVeteranDispReason(String veteranDispReason) {
        _veteranDispReason = veteranDispReason;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setVeteranDispReason",
                        String.class);

                method.invoke(_vcgRemoteModel, veteranDispReason);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getPrimaryDispReason() {
        return _primaryDispReason;
    }

    @Override
    public void setPrimaryDispReason(String primaryDispReason) {
        _primaryDispReason = primaryDispReason;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setPrimaryDispReason",
                        String.class);

                method.invoke(_vcgRemoteModel, primaryDispReason);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getSecondaryDispReason() {
        return _secondaryDispReason;
    }

    @Override
    public void setSecondaryDispReason(String secondaryDispReason) {
        _secondaryDispReason = secondaryDispReason;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setSecondaryDispReason",
                        String.class);

                method.invoke(_vcgRemoteModel, secondaryDispReason);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getSecondaryTwoDispReason() {
        return _secondaryTwoDispReason;
    }

    @Override
    public void setSecondaryTwoDispReason(String secondaryTwoDispReason) {
        _secondaryTwoDispReason = secondaryTwoDispReason;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setSecondaryTwoDispReason",
                        String.class);

                method.invoke(_vcgRemoteModel, secondaryTwoDispReason);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getPrimaryRevocationDate() {
        return _primaryRevocationDate;
    }

    @Override
    public void setPrimaryRevocationDate(Date primaryRevocationDate) {
        _primaryRevocationDate = primaryRevocationDate;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setPrimaryRevocationDate",
                        Date.class);

                method.invoke(_vcgRemoteModel, primaryRevocationDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getSecondaryRevocationDate() {
        return _secondaryRevocationDate;
    }

    @Override
    public void setSecondaryRevocationDate(Date secondaryRevocationDate) {
        _secondaryRevocationDate = secondaryRevocationDate;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setSecondaryRevocationDate",
                        Date.class);

                method.invoke(_vcgRemoteModel, secondaryRevocationDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getSecondaryTwoRevocationDate() {
        return _secondaryTwoRevocationDate;
    }

    @Override
    public void setSecondaryTwoRevocationDate(Date secondaryTwoRevocationDate) {
        _secondaryTwoRevocationDate = secondaryTwoRevocationDate;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setSecondaryTwoRevocationDate",
                        Date.class);

                method.invoke(_vcgRemoteModel, secondaryTwoRevocationDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;

        if (_vcgRemoteModel != null) {
            try {
                Class<?> clazz = _vcgRemoteModel.getClass();

                Method method = clazz.getMethod("setGroupId", long.class);

                method.invoke(_vcgRemoteModel, groupId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getVcgRemoteModel() {
        return _vcgRemoteModel;
    }

    public void setVcgRemoteModel(BaseModel<?> vcgRemoteModel) {
        _vcgRemoteModel = vcgRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _vcgRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_vcgRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            VcgLocalServiceUtil.addVcg(this);
        } else {
            VcgLocalServiceUtil.updateVcg(this);
        }
    }

    @Override
    public Vcg toEscapedModel() {
        return (Vcg) ProxyUtil.newProxyInstance(Vcg.class.getClassLoader(),
            new Class[] { Vcg.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        VcgClp clone = new VcgClp();

        clone.setVcgId(getVcgId());
        clone.setVeteranId(getVeteranId());
        clone.setStatus(getStatus());
        clone.setAssessCompletionDate(getAssessCompletionDate());
        clone.setPrimaryTrainedDate(getPrimaryTrainedDate());
        clone.setVisitationDate(getVisitationDate());
        clone.setPrimaryId(getPrimaryId());
        clone.setSecondaryId(getSecondaryId());
        clone.setSecondaryTwoId(getSecondaryTwoId());
        clone.setGeneralCaregiver(getGeneralCaregiver());
        clone.setPrimaryType(getPrimaryType());
        clone.setSecondaryType(getSecondaryType());
        clone.setSecondaryTwoType(getSecondaryTwoType());
        clone.setPrimaryDispositionDate(getPrimaryDispositionDate());
        clone.setSecondaryDispositionDate(getSecondaryDispositionDate());
        clone.setSecondaryTwoDispositionDate(getSecondaryTwoDispositionDate());
        clone.setTierLevel(getTierLevel());
        clone.setTierEffectiveDate(getTierEffectiveDate());
        clone.setVeteranDispReason(getVeteranDispReason());
        clone.setPrimaryDispReason(getPrimaryDispReason());
        clone.setSecondaryDispReason(getSecondaryDispReason());
        clone.setSecondaryTwoDispReason(getSecondaryTwoDispReason());
        clone.setPrimaryRevocationDate(getPrimaryRevocationDate());
        clone.setSecondaryRevocationDate(getSecondaryRevocationDate());
        clone.setSecondaryTwoRevocationDate(getSecondaryTwoRevocationDate());
        clone.setGroupId(getGroupId());

        return clone;
    }

    @Override
    public int compareTo(Vcg vcg) {
        long primaryKey = vcg.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof VcgClp)) {
            return false;
        }

        VcgClp vcg = (VcgClp) obj;

        long primaryKey = vcg.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(53);

        sb.append("{vcgId=");
        sb.append(getVcgId());
        sb.append(", veteranId=");
        sb.append(getVeteranId());
        sb.append(", status=");
        sb.append(getStatus());
        sb.append(", assessCompletionDate=");
        sb.append(getAssessCompletionDate());
        sb.append(", primaryTrainedDate=");
        sb.append(getPrimaryTrainedDate());
        sb.append(", visitationDate=");
        sb.append(getVisitationDate());
        sb.append(", primaryId=");
        sb.append(getPrimaryId());
        sb.append(", secondaryId=");
        sb.append(getSecondaryId());
        sb.append(", secondaryTwoId=");
        sb.append(getSecondaryTwoId());
        sb.append(", generalCaregiver=");
        sb.append(getGeneralCaregiver());
        sb.append(", primaryType=");
        sb.append(getPrimaryType());
        sb.append(", secondaryType=");
        sb.append(getSecondaryType());
        sb.append(", secondaryTwoType=");
        sb.append(getSecondaryTwoType());
        sb.append(", primaryDispositionDate=");
        sb.append(getPrimaryDispositionDate());
        sb.append(", secondaryDispositionDate=");
        sb.append(getSecondaryDispositionDate());
        sb.append(", secondaryTwoDispositionDate=");
        sb.append(getSecondaryTwoDispositionDate());
        sb.append(", tierLevel=");
        sb.append(getTierLevel());
        sb.append(", tierEffectiveDate=");
        sb.append(getTierEffectiveDate());
        sb.append(", veteranDispReason=");
        sb.append(getVeteranDispReason());
        sb.append(", primaryDispReason=");
        sb.append(getPrimaryDispReason());
        sb.append(", secondaryDispReason=");
        sb.append(getSecondaryDispReason());
        sb.append(", secondaryTwoDispReason=");
        sb.append(getSecondaryTwoDispReason());
        sb.append(", primaryRevocationDate=");
        sb.append(getPrimaryRevocationDate());
        sb.append(", secondaryRevocationDate=");
        sb.append(getSecondaryRevocationDate());
        sb.append(", secondaryTwoRevocationDate=");
        sb.append(getSecondaryTwoRevocationDate());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(82);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Vcg");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>vcgId</column-name><column-value><![CDATA[");
        sb.append(getVcgId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>veteranId</column-name><column-value><![CDATA[");
        sb.append(getVeteranId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>status</column-name><column-value><![CDATA[");
        sb.append(getStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>assessCompletionDate</column-name><column-value><![CDATA[");
        sb.append(getAssessCompletionDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>primaryTrainedDate</column-name><column-value><![CDATA[");
        sb.append(getPrimaryTrainedDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>visitationDate</column-name><column-value><![CDATA[");
        sb.append(getVisitationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>primaryId</column-name><column-value><![CDATA[");
        sb.append(getPrimaryId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryId</column-name><column-value><![CDATA[");
        sb.append(getSecondaryId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryTwoId</column-name><column-value><![CDATA[");
        sb.append(getSecondaryTwoId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>generalCaregiver</column-name><column-value><![CDATA[");
        sb.append(getGeneralCaregiver());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>primaryType</column-name><column-value><![CDATA[");
        sb.append(getPrimaryType());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryType</column-name><column-value><![CDATA[");
        sb.append(getSecondaryType());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryTwoType</column-name><column-value><![CDATA[");
        sb.append(getSecondaryTwoType());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>primaryDispositionDate</column-name><column-value><![CDATA[");
        sb.append(getPrimaryDispositionDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryDispositionDate</column-name><column-value><![CDATA[");
        sb.append(getSecondaryDispositionDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryTwoDispositionDate</column-name><column-value><![CDATA[");
        sb.append(getSecondaryTwoDispositionDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>tierLevel</column-name><column-value><![CDATA[");
        sb.append(getTierLevel());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>tierEffectiveDate</column-name><column-value><![CDATA[");
        sb.append(getTierEffectiveDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>veteranDispReason</column-name><column-value><![CDATA[");
        sb.append(getVeteranDispReason());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>primaryDispReason</column-name><column-value><![CDATA[");
        sb.append(getPrimaryDispReason());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryDispReason</column-name><column-value><![CDATA[");
        sb.append(getSecondaryDispReason());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryTwoDispReason</column-name><column-value><![CDATA[");
        sb.append(getSecondaryTwoDispReason());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>primaryRevocationDate</column-name><column-value><![CDATA[");
        sb.append(getPrimaryRevocationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryRevocationDate</column-name><column-value><![CDATA[");
        sb.append(getSecondaryRevocationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>secondaryTwoRevocationDate</column-name><column-value><![CDATA[");
        sb.append(getSecondaryTwoRevocationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
