package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the PayLg service. Represents a row in the &quot;CARET_PAYMENT_LOG&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.PayLgModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.PayLgImpl}.
 * </p>
 *
 * @author caret
 * @see PayLg
 * @see gov.va.caret.model.impl.PayLgImpl
 * @see gov.va.caret.model.impl.PayLgModelImpl
 * @generated
 */
public interface PayLgModel extends BaseModel<PayLg> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a pay lg model instance should use the {@link PayLg} interface instead.
     */

    /**
     * Returns the primary key of this pay lg.
     *
     * @return the primary key of this pay lg
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this pay lg.
     *
     * @param primaryKey the primary key of this pay lg
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the payment log ID of this pay lg.
     *
     * @return the payment log ID of this pay lg
     */
    public long getPaymentLogId();

    /**
     * Sets the payment log ID of this pay lg.
     *
     * @param paymentLogId the payment log ID of this pay lg
     */
    public void setPaymentLogId(long paymentLogId);

    /**
     * Returns the sti pt ID of this pay lg.
     *
     * @return the sti pt ID of this pay lg
     */
    public long getStiPtId();

    /**
     * Sets the sti pt ID of this pay lg.
     *
     * @param stiPtId the sti pt ID of this pay lg
     */
    public void setStiPtId(long stiPtId);

    /**
     * Returns the amount of this pay lg.
     *
     * @return the amount of this pay lg
     */
    public Double getAmount();

    /**
     * Sets the amount of this pay lg.
     *
     * @param amount the amount of this pay lg
     */
    public void setAmount(Double amount);

    /**
     * Returns the payment date of this pay lg.
     *
     * @return the payment date of this pay lg
     */
    public Date getPaymentDate();

    /**
     * Sets the payment date of this pay lg.
     *
     * @param paymentDate the payment date of this pay lg
     */
    public void setPaymentDate(Date paymentDate);

    /**
     * Returns the status of this pay lg.
     *
     * @return the status of this pay lg
     */
    @AutoEscape
    public String getStatus();

    /**
     * Sets the status of this pay lg.
     *
     * @param status the status of this pay lg
     */
    public void setStatus(String status);

    /**
     * Returns the reason of this pay lg.
     *
     * @return the reason of this pay lg
     */
    @AutoEscape
    public String getReason();

    /**
     * Sets the reason of this pay lg.
     *
     * @param reason the reason of this pay lg
     */
    public void setReason(String reason);

    /**
     * Returns the creation date of this pay lg.
     *
     * @return the creation date of this pay lg
     */
    public Date getCreationDate();

    /**
     * Sets the creation date of this pay lg.
     *
     * @param creationDate the creation date of this pay lg
     */
    public void setCreationDate(Date creationDate);

    /**
     * Returns the user ID of this pay lg.
     *
     * @return the user ID of this pay lg
     */
    public long getUserId();

    /**
     * Sets the user ID of this pay lg.
     *
     * @param userId the user ID of this pay lg
     */
    public void setUserId(long userId);

    /**
     * Returns the user uuid of this pay lg.
     *
     * @return the user uuid of this pay lg
     * @throws SystemException if a system exception occurred
     */
    public String getUserUuid() throws SystemException;

    /**
     * Sets the user uuid of this pay lg.
     *
     * @param userUuid the user uuid of this pay lg
     */
    public void setUserUuid(String userUuid);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.PayLg payLg);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.PayLg> toCacheModel();

    @Override
    public gov.va.caret.model.PayLg toEscapedModel();

    @Override
    public gov.va.caret.model.PayLg toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
