/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model;

import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the PMReadMessage service. Represents a row in the &quot;read_message&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.PMReadMessageModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.PMReadMessageImpl}.
 * </p>
 *
 * @author caret
 * @see PMReadMessage
 * @see gov.va.caret.model.impl.PMReadMessageImpl
 * @see gov.va.caret.model.impl.PMReadMessageModelImpl
 * @generated
 */
public interface PMReadMessageModel extends BaseModel<PMReadMessage> {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a p m read message model instance should use the {@link PMReadMessage} interface instead.
	 */

	/**
	 * Returns the primary key of this p m read message.
	 *
	 * @return the primary key of this p m read message
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this p m read message.
	 *
	 * @param primaryKey the primary key of this p m read message
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the read message ID of this p m read message.
	 *
	 * @return the read message ID of this p m read message
	 */
	public long getReadMessageId();

	/**
	 * Sets the read message ID of this p m read message.
	 *
	 * @param readMessageId the read message ID of this p m read message
	 */
	public void setReadMessageId(long readMessageId);

	/**
	 * Returns the message ID of this p m read message.
	 *
	 * @return the message ID of this p m read message
	 */
	public long getMessageId();

	/**
	 * Sets the message ID of this p m read message.
	 *
	 * @param messageId the message ID of this p m read message
	 */
	public void setMessageId(long messageId);

	/**
	 * Returns the read date of this p m read message.
	 *
	 * @return the read date of this p m read message
	 */
	public Date getReadDate();

	/**
	 * Sets the read date of this p m read message.
	 *
	 * @param readDate the read date of this p m read message
	 */
	public void setReadDate(Date readDate);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(gov.va.caret.model.PMReadMessage pmReadMessage);

	@Override
	public int hashCode();

	@Override
	public CacheModel<gov.va.caret.model.PMReadMessage> toCacheModel();

	@Override
	public gov.va.caret.model.PMReadMessage toEscapedModel();

	@Override
	public gov.va.caret.model.PMReadMessage toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();
}