/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link PMDeletedMessage}.
 * </p>
 *
 * @author caret
 * @see PMDeletedMessage
 * @generated
 */
public class PMDeletedMessageWrapper implements PMDeletedMessage,
	ModelWrapper<PMDeletedMessage> {
	public PMDeletedMessageWrapper(PMDeletedMessage pmDeletedMessage) {
		_pmDeletedMessage = pmDeletedMessage;
	}

	@Override
	public Class<?> getModelClass() {
		return PMDeletedMessage.class;
	}

	@Override
	public String getModelClassName() {
		return PMDeletedMessage.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("deletedMessageId", getDeletedMessageId());
		attributes.put("messageId", getMessageId());
		attributes.put("ownerId", getOwnerId());
		attributes.put("deletedDate", getDeletedDate());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long deletedMessageId = (Long)attributes.get("deletedMessageId");

		if (deletedMessageId != null) {
			setDeletedMessageId(deletedMessageId);
		}

		Long messageId = (Long)attributes.get("messageId");

		if (messageId != null) {
			setMessageId(messageId);
		}

		Long ownerId = (Long)attributes.get("ownerId");

		if (ownerId != null) {
			setOwnerId(ownerId);
		}

		Date deletedDate = (Date)attributes.get("deletedDate");

		if (deletedDate != null) {
			setDeletedDate(deletedDate);
		}
	}

	/**
	* Returns the primary key of this p m deleted message.
	*
	* @return the primary key of this p m deleted message
	*/
	@Override
	public long getPrimaryKey() {
		return _pmDeletedMessage.getPrimaryKey();
	}

	/**
	* Sets the primary key of this p m deleted message.
	*
	* @param primaryKey the primary key of this p m deleted message
	*/
	@Override
	public void setPrimaryKey(long primaryKey) {
		_pmDeletedMessage.setPrimaryKey(primaryKey);
	}

	/**
	* Returns the deleted message ID of this p m deleted message.
	*
	* @return the deleted message ID of this p m deleted message
	*/
	@Override
	public long getDeletedMessageId() {
		return _pmDeletedMessage.getDeletedMessageId();
	}

	/**
	* Sets the deleted message ID of this p m deleted message.
	*
	* @param deletedMessageId the deleted message ID of this p m deleted message
	*/
	@Override
	public void setDeletedMessageId(long deletedMessageId) {
		_pmDeletedMessage.setDeletedMessageId(deletedMessageId);
	}

	/**
	* Returns the message ID of this p m deleted message.
	*
	* @return the message ID of this p m deleted message
	*/
	@Override
	public long getMessageId() {
		return _pmDeletedMessage.getMessageId();
	}

	/**
	* Sets the message ID of this p m deleted message.
	*
	* @param messageId the message ID of this p m deleted message
	*/
	@Override
	public void setMessageId(long messageId) {
		_pmDeletedMessage.setMessageId(messageId);
	}

	/**
	* Returns the owner ID of this p m deleted message.
	*
	* @return the owner ID of this p m deleted message
	*/
	@Override
	public long getOwnerId() {
		return _pmDeletedMessage.getOwnerId();
	}

	/**
	* Sets the owner ID of this p m deleted message.
	*
	* @param ownerId the owner ID of this p m deleted message
	*/
	@Override
	public void setOwnerId(long ownerId) {
		_pmDeletedMessage.setOwnerId(ownerId);
	}

	/**
	* Returns the deleted date of this p m deleted message.
	*
	* @return the deleted date of this p m deleted message
	*/
	@Override
	public java.util.Date getDeletedDate() {
		return _pmDeletedMessage.getDeletedDate();
	}

	/**
	* Sets the deleted date of this p m deleted message.
	*
	* @param deletedDate the deleted date of this p m deleted message
	*/
	@Override
	public void setDeletedDate(java.util.Date deletedDate) {
		_pmDeletedMessage.setDeletedDate(deletedDate);
	}

	@Override
	public boolean isNew() {
		return _pmDeletedMessage.isNew();
	}

	@Override
	public void setNew(boolean n) {
		_pmDeletedMessage.setNew(n);
	}

	@Override
	public boolean isCachedModel() {
		return _pmDeletedMessage.isCachedModel();
	}

	@Override
	public void setCachedModel(boolean cachedModel) {
		_pmDeletedMessage.setCachedModel(cachedModel);
	}

	@Override
	public boolean isEscapedModel() {
		return _pmDeletedMessage.isEscapedModel();
	}

	@Override
	public java.io.Serializable getPrimaryKeyObj() {
		return _pmDeletedMessage.getPrimaryKeyObj();
	}

	@Override
	public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
		_pmDeletedMessage.setPrimaryKeyObj(primaryKeyObj);
	}

	@Override
	public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
		return _pmDeletedMessage.getExpandoBridge();
	}

	@Override
	public void setExpandoBridgeAttributes(
		com.liferay.portal.model.BaseModel<?> baseModel) {
		_pmDeletedMessage.setExpandoBridgeAttributes(baseModel);
	}

	@Override
	public void setExpandoBridgeAttributes(
		com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
		_pmDeletedMessage.setExpandoBridgeAttributes(expandoBridge);
	}

	@Override
	public void setExpandoBridgeAttributes(
		com.liferay.portal.service.ServiceContext serviceContext) {
		_pmDeletedMessage.setExpandoBridgeAttributes(serviceContext);
	}

	@Override
	public java.lang.Object clone() {
		return new PMDeletedMessageWrapper((PMDeletedMessage)_pmDeletedMessage.clone());
	}

	@Override
	public int compareTo(gov.va.caret.model.PMDeletedMessage pmDeletedMessage) {
		return _pmDeletedMessage.compareTo(pmDeletedMessage);
	}

	@Override
	public int hashCode() {
		return _pmDeletedMessage.hashCode();
	}

	@Override
	public com.liferay.portal.model.CacheModel<gov.va.caret.model.PMDeletedMessage> toCacheModel() {
		return _pmDeletedMessage.toCacheModel();
	}

	@Override
	public gov.va.caret.model.PMDeletedMessage toEscapedModel() {
		return new PMDeletedMessageWrapper(_pmDeletedMessage.toEscapedModel());
	}

	@Override
	public gov.va.caret.model.PMDeletedMessage toUnescapedModel() {
		return new PMDeletedMessageWrapper(_pmDeletedMessage.toUnescapedModel());
	}

	@Override
	public java.lang.String toString() {
		return _pmDeletedMessage.toString();
	}

	@Override
	public java.lang.String toXmlString() {
		return _pmDeletedMessage.toXmlString();
	}

	@Override
	public void persist()
		throws com.liferay.portal.kernel.exception.SystemException {
		_pmDeletedMessage.persist();
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof PMDeletedMessageWrapper)) {
			return false;
		}

		PMDeletedMessageWrapper pmDeletedMessageWrapper = (PMDeletedMessageWrapper)obj;

		if (Validator.equals(_pmDeletedMessage,
					pmDeletedMessageWrapper._pmDeletedMessage)) {
			return true;
		}

		return false;
	}

	/**
	 * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
	 */
	public PMDeletedMessage getWrappedPMDeletedMessage() {
		return _pmDeletedMessage;
	}

	@Override
	public PMDeletedMessage getWrappedModel() {
		return _pmDeletedMessage;
	}

	@Override
	public void resetOriginalValues() {
		_pmDeletedMessage.resetOriginalValues();
	}

	private PMDeletedMessage _pmDeletedMessage;
}