package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link Notif}.
 * </p>
 *
 * @author caret
 * @see Notif
 * @generated
 */
public class NotifWrapper implements Notif, ModelWrapper<Notif> {
    private Notif _notif;

    public NotifWrapper(Notif notif) {
        _notif = notif;
    }

    @Override
    public Class<?> getModelClass() {
        return Notif.class;
    }

    @Override
    public String getModelClassName() {
        return Notif.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("notifId", getNotifId());
        attributes.put("ownerId", getOwnerId());
        attributes.put("type", getType());
        attributes.put("discontinueDate", getDiscontinueDate());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long notifId = (Long) attributes.get("notifId");

        if (notifId != null) {
            setNotifId(notifId);
        }

        Long ownerId = (Long) attributes.get("ownerId");

        if (ownerId != null) {
            setOwnerId(ownerId);
        }

        String type = (String) attributes.get("type");

        if (type != null) {
            setType(type);
        }

        Date discontinueDate = (Date) attributes.get("discontinueDate");

        if (discontinueDate != null) {
            setDiscontinueDate(discontinueDate);
        }
    }

    /**
    * Returns the primary key of this notif.
    *
    * @return the primary key of this notif
    */
    @Override
    public long getPrimaryKey() {
        return _notif.getPrimaryKey();
    }

    /**
    * Sets the primary key of this notif.
    *
    * @param primaryKey the primary key of this notif
    */
    @Override
    public void setPrimaryKey(long primaryKey) {
        _notif.setPrimaryKey(primaryKey);
    }

    /**
    * Returns the notif ID of this notif.
    *
    * @return the notif ID of this notif
    */
    @Override
    public long getNotifId() {
        return _notif.getNotifId();
    }

    /**
    * Sets the notif ID of this notif.
    *
    * @param notifId the notif ID of this notif
    */
    @Override
    public void setNotifId(long notifId) {
        _notif.setNotifId(notifId);
    }

    /**
    * Returns the owner ID of this notif.
    *
    * @return the owner ID of this notif
    */
    @Override
    public long getOwnerId() {
        return _notif.getOwnerId();
    }

    /**
    * Sets the owner ID of this notif.
    *
    * @param ownerId the owner ID of this notif
    */
    @Override
    public void setOwnerId(long ownerId) {
        _notif.setOwnerId(ownerId);
    }

    /**
    * Returns the type of this notif.
    *
    * @return the type of this notif
    */
    @Override
    public java.lang.String getType() {
        return _notif.getType();
    }

    /**
    * Sets the type of this notif.
    *
    * @param type the type of this notif
    */
    @Override
    public void setType(java.lang.String type) {
        _notif.setType(type);
    }

    /**
    * Returns the discontinue date of this notif.
    *
    * @return the discontinue date of this notif
    */
    @Override
    public java.util.Date getDiscontinueDate() {
        return _notif.getDiscontinueDate();
    }

    /**
    * Sets the discontinue date of this notif.
    *
    * @param discontinueDate the discontinue date of this notif
    */
    @Override
    public void setDiscontinueDate(java.util.Date discontinueDate) {
        _notif.setDiscontinueDate(discontinueDate);
    }

    @Override
    public boolean isNew() {
        return _notif.isNew();
    }

    @Override
    public void setNew(boolean n) {
        _notif.setNew(n);
    }

    @Override
    public boolean isCachedModel() {
        return _notif.isCachedModel();
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        _notif.setCachedModel(cachedModel);
    }

    @Override
    public boolean isEscapedModel() {
        return _notif.isEscapedModel();
    }

    @Override
    public java.io.Serializable getPrimaryKeyObj() {
        return _notif.getPrimaryKeyObj();
    }

    @Override
    public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
        _notif.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
        return _notif.getExpandoBridge();
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.model.BaseModel<?> baseModel) {
        _notif.setExpandoBridgeAttributes(baseModel);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
        _notif.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.service.ServiceContext serviceContext) {
        _notif.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public java.lang.Object clone() {
        return new NotifWrapper((Notif) _notif.clone());
    }

    @Override
    public int compareTo(gov.va.caret.model.Notif notif) {
        return _notif.compareTo(notif);
    }

    @Override
    public int hashCode() {
        return _notif.hashCode();
    }

    @Override
    public com.liferay.portal.model.CacheModel<gov.va.caret.model.Notif> toCacheModel() {
        return _notif.toCacheModel();
    }

    @Override
    public gov.va.caret.model.Notif toEscapedModel() {
        return new NotifWrapper(_notif.toEscapedModel());
    }

    @Override
    public gov.va.caret.model.Notif toUnescapedModel() {
        return new NotifWrapper(_notif.toUnescapedModel());
    }

    @Override
    public java.lang.String toString() {
        return _notif.toString();
    }

    @Override
    public java.lang.String toXmlString() {
        return _notif.toXmlString();
    }

    @Override
    public void persist()
        throws com.liferay.portal.kernel.exception.SystemException {
        _notif.persist();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof NotifWrapper)) {
            return false;
        }

        NotifWrapper notifWrapper = (NotifWrapper) obj;

        if (Validator.equals(_notif, notifWrapper._notif)) {
            return true;
        }

        return false;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
     */
    public Notif getWrappedNotif() {
        return _notif;
    }

    @Override
    public Notif getWrappedModel() {
        return _notif;
    }

    @Override
    public void resetOriginalValues() {
        _notif.resetOriginalValues();
    }
}
