package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class NotifSoap implements Serializable {
    private long _notifId;
    private long _ownerId;
    private String _type;
    private Date _discontinueDate;

    public NotifSoap() {
    }

    public static NotifSoap toSoapModel(Notif model) {
        NotifSoap soapModel = new NotifSoap();

        soapModel.setNotifId(model.getNotifId());
        soapModel.setOwnerId(model.getOwnerId());
        soapModel.setType(model.getType());
        soapModel.setDiscontinueDate(model.getDiscontinueDate());

        return soapModel;
    }

    public static NotifSoap[] toSoapModels(Notif[] models) {
        NotifSoap[] soapModels = new NotifSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static NotifSoap[][] toSoapModels(Notif[][] models) {
        NotifSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new NotifSoap[models.length][models[0].length];
        } else {
            soapModels = new NotifSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static NotifSoap[] toSoapModels(List<Notif> models) {
        List<NotifSoap> soapModels = new ArrayList<NotifSoap>(models.size());

        for (Notif model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new NotifSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _notifId;
    }

    public void setPrimaryKey(long pk) {
        setNotifId(pk);
    }

    public long getNotifId() {
        return _notifId;
    }

    public void setNotifId(long notifId) {
        _notifId = notifId;
    }

    public long getOwnerId() {
        return _ownerId;
    }

    public void setOwnerId(long ownerId) {
        _ownerId = ownerId;
    }

    public String getType() {
        return _type;
    }

    public void setType(String type) {
        _type = type;
    }

    public Date getDiscontinueDate() {
        return _discontinueDate;
    }

    public void setDiscontinueDate(Date discontinueDate) {
        _discontinueDate = discontinueDate;
    }
}
